/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.price;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.mservice.api.price.QuoteService;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteConditonInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuoteAdvanceEngine;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteExpLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteStrategeLogProxy;

public class QuoteServiceImpl
implements QuoteService {
    private static final Log log = LogFactory.getLog(QuoteServiceImpl.class);

    @Override
    public Map<Long, Map<String, ?>> queryMapKeyIgnoreExp(Long[] orgIDs, String entityType, Map<String, Object> customerParam) {
        Map<String, Object> quoteResult;
        HashMap allKey = new HashMap();
        log.info("\u81ea\u52a8\u53d6\u4ef7\u5f00\u59cb ");
        Long[] dupOrgIDs = new Long[]{Long.valueOf("0")};
        if (orgIDs != null && orgIDs.length > 0) {
            dupOrgIDs = this.dealDuplicate(orgIDs);
        }
        ArrayList<PriceEntityKeyInfo> quoteKeyInfos = new ArrayList<PriceEntityKeyInfo>(dupOrgIDs.length);
        for (Long orgID : dupOrgIDs) {
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, orgID, entityType);){
                try {
                    if (customerParam == null) {
                        customerParam = new HashMap<String, Object>(1);
                    }
                    QuoteStrategeColl quoteStrategeColl = QuoteHelper.fetchQuoteSchemeFromST((Long)orgID, (String)entityType, customerParam);
                    PriceEntityKeyInfo qccInfo = QuoteHelper.getQuoteCommonConst((String)entityType, (QuoteStrategeColl)quoteStrategeColl);
                    quoteKeyInfos.add(qccInfo);
                    Map allProperties = QuoteHelper.getHeaderAndEntryKeysWithFlag((QuoteStrategeColl)quoteStrategeColl, (PriceEntityKeyInfo)qccInfo);
                    allKey.put(orgID, allProperties);
                }
                catch (KDBizException e) {
                    quoteResult = this.genExceptionResult(e);
                    this.recordExpLog(expLogProxy, quoteResult);
                    allKey.put(orgID, quoteResult);
                }
                catch (Exception e1) {
                    quoteResult = this.genExceptionResult(new KDBizException(e1.getMessage()));
                    this.recordExpLog(expLogProxy, quoteResult);
                    allKey.put(orgID, quoteResult);
                }
            }
        }
        try {
            this.crossOrgValidate(quoteKeyInfos);
        }
        catch (KDBizException e) {
            for (Long orgID : dupOrgIDs) {
                try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, orgID, entityType);){
                    quoteResult = this.genExceptionResult(e);
                    this.recordExpLog(expLogProxy, quoteResult);
                    allKey.put(orgID, quoteResult);
                }
            }
        }
        return allKey;
    }

    @Override
    public Map<Long, Map<String, ?>> quoteByMapIgnoreExpWithParam(Map<Long, List<Map<String, Object>>> propertiesMap, String entityType, Map<String, Object> customerParam) {
        HashMap allPriceMap = new HashMap();
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        propertiesMap.forEach((orgID, lists) -> {
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, orgID, entityType);){
                try {
                    DataSet quoteOriginDataSet;
                    QuoteStrategeColl quoteStrategeColl = QuoteHelper.fetchQuoteSchemeFromST((Long)orgID, (String)entityType, (Map)customerParam);
                    PriceEntityKeyInfo qccInfo = QuoteHelper.getQuoteCommonConst((String)entityType, (QuoteStrategeColl)quoteStrategeColl);
                    if (customerParam != null && "id".equals(customerParam.get("filter_model")) && customerParam.get("id_condition") != null) {
                        Map idsMap = (Map)customerParam.get("id_condition");
                        List billIDs = (List)idsMap.get(orgID);
                        quoteOriginDataSet = QuoteHelper.buildQuoteDataSetByIDs((Long[])billIDs.toArray(new Long[billIDs.size()]), (String)entityType, (QuoteStrategeColl)quoteStrategeColl, (PriceEntityKeyInfo)qccInfo);
                    } else {
                        quoteOriginDataSet = QuoteHelper.buildQuoteDataSetByMap((List)lists, (String)entityType, (QuoteStrategeColl)quoteStrategeColl, (PriceEntityKeyInfo)qccInfo);
                    }
                    DataSet quoteTotalDataSet = this.prepareQuoteRows(entityType, headType, (Long)orgID, quoteStrategeColl, qccInfo, quoteOriginDataSet);
                    HashMap priceAllMap = new HashMap();
                    List allStrateges = quoteStrategeColl.getQuoteStrateges();
                    for (int k = 0; k < allStrateges.size(); ++k) {
                        DynamicObject quoteStratege = (DynamicObject)allStrateges.get(k);
                        String strategePK = String.valueOf(quoteStratege.getPkValue());
                        StringBuilder filterStr = new StringBuilder("strategeid=");
                        filterStr.append(strategePK);
                        DataSet schemeOriginDataSet = k != quoteStrategeColl.getQuoteStrateges().size() - 1 ? quoteTotalDataSet.copy().filter(filterStr.toString()) : quoteTotalDataSet.filter(filterStr.toString());
                        QuoteParam param = new QuoteParam(schemeOriginDataSet, orgID, qccInfo, entityType);
                        param.getOtherParam().putAll(customerParam);
                        boolean isOpenLog = quoteStratege.getBoolean("isopenlog");
                        if (lists.size() > 50000) {
                            isOpenLog = false;
                        }
                        try (QuoteLogProxy logProxy = new QuoteLogProxy(isOpenLog, orgID, entityType, qccInfo, quoteStrategeColl, quoteStratege);){
                            if (customerParam != null && customerParam.get("auto") != null && "1".equals(customerParam.get("auto"))) {
                                logProxy.setAuto(true);
                            }
                            try {
                                QuoteAdvanceEngine engine = new QuoteAdvanceEngine(logProxy);
                                Map priceMap = engine.startQuote(quoteStrategeColl, quoteStratege, param);
                                priceAllMap.putAll(priceMap);
                                allPriceMap.put((Long)orgID, (Map<String, ?>)priceAllMap);
                                continue;
                            }
                            catch (KDBizException e) {
                                logProxy.setCancle(true);
                                throw e;
                            }
                            catch (Exception e1) {
                                logProxy.setCancle(true);
                                throw e1;
                            }
                        }
                    }
                }
                catch (KDBizException e) {
                    Map<String, Object> quoteResult = this.genExceptionResult(e);
                    this.recordExpLog(expLogProxy, quoteResult);
                    allPriceMap.put((Long)orgID, quoteResult);
                }
                catch (Exception e1) {
                    Map<String, Object> quoteResult = this.genExceptionResult(new KDBizException(e1.getMessage()));
                    this.recordExpLog(expLogProxy, quoteResult);
                    allPriceMap.put((Long)orgID, quoteResult);
                }
            }
        });
        return allPriceMap;
    }

    @Override
    public Map<Long, Map<String, ?>> quoteByIDsIgnoreExpWithParam(Map<Long, List<Long>> idsMap, String entityType, Map<String, Object> customerParam) {
        HashMap<Long, List<Map<String, Object>>> propertiesMap = new HashMap<Long, List<Map<String, Object>>>();
        idsMap.forEach((orgID, lists) -> {
            ArrayList listMap = new ArrayList();
            propertiesMap.put((Long)orgID, listMap);
        });
        customerParam.put("id_condition", idsMap);
        customerParam.put("filter_model", "id");
        return this.quoteByMapIgnoreExpWithParam(propertiesMap, entityType, customerParam);
    }

    private Map<String, Object> genExceptionResult(KDBizException e) {
        return this.setFailResult(e);
    }

    private Long[] dealDuplicate(Long[] orgIDs) {
        Long[] dupOrgIDs = new Long[]{};
        HashSet<Long> orgSets = new HashSet<Long>();
        for (int i = 0; i < orgIDs.length; ++i) {
            orgSets.add(orgIDs[i]);
        }
        dupOrgIDs = orgSets.toArray(dupOrgIDs);
        return dupOrgIDs;
    }

    private void recordExpLog(QuoteExpLogProxy expLogProxy, Map<String, Object> expResult) {
        expLogProxy.setLogResult(expResult.get("msg") != null ? expResult.get("msg").toString() : "");
        expLogProxy.setCancle(false);
    }

    private Map<String, Object> setFailResult(KDBizException e) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = ResManager.loadKDString((String)"\u53d6\u4ef7\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"QuoteServiceImpl_2", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)e.getMessage())) {
            String markMsg = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\u3002", (String)"QuoteServiceImpl_3", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
            if (!e.getMessage().contains(markMsg)) {
                result.put("msg", String.format(msg, e.getMessage()));
            } else {
                result.put("msg", String.format(msg, e.getMessage().replaceAll(markMsg, "")));
            }
        } else {
            result.put("msg", String.format(msg, ((Object)((Object)e)).getClass().getName()));
        }
        result.put("success", Boolean.FALSE);
        return result;
    }

    private DataSet prepareQuoteRows(String entityType, MainEntityType headType, Long orgID, QuoteStrategeColl quoteStrategeColl, PriceEntityKeyInfo qccInfo, DataSet quoteOriginDataSet) {
        if (quoteOriginDataSet != null) {
            Object conditonStr;
            DataSet quoteOriginDataSetCopy = quoteOriginDataSet.copy();
            DataSet quoteTotalDataSet = null;
            boolean isOpenLog = true;
            List allStrateges = quoteStrategeColl.getQuoteStrateges();
            for (int i = 0; i < allStrateges.size(); ++i) {
                DynamicObject quoteStratege = (DynamicObject)allStrateges.get(i);
                isOpenLog = isOpenLog && quoteStratege.getBoolean("isopenlog");
                DataSet quoteDataSet = null;
                List conditions = (List)quoteStrategeColl.getMapping().get(quoteStratege.getPkValue());
                for (int j = 0; j < conditions.size(); ++j) {
                    conditonStr = PriceHelper.dataTypeAdapte((QFilter)((QuoteConditonInfo)conditions.get(j)).getQs_preFilter(), (MainEntityType)headType);
                    quoteDataSet = quoteDataSet == null ? quoteOriginDataSet.filter((String)conditonStr) : quoteDataSet.union(quoteOriginDataSet.filter((String)conditonStr));
                }
                if (quoteDataSet != null) {
                    quoteDataSet = quoteDataSet.addField(String.valueOf(quoteStratege.getPkValue()), "strategeid");
                }
                quoteTotalDataSet = quoteTotalDataSet == null ? quoteDataSet : quoteTotalDataSet.union(quoteDataSet);
            }
            if (quoteTotalDataSet == null) {
                try {
                    if (quoteOriginDataSetCopy != null) {
                        quoteOriginDataSetCopy.close();
                    }
                    if (quoteOriginDataSet != null) {
                        quoteOriginDataSet.close();
                    }
                }
                catch (Throwable i) {
                    // empty catch block
                }
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7ec4\u7ec7\u672a\u7ef4\u62a4\u53d6\u4ef7\u7b56\u7565\u3002", (String)"QuoteHelper_3", (String)"scmc-plat-business", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            quoteTotalDataSet = quoteTotalDataSet.distinct();
            List props = qccInfo.getLEFTIDFIELDS();
            GroupbyDataSet groupby = quoteTotalDataSet.copy().groupBy(props.toArray(new String[props.size()]));
            DataSet resultG = groupby.count().finish();
            DataSet singleValueSet = resultG.copy().where("count = 1 ").select(props.toArray(new String[props.size()]));
            try {
                QuoteStrategeLogProxy strategeLogProxy = new QuoteStrategeLogProxy(isOpenLog, orgID, entityType, qccInfo);
                conditonStr = null;
                try {
                    DataSet multiValueSet = resultG.copy().where("count > 1 ").select(props.toArray(new String[props.size()]));
                    strategeLogProxy.setMultiStrategeDataSet(multiValueSet);
                    String filterStrN = new StringBuffer("strategeid").append(" ").append("is null").toString();
                    JoinHint hintN = new JoinHint();
                    hintN.setNullAsZero(true);
                    JoinDataSet resultSetN = quoteOriginDataSetCopy.join(quoteTotalDataSet.copy(), JoinType.LEFT).hint(hintN);
                    for (String key : props) {
                        resultSetN = resultSetN.on(key, key);
                    }
                    String[] fieldsN = new String[props.size()];
                    for (int u = 0; u < props.size(); ++u) {
                        fieldsN[u] = (String)props.get(u);
                    }
                    DataSet quoteResultNull = resultSetN.select(fieldsN, new String[]{"strategeid"}).finish().where(filterStrN);
                    strategeLogProxy.setMissedStrategeDataSet(quoteResultNull);
                }
                catch (Throwable multiValueSet) {
                    conditonStr = multiValueSet;
                    throw multiValueSet;
                }
                finally {
                    if (strategeLogProxy != null) {
                        if (conditonStr != null) {
                            try {
                                strategeLogProxy.close();
                            }
                            catch (Throwable multiValueSet) {
                                ((Throwable)conditonStr).addSuppressed(multiValueSet);
                            }
                        } else {
                            strategeLogProxy.close();
                        }
                    }
                }
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e1) {
                throw e1;
            }
            finally {
                try {
                    if (resultG != null) {
                        resultG.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            JoinDataSet resultSet = quoteTotalDataSet.join(singleValueSet, JoinType.INNER).hint(hint);
            for (String key : props) {
                resultSet = resultSet.on(key, key);
            }
            Field[] quoteFields = quoteTotalDataSet.getRowMeta().getFields();
            String[] fields = new String[quoteFields.length];
            for (int s = 0; s < quoteFields.length; ++s) {
                fields[s] = quoteFields[s].getName();
            }
            quoteTotalDataSet = resultSet.select(fields, new String[0]).finish();
            return quoteTotalDataSet;
        }
        String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\u3002", (String)"QuoteServiceImpl_3", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
        throw new KDBizException(message);
    }

    private void crossOrgValidate(List<PriceEntityKeyInfo> qccs) {
        HashSet entryNames = new HashSet();
        HashSet entryCounts = new HashSet();
        qccs.forEach(qccInfo -> {
            entryNames.add(qccInfo.getEntryName());
            entryCounts.add(qccInfo.getEntryCount());
        });
        if (entryCounts.size() > 1) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u5355\u5934\u548c\u5206\u5f55\u540c\u65f6\u53d6\u4ef7\u4ee5\u53ca\u591a\u5206\u5f55\u540c\u65f6\u53d6\u4ef7\u3002", (String)"QuoteServiceImpl_0", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (entryNames.size() > 1) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u540c\u4e00\u5355\u636e\u53d6\u4ef7\u65b9\u6848\u5728\u4e0d\u540c\u7ec4\u7ec7\u4e0b\u914d\u7f6e\u4e86\u4e0d\u540c\u7684\u53d6\u4ef7\u5206\u5f55\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u591a\u5206\u5f55\u53d6\u4ef7\u3002", (String)"QuoteServiceImpl_1", (String)"mpscmm-msbd-mservice", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }
}

