/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.price.update;

import java.util.HashMap;
import java.util.LinkedList;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class PriceCtlStrategyUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PriceCtlStrategyUpgradeServiceImpl.class);
    private static String[] T_BD_BASEDATAVIEW_FIELD = new String[]{"FCTRLVIEW", "FDISABLERID", "FDISABLEDATE"};
    private static String[] T_BD_CTRLSTRATEGY_FIELD = new String[]{"FNUMBER", "FBASEDATAID", "FCTRLVIEW", "FCUID", "FENABLE", "FSTATUS", "FCREATORID", "FCREATETIME", "FMODIFIERID", "FMODIFYTIME", "FDISABLERID", "FDISABLEDATE", "FMASTERID"};
    private static String[] T_BD_CTRLSTRATEGYDETAIL_FIELD = new String[]{"FSEQ", "FCREATEORGID", "FMANAGESTRATEGY", "FCTRLTYPE", "FCTRLSTRATEGY", "FISALLOWSHARE", "FISALLOWUPDATE"};
    private static String FENTRYID = "FENTRYID";
    private static String FID = "FID";
    private static String FBASEDATAVIEWID = "FBASEDATAVIEWID";
    private static char SPLIT = (char)44;
    private static char PARAM = (char)63;
    private static String T_BD_BASEDATAVIEW = "T_BD_BASEDATAVIEW";
    private static String T_BD_CTRLSTRATEGY = "T_BD_CTRLSTRATEGY";
    private static String T_BD_CTRLSTRATEGYDETAIL = "T_BD_CTRLSTRATEGYDETAIL";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        logger.info("PriceCtlStrategyUpgradeServiceImpl:\u4ef7\u683c\u7ba1\u7406\u67b6\u6784\u6cbb\u7406_\u7ba1\u63a7\u7b56\u7565\u63a7\u5236\u89c4\u5219\u5347\u7ea7");
        logger.info("priceCtlStrategy upgrade start.");
        try {
            if (!this.isExisted("sm_quotestrategy").booleanValue()) {
                this.buildCtlStrategy("sm_quotestrategy");
            }
            if (!this.isExisted("pm_quotestrategy").booleanValue()) {
                this.buildCtlStrategy("pm_quotestrategy");
            }
            this.syncDefaultctrlStrategy();
        }
        catch (Exception e) {
            logger.info("priceCtlStrategy upgrade occur exception.");
        }
        logger.info("priceCtlStrategy upgrade success.");
        return result;
    }

    private void syncDefaultctrlStrategy() {
        StringBuilder selectDefaultctrlStrategySql = new StringBuilder();
        selectDefaultctrlStrategySql.append("SELECT FDEFAULTCTRLSTRATEGY FROM T_BD_DEFAULTCTRLSTRATEGY WHERE FID = 1218864915322781696");
        String defaultCtrlStrategyParam = (String)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectDefaultctrlStrategySql.toString(), resultSet -> {
            String defaultCtrlStrategy = null;
            while (resultSet.next() && !StringUtils.isNotEmpty((String)(defaultCtrlStrategy = resultSet.getString("FDEFAULTCTRLSTRATEGY")))) {
            }
            return defaultCtrlStrategy;
        });
        if (StringUtils.isNotEmpty((String)defaultCtrlStrategyParam)) {
            try (TXHandle h = TX.required((String)this.getClass().getName());){
                try {
                    if (defaultCtrlStrategyParam != null) {
                        Object[] param = new Object[]{defaultCtrlStrategyParam};
                        String updateSQl = "UPDATE T_BD_DEFAULTCTRLSTRATEGY SET FDEFAULTCTRLSTRATEGY=? WHERE FID in (1558863007281328128,1558879205784039424)";
                        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSQl, (Object[])param);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    logger.info("DEFAULTCTRLSTRATEGY setdefaultvalue occur exception.");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildCtlStrategy(String newStrategyObj) {
        LinkedList insertBasedataViewParamList = new LinkedList();
        LinkedList insertCtrlStrategyParamList = new LinkedList();
        LinkedList insertCtrlStrategyDetailParamList = new LinkedList();
        StringBuilder selectBasedataViewSql = new StringBuilder("SELECT ");
        for (String string : T_BD_BASEDATAVIEW_FIELD) {
            selectBasedataViewSql.append(string).append(SPLIT);
        }
        selectBasedataViewSql.append(FID);
        selectBasedataViewSql.append(" FROM ").append(T_BD_BASEDATAVIEW).append(" WHERE ").append("FBASEDATAID").append(" = '");
        selectBasedataViewSql.append("plat_quotestrategy");
        selectBasedataViewSql.append("' ");
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectBasedataViewSql.toString(), resultSet -> {
            while (resultSet.next()) {
                Object[] insertObj = new Object[T_BD_BASEDATAVIEW_FIELD.length + 2];
                for (int j = 0; j < T_BD_BASEDATAVIEW_FIELD.length; ++j) {
                    insertObj[j] = resultSet.getObject(T_BD_BASEDATAVIEW_FIELD[j]);
                }
                insertObj[PriceCtlStrategyUpgradeServiceImpl.T_BD_BASEDATAVIEW_FIELD.length] = newStrategyObj;
                insertObj[PriceCtlStrategyUpgradeServiceImpl.T_BD_BASEDATAVIEW_FIELD.length + 1] = resultSet.getObject(FID);
                insertBasedataViewParamList.add(insertObj);
            }
            return null;
        });
        if (insertBasedataViewParamList.size() > 0) {
            HashMap<Object, Object> viewIDReplaceRecord = new HashMap<Object, Object>(16);
            String[] viewIDSet = DB.genStringIds((String)T_BD_BASEDATAVIEW, (int)insertBasedataViewParamList.size());
            for (int i = 0; i < insertBasedataViewParamList.size(); ++i) {
                Object[] objectArray = (Object[])insertBasedataViewParamList.get(i);
                Object origialViewID = objectArray[objectArray.length - 1];
                viewIDReplaceRecord.put(origialViewID, viewIDSet[i]);
                objectArray[objectArray.length - 1] = viewIDSet[i];
            }
            viewIDReplaceRecord.forEach((key, value) -> {
                StringBuilder selectCtrlStrategySql = new StringBuilder("SELECT ");
                for (String field : T_BD_CTRLSTRATEGY_FIELD) {
                    selectCtrlStrategySql.append(field).append(SPLIT);
                }
                selectCtrlStrategySql.append(FID);
                selectCtrlStrategySql.append(SPLIT);
                selectCtrlStrategySql.append(FBASEDATAVIEWID);
                selectCtrlStrategySql.append(" FROM ").append(T_BD_CTRLSTRATEGY).append(" WHERE ").append("FBASEDATAVIEWID").append(" = ");
                selectCtrlStrategySql.append(PARAM);
                DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectCtrlStrategySql.toString(), (Object[])new Object[]{key}, resultSet -> {
                    while (resultSet.next()) {
                        Object[] insertObj = new Object[T_BD_CTRLSTRATEGY_FIELD.length + 2];
                        for (int j = 0; j < T_BD_CTRLSTRATEGY_FIELD.length; ++j) {
                            insertObj[j] = resultSet.getObject(T_BD_CTRLSTRATEGY_FIELD[j]);
                        }
                        insertObj[PriceCtlStrategyUpgradeServiceImpl.T_BD_CTRLSTRATEGY_FIELD.length] = value;
                        insertObj[PriceCtlStrategyUpgradeServiceImpl.T_BD_CTRLSTRATEGY_FIELD.length + 1] = resultSet.getObject(FID);
                        insertCtrlStrategyParamList.add(insertObj);
                    }
                    return null;
                });
            });
            if (insertCtrlStrategyParamList.size() > 0) {
                HashMap<Object, Object> IDReplaceRecord = new HashMap<Object, Object>(16);
                long[] lArray = DB.genGlobalLongIds((int)insertCtrlStrategyParamList.size());
                for (int i = 0; i < insertCtrlStrategyParamList.size(); ++i) {
                    Object[] inserStrategyParam = (Object[])insertCtrlStrategyParamList.get(i);
                    Object origialID = inserStrategyParam[inserStrategyParam.length - 1];
                    IDReplaceRecord.put(origialID, lArray[i]);
                    inserStrategyParam[inserStrategyParam.length - 1] = lArray[i];
                }
                IDReplaceRecord.forEach((key, value) -> {
                    StringBuilder selectCtrlStrategyDetailSql = new StringBuilder("SELECT ");
                    for (String field : T_BD_CTRLSTRATEGYDETAIL_FIELD) {
                        selectCtrlStrategyDetailSql.append(field).append(SPLIT);
                    }
                    selectCtrlStrategyDetailSql.append(FID);
                    selectCtrlStrategyDetailSql.append(SPLIT);
                    selectCtrlStrategyDetailSql.append(FENTRYID);
                    selectCtrlStrategyDetailSql.append(" FROM ").append(T_BD_CTRLSTRATEGYDETAIL).append(" WHERE ").append("FID").append(" = ");
                    selectCtrlStrategyDetailSql.append(PARAM);
                    DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectCtrlStrategyDetailSql.toString(), (Object[])new Object[]{key}, resultSet -> {
                        while (resultSet.next()) {
                            Object[] insertObj = new Object[T_BD_CTRLSTRATEGYDETAIL_FIELD.length + 2];
                            for (int j = 0; j < T_BD_CTRLSTRATEGYDETAIL_FIELD.length; ++j) {
                                insertObj[j] = resultSet.getObject(T_BD_CTRLSTRATEGYDETAIL_FIELD[j]);
                            }
                            insertObj[PriceCtlStrategyUpgradeServiceImpl.T_BD_CTRLSTRATEGYDETAIL_FIELD.length] = value;
                            insertCtrlStrategyDetailParamList.add(insertObj);
                        }
                        return null;
                    });
                });
                if (insertCtrlStrategyDetailParamList.size() > 0) {
                    long[] detailIDSet = DB.genGlobalLongIds((int)insertCtrlStrategyParamList.size());
                    for (int i = 0; i < insertCtrlStrategyDetailParamList.size(); ++i) {
                        Object[] inserDetailParam = (Object[])insertCtrlStrategyDetailParamList.get(i);
                        inserDetailParam[inserDetailParam.length - 1] = detailIDSet[i];
                    }
                }
            }
        }
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                if (insertBasedataViewParamList.size() > 0) {
                    void var9_25;
                    StringBuilder buildViewSql = new StringBuilder("INSERT INTO ").append(T_BD_BASEDATAVIEW).append("(");
                    for (String field : T_BD_BASEDATAVIEW_FIELD) {
                        buildViewSql.append(field).append(SPLIT);
                    }
                    buildViewSql.append("FBASEDATAID").append(SPLIT).append(FID);
                    buildViewSql.append(") VALUES(");
                    boolean bl = false;
                    while (var9_25 < T_BD_BASEDATAVIEW_FIELD.length) {
                        buildViewSql.append(PARAM).append(SPLIT);
                        ++var9_25;
                    }
                    buildViewSql.append(PARAM).append(SPLIT).append(PARAM);
                    buildViewSql.append(')');
                    DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)buildViewSql.toString(), insertBasedataViewParamList);
                }
                if (insertCtrlStrategyParamList.size() > 0) {
                    void var9_28;
                    StringBuilder buildStrategySql = new StringBuilder("INSERT INTO ").append(T_BD_CTRLSTRATEGY).append("(");
                    for (String field : T_BD_CTRLSTRATEGY_FIELD) {
                        buildStrategySql.append(field).append(SPLIT);
                    }
                    buildStrategySql.append("FBASEDATAVIEWID").append(SPLIT).append(FID);
                    buildStrategySql.append(") VALUES(");
                    boolean bl = false;
                    while (var9_28 < T_BD_CTRLSTRATEGY_FIELD.length) {
                        buildStrategySql.append(PARAM).append(SPLIT);
                        ++var9_28;
                    }
                    buildStrategySql.append(PARAM).append(SPLIT).append(PARAM);
                    buildStrategySql.append(')');
                    DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)buildStrategySql.toString(), insertCtrlStrategyParamList);
                }
                if (insertCtrlStrategyDetailParamList.size() > 0) {
                    void var9_31;
                    StringBuilder buildDetailSql = new StringBuilder("INSERT INTO ").append(T_BD_CTRLSTRATEGYDETAIL).append("(");
                    for (String field : T_BD_CTRLSTRATEGYDETAIL_FIELD) {
                        buildDetailSql.append(field).append(SPLIT);
                    }
                    buildDetailSql.append(FID).append(SPLIT).append(FENTRYID);
                    buildDetailSql.append(") VALUES(");
                    boolean bl = false;
                    while (var9_31 < T_BD_CTRLSTRATEGYDETAIL_FIELD.length) {
                        buildDetailSql.append(PARAM).append(SPLIT);
                        ++var9_31;
                    }
                    buildDetailSql.append(PARAM).append(SPLIT).append(PARAM);
                    buildDetailSql.append(')');
                    DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)buildDetailSql.toString(), insertCtrlStrategyDetailParamList);
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.info("priceCtlStrategy insert occur exception.");
            }
        }
    }

    private Boolean isExisted(String fBasedataID) {
        StringBuilder existSQL = new StringBuilder("SELECT COUNT(1) NUM FROM ").append(T_BD_BASEDATAVIEW).append(" WHERE ").append("FBASEDATAID").append(" = '").append(fBasedataID).append("'");
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)existSQL.toString(), resultSet -> {
            while (resultSet.next()) {
                Long num = resultSet.getLong("NUM");
                if (num == null || !(num.doubleValue() > 0.0)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }
}

