/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.price.update;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class PriceModelUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PriceModelUpgradeServiceImpl.class);
    private static Set<String> SALBILLS = new HashSet<String>(Arrays.asList("sm_salorder", "im_saloutbill", "sm_quotationbill", "sm_delivernotice"));
    private static List<String> PURBILLS = Arrays.asList("pm_purorderbill", "pm_transferbill", "im_purinbill", "pm_vmisettle", "pm_purapplybill", "pm_om_purorderbill", "pm_requirapplybill", "sctm_scpo");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Object sourceEntityMap;
        UpgradeResult result = new UpgradeResult();
        logger.info("PriceModelUpgradeServiceImpl:\u4ef7\u683c\u7ba1\u7406\u67b6\u6784\u6cbb\u7406_\u5347\u7ea7\u6570\u636e");
        logger.info("priceModel updated start.");
        try {
            Map[] schemeSuccessMap = this.updateScheme();
            if (schemeSuccessMap != null) {
                logger.info("quoteStrategy updated start.");
                Map sourceConditionMap = schemeSuccessMap[0];
                sourceEntityMap = schemeSuccessMap[1];
                LinkedList updateEntryParamList = new LinkedList();
                DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"SELECT FID,FENTRYID, FQUOTESCHEMEID,FPRICESOURCEPRECON_TAG FROM T_PLAT_QUOTESTENTRY WHERE 1=1", arg_0 -> PriceModelUpgradeServiceImpl.lambda$beforeExecuteSqlWithResult$0(sourceConditionMap, (Map)sourceEntityMap, updateEntryParamList, arg_0));
                try (TXHandle h = TX.required((String)this.getClass().getName());){
                    try {
                        if (updateEntryParamList.size() > 0) {
                            String updateEntrySql = "UPDATE T_PLAT_QUOTESTENTRY SET FPRICESOURCEPRECON_TAG=?,FPRICESOURCEPRECONDESC=? WHERE FENTRYID = ?";
                            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateEntrySql, (List)updateEntryParamList);
                        }
                    }
                    catch (Exception e) {
                        h.markRollback();
                        logger.info("quoteStrategy update fail.");
                    }
                }
            }
            logger.info("quoteStrategy update success.");
        }
        catch (Exception e) {
            logger.info("priceModel update occur exception.");
        }
        try {
            logger.info("priceType updated start.");
            boolean isInit = true;
            DataSet priceTypeSet = DB.queryDataSet((String)"PriceModelUpgradeServiceImpl", (DBRoute)DBRoute.of((String)"scm"), (String)"select 1 from t_msbd_pricelisttype");
            sourceEntityMap = null;
            try {
                for (Row row : priceTypeSet) {
                    logger.info(row.toString());
                    isInit = false;
                    if (isInit) continue;
                    break;
                }
            }
            catch (Throwable updateEntryParamList) {
                sourceEntityMap = updateEntryParamList;
                throw updateEntryParamList;
            }
            finally {
                if (priceTypeSet != null) {
                    if (sourceEntityMap != null) {
                        try {
                            priceTypeSet.close();
                        }
                        catch (Throwable updateEntryParamList) {
                            ((Throwable)sourceEntityMap).addSuppressed(updateEntryParamList);
                        }
                    } else {
                        priceTypeSet.close();
                    }
                }
            }
            if (isInit) {
                List<String> copyFields = Arrays.asList("FID", "FNUMBER", "FNAME", "FSTATUS", "FCREATORID", "FMODIFIERID", "FENABLE", "FCREATETIME", "FMODIFYTIME", "FMASTERID", "FISPRESET", "FDESCRIPTION", "FISSTAIR");
                String copyTable = "T_BD_PRICELISTTYPE";
                String toTable = "T_MSBD_PRICELISTTYPE";
                List<String> copyFields_L = Arrays.asList("FPKID", "FID", "FLOCALEID", "FNAME", "FDESCRIPTION");
                String copyTable_L = "T_BD_PRICELISTTYPE_L";
                String toTable_L = "T_MSBD_PRICELISTTYPE_L";
                this.copyTable(copyFields, copyTable, toTable, "sbd", "scm");
                this.copyTable(copyFields_L, copyTable_L, toTable_L, "sbd", "scm");
            }
            logger.info("priceType update success.");
        }
        catch (Exception e) {
            logger.info("priceType update occur exception.");
        }
        logger.info("priceModel update success.");
        return result;
    }

    private Map[] updateScheme() {
        logger.info("quotescheme update start.");
        HashMap sourceConditionMap = new HashMap();
        HashMap sourceEntityMap = new HashMap();
        LinkedList insertEntryParamList = new LinkedList();
        LinkedList deleteEntryParamList = new LinkedList();
        LinkedList updateEntryParamList = new LinkedList();
        LinkedList updateUseParamList = new LinkedList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"SELECT FID,FUSE, FISPRESET,FQUOTEENTITY,FPRICESOURCEENTITY,FQUOTESRCCONDITION FROM T_PLAT_QUOTESCHEME WHERE 1=1", resultSet -> {
            while (resultSet.next()) {
                String ispreset = resultSet.getString("FISPRESET");
                String quoteSrcCondition = resultSet.getString("FQUOTESRCCONDITION");
                String priceSourceEntity = resultSet.getString("FPRICESOURCEENTITY");
                Long id = resultSet.getLong("FID");
                if ("0".equals(ispreset)) {
                    String useNow = resultSet.getString("FUSE");
                    String useReset = StringUtils.isNotEmpty((String)useNow) ? useNow : "pur";
                    String quoteEntity = resultSet.getString("FQUOTEENTITY");
                    if (StringUtils.isNotEmpty((String)quoteEntity)) {
                        String quoteApp = EntityMetadataCache.getDataEntityType((String)quoteEntity).getAppId();
                        if (SALBILLS.contains(quoteEntity) || "sm".equals(quoteApp) || "pms".equals(quoteApp)) {
                            useReset = "sal";
                        } else if (PURBILLS.contains(quoteEntity) || "pm".equals(quoteApp) || "pmp".equals(quoteApp)) {
                            useReset = "pur";
                        }
                    }
                    if (!useReset.equals(useNow)) {
                        Object[] updateUseParam = new Object[]{useReset, id};
                        updateUseParamList.add(updateUseParam);
                    }
                }
                sourceConditionMap.put(id.toString(), quoteSrcCondition);
                sourceEntityMap.put(id.toString(), priceSourceEntity);
            }
            return null;
        });
        AtomicInteger seqNew = new AtomicInteger(0);
        AtomicInteger insertNew = new AtomicInteger(0);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"SELECT FID,FENTRYID,FSEQ,FSOURCESIGNNAME,FSOURCESIGN,FQUOTEPATTERN,FQUOTESIGNNAME,FQUOTESIGN FROM T_PLAT_QUOTESCHEMEENTRY WHERE 1=1 ORDER BY FID,FSEQ", resultSet -> {
            Object[] insertEntryParam;
            while (resultSet.next()) {
                int seq = resultSet.getInt("fseq");
                if (seq == 1) {
                    seqNew.set(0);
                    insertNew.set(0);
                }
                if ("B".equals(resultSet.getString("FQUOTEPATTERN"))) {
                    Object[] deleteEntryParam = new Object[]{resultSet.getLong("FENTRYID")};
                    deleteEntryParamList.add(deleteEntryParam);
                    insertEntryParam = new Object[7];
                    insertEntryParam[0] = resultSet.getLong("fid");
                    insertEntryParam[2] = insertNew.incrementAndGet();
                    insertEntryParam[3] = resultSet.getString("FSOURCESIGNNAME");
                    insertEntryParam[4] = resultSet.getString("FSOURCESIGN");
                    insertEntryParam[5] = resultSet.getString("FQUOTESIGNNAME");
                    insertEntryParam[6] = resultSet.getString("FQUOTESIGN");
                    insertEntryParamList.add(insertEntryParam);
                    continue;
                }
                int reSeq = seqNew.incrementAndGet();
                if (seq == reSeq) continue;
                Object[] updateEntryParam = new Object[]{reSeq, resultSet.getLong("FENTRYID")};
                updateEntryParamList.add(updateEntryParam);
            }
            if (insertEntryParamList.size() > 0) {
                long[] idSet = DB.genGlobalLongIds((int)insertEntryParamList.size());
                for (int i = 0; i < insertEntryParamList.size(); ++i) {
                    insertEntryParam = (Object[])insertEntryParamList.get(i);
                    insertEntryParam[1] = idSet[i];
                }
            }
            return null;
        });
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                if (updateUseParamList.size() > 0) {
                    String updateUseSql = "UPDATE T_PLAT_QUOTESCHEME SET FUSE=? WHERE FID = ?";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateUseSql, updateUseParamList);
                }
                if (insertEntryParamList.size() > 0) {
                    String buildResultEntrySql = "INSERT INTO T_PLAT_QUOTESCHEMEENTRY_R(FID,FENTRYID,FSEQ,FSOURCESIGNNAMER,FSOURCESIGNR,FQUOTESIGNNAMER,FQUOTESIGNR) VALUES(?,?,?,?,?,?,?)";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)buildResultEntrySql, insertEntryParamList);
                }
                if (updateEntryParamList.size() > 0) {
                    String updateConditionEntrySql = "UPDATE T_PLAT_QUOTESCHEMEENTRY SET FSEQ=? WHERE FENTRYID = ?";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateConditionEntrySql, updateEntryParamList);
                }
                if (deleteEntryParamList.size() > 0) {
                    String deleteConditionEntrySql = "DELETE FROM T_PLAT_QUOTESCHEMEENTRY  WHERE FENTRYID = ?";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)deleteConditionEntrySql, deleteEntryParamList);
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.info("quotescheme update fail.");
                Map[] mapArray = null;
                if (h != null) {
                    if (var10_10 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var10_10.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return mapArray;
            }
        }
        logger.info("quotescheme update success.");
        return new Map[]{sourceConditionMap, sourceEntityMap};
    }

    private void copyTable(List<String> copyFields, String copyTable, String toTable, String fromRoute, String toRoute) {
        LinkedList insertTypeParamList = new LinkedList();
        String selecties = "select " + String.join((CharSequence)",", copyFields) + " FROM " + copyTable + " WHERE 1=1";
        DB.query((DBRoute)DBRoute.of((String)fromRoute), (String)selecties, resultSet -> {
            while (resultSet.next()) {
                Object[] insertTypeParam = new Object[copyFields.size()];
                for (int i = 0; i < copyFields.size(); ++i) {
                    insertTypeParam[i] = resultSet.getObject((String)copyFields.get(i));
                }
                insertTypeParamList.add(insertTypeParam);
            }
            return null;
        });
        if (insertTypeParamList.size() > 0) {
            StringBuilder buildInsertTypeSql = new StringBuilder("INSERT INTO ").append(toTable).append("(").append(String.join((CharSequence)",", copyFields)).append(") VALUES(");
            copyFields.replaceAll(t -> "?");
            buildInsertTypeSql.append(String.join((CharSequence)",", copyFields)).append(')');
            DB.executeBatch((DBRoute)DBRoute.of((String)toRoute), (String)buildInsertTypeSql.toString(), insertTypeParamList);
        }
    }

    private static /* synthetic */ Object lambda$beforeExecuteSqlWithResult$0(Map sourceConditionMap, Map sourceEntityMap, List updateEntryParamList, ResultSet resultSet) throws Exception {
        while (resultSet.next()) {
            Long entryID = resultSet.getLong("FENTRYID");
            String schemeID = resultSet.getString("FQUOTESCHEMEID");
            String pricesourceprecon_tag = resultSet.getString("FPRICESOURCEPRECON_TAG");
            if (!StringUtils.isNotEmpty((String)schemeID) || !StringUtils.isEmpty((String)pricesourceprecon_tag)) continue;
            Object[] updateEntryParam = new Object[3];
            String sourceCondition = (String)sourceConditionMap.get(schemeID);
            String sourceEntity = (String)sourceEntityMap.get(schemeID);
            if (!StringUtils.isNotEmpty((String)sourceEntity) || !StringUtils.isNotEmpty((String)sourceCondition)) continue;
            try {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)sourceCondition, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)sourceEntity), condition);
                filterBuilder.buildFilter(false);
                CRCondition crCondition = new CRCondition();
                crCondition.setFilterCondition(condition);
                String conditionNewJson = SerializationUtils.toJsonString((Object)crCondition);
                String exprDesc = filterBuilder.getFilterStringDesc();
                updateEntryParam[0] = conditionNewJson;
                updateEntryParam[1] = exprDesc;
                updateEntryParam[2] = entryID;
                updateEntryParamList.add(updateEntryParam);
            }
            catch (Exception ea) {
                logger.info("quoteStrategy update has exception.");
            }
        }
        return null;
    }
}

