/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.business.builder;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.FieldMapHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlSchemeInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlStrategyInfo;
import kd.mpscmm.msbd.datacontrol.business.untils.ExpressionUtils;

public class CtrlStrategyBulider {
    public static CtrlStrategyInfo bulid(String billId, String ctrlField) {
        if (CommonUtils.isNull((Object)billId) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        QFilter billfilter = new QFilter("bizbill", "=", (Object)billId);
        QFilter ctrlFieldfilter = new QFilter("ctrlfield", "=", (Object)ctrlField);
        QFilter enablefilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObject ctrlStrategy = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_datactrlstrategy", (QFilter[])new QFilter[]{billfilter, ctrlFieldfilter, enablefilter});
        if (ctrlStrategy == null) {
            return null;
        }
        CtrlStrategyInfo strategyInfo = new CtrlStrategyInfo();
        strategyInfo.setMBMappingId((Long)ctrlStrategy.getDynamicObject("billmapping").getPkValue());
        strategyInfo.setExistStrategyEntity(true);
        DynamicObjectCollection entrys = ctrlStrategy.getDynamicObjectCollection("entryentity");
        if (entrys == null) {
            return null;
        }
        strategyInfo.setSchemeExpression(entrys);
        String expression = strategyInfo.getSchemeExpression();
        List schemeIds = entrys.stream().map(dyn -> dyn.getDynamicObject("datactrlscheme").getPkValue()).collect(Collectors.toList());
        Map ctrlSchemes = BusinessDataServiceHelper.loadFromCache((Object[])schemeIds.toArray(), (String)"msbd_datactrlscheme");
        for (DynamicObject ctrlScheme : ctrlSchemes.values()) {
            if (ctrlScheme.getBoolean("enable")) {
                CtrlSchemeInfo ctrlSchemeInfo = new CtrlSchemeInfo();
                ctrlSchemeInfo.setNumber(ctrlScheme.getString("number"));
                ctrlSchemeInfo.setReturnObj(ctrlScheme.getString("returnobject"));
                ctrlSchemeInfo.setEntityId(ctrlScheme.getDynamicObject("datactrlentity").getString("number"));
                ctrlSchemeInfo.setMEMappingId((Long)ctrlScheme.getDynamicObject("entitymapping").getPkValue());
                ctrlSchemeInfo.setDataRangeQfilter(ctrlScheme.getString("areajson_tag"));
                DynamicObjectCollection schemeEntrys = ctrlScheme.getDynamicObjectCollection("entryentity");
                for (DynamicObject schemeEntry : schemeEntrys) {
                    String inputCondition = schemeEntry.getString("inputcondition");
                    String outputResult = schemeEntry.getString("outputresult");
                    if (!StringUtils.isNotEmpty((CharSequence)inputCondition) || !StringUtils.isNotEmpty((CharSequence)outputResult)) continue;
                    ctrlSchemeInfo.getInputConditionList().add(inputCondition);
                    ctrlSchemeInfo.getOutputResultList().add(outputResult);
                }
                strategyInfo.getCtrlSchemeColl().put(ctrlSchemeInfo.getNumber(), ctrlSchemeInfo);
                continue;
            }
            if (expression == null) continue;
            expression = ExpressionUtils.removeString(expression, ctrlScheme.getString("number"));
        }
        if (CommonUtils.isNull(strategyInfo.getCtrlSchemeColl())) {
            return null;
        }
        if (expression != null) {
            strategyInfo.setSchemeExpression(expression.replaceAll("\\s+", ""));
        }
        CtrlStrategyBulider.initMapping(strategyInfo);
        return strategyInfo;
    }

    public static CtrlStrategyInfo bulid(Set<String> numbers, String expression) {
        CtrlStrategyInfo strategyInfo = new CtrlStrategyInfo();
        strategyInfo.setExistStrategyEntity(false);
        QFilter billfilter = new QFilter("number", "in", numbers);
        Map ctrlschemes = BusinessDataServiceHelper.loadFromCache((String)"msbd_datactrlscheme", (QFilter[])new QFilter[]{billfilter});
        if (CommonUtils.isNull((Object)ctrlschemes)) {
            return null;
        }
        for (DynamicObject ctrlScheme : ctrlschemes.values()) {
            if (ctrlScheme.getBoolean("enable")) {
                CtrlSchemeInfo ctrlSchemeInfo = new CtrlSchemeInfo();
                ctrlSchemeInfo.setNumber(ctrlScheme.getString("number"));
                ctrlSchemeInfo.setReturnObj(ctrlScheme.getString("returnobject"));
                ctrlSchemeInfo.setEntityId(ctrlScheme.getDynamicObject("datactrlentity").getString("number"));
                ctrlSchemeInfo.setMEMappingId((Long)ctrlScheme.getDynamicObject("entitymapping").getPkValue());
                Map emMapping = FieldMapHelper.getFieldMapById((Long)ctrlSchemeInfo.getMEMappingId(), (String)"target");
                ctrlSchemeInfo.getMEMapping().setModelMapping(emMapping);
                ctrlSchemeInfo.setDataRangeQfilter(ctrlScheme.getString("areajson_tag"));
                DynamicObjectCollection schemeEntrys = ctrlScheme.getDynamicObjectCollection("entryentity");
                for (DynamicObject schemeEntry : schemeEntrys) {
                    String inputCondition = schemeEntry.getString("inputcondition");
                    String outputResult = schemeEntry.getString("outputresult");
                    if (!StringUtils.isNotEmpty((CharSequence)inputCondition) || !StringUtils.isNotEmpty((CharSequence)outputResult)) continue;
                    ctrlSchemeInfo.getInputConditionList().add(inputCondition);
                    ctrlSchemeInfo.getOutputResultList().add(outputResult);
                }
                strategyInfo.getCtrlSchemeColl().put(ctrlSchemeInfo.getNumber(), ctrlSchemeInfo);
                continue;
            }
            if (expression == null) continue;
            expression = ExpressionUtils.removeString(expression, ctrlScheme.getString("number"));
        }
        if (CommonUtils.isNull(strategyInfo.getCtrlSchemeColl())) {
            return null;
        }
        if (expression != null) {
            strategyInfo.setSchemeExpression(expression.replaceAll("\\s+", ""));
        }
        return strategyInfo;
    }

    private static void initMapping(CtrlStrategyInfo strategyInfo) {
        if (strategyInfo == null) {
            return;
        }
        Map mbMaping = FieldMapHelper.getFieldMapById((Long)strategyInfo.getMBMappingId(), (String)"target");
        strategyInfo.getMBMapping().setModelMapping(mbMaping);
        Map<String, CtrlSchemeInfo> ctrlSchemeColl = strategyInfo.getCtrlSchemeColl();
        if (!CommonUtils.isNull(ctrlSchemeColl)) {
            for (CtrlSchemeInfo scheme : ctrlSchemeColl.values()) {
                Map meMapping = FieldMapHelper.getFieldMapById((Long)scheme.getMEMappingId(), (String)"target");
                scheme.getMEMapping().setModelMapping(meMapping);
            }
        }
    }
}

