/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.business.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datacontrol.business.builder.CtrlStrategyBulider;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlSchemeInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlStrategyInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.ModelMapping;
import kd.mpscmm.msbd.datacontrol.business.service.DataCtrlService;

public class DataCtrlServiceHelper {
    private static final Log log = LogFactory.getLog(DataCtrlServiceHelper.class);

    public static QFilter getQfilter(DynamicObject bill, String ctrlField) {
        return DataCtrlServiceHelper.getQfilter(bill, bill.getDataEntityType().getName(), ctrlField);
    }

    public static QFilter getQfilter(DynamicObject entity, String formId, String ctrlField) {
        if (CommonUtils.isNull((Object)entity) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        Map<String, Set<Long>> ctrlData = DataCtrlServiceHelper.getCtrlData(entity, formId, ctrlField);
        if (ctrlData == null) {
            return null;
        }
        Set<Long> allowSet = ctrlData.get("ALLOW_DATA");
        Set<Long> limitSet = ctrlData.get("LIMIT_DATA");
        if (allowSet.size() > 500000 || limitSet.size() > 500000) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        QFilter qFilter = null;
        String qFilterProp = null;
        String[] ctrlFieldSplit = ctrlField.split("\\.");
        qFilterProp = "masterid".equals(ctrlFieldSplit[ctrlFieldSplit.length - 1]) ? "masterid" : "id";
        if (allowSet.size() > 0) {
            qFilter = new QFilter(qFilterProp, "in", allowSet);
        }
        if (allowSet.size() == 0 && limitSet.size() > 0) {
            qFilter = new QFilter(qFilterProp, "not in", limitSet);
        }
        if (qFilter == null) {
            qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        return qFilter;
    }

    public static QFilter getQfilterByScheme(Map<String, Map<String, Object>> map, String qFilterProp, String expression) {
        if (CommonUtils.isNull(map) || CommonUtils.isNull((Object)qFilterProp)) {
            return null;
        }
        Map<String, Set<Long>> ctrlData = DataCtrlServiceHelper.getCtrlDataByScheme(map, expression);
        if (ctrlData == null) {
            return null;
        }
        Set<Long> allowSet = ctrlData.get("ALLOW_DATA");
        Set<Long> limitSet = ctrlData.get("LIMIT_DATA");
        if (allowSet.size() > 500000 || limitSet.size() > 500000) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        QFilter qFilter = null;
        if (allowSet.size() > 0) {
            qFilter = new QFilter(qFilterProp, "in", allowSet);
        }
        if (allowSet.size() == 0 && limitSet.size() > 0) {
            qFilter = new QFilter(qFilterProp, "not in", limitSet);
        }
        if (qFilter == null) {
            qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        return qFilter;
    }

    public static Map<Long, Map<Long, Boolean>> checkBatchData(DynamicObject[] bills, String ctrlField) {
        if (CommonUtils.isNull((Object)bills) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        HashMap<Long, Map<Long, Boolean>> result = new HashMap<Long, Map<Long, Boolean>>(8);
        HashMap<String, Map<String, Set<Long>>> cacheMap = new HashMap<String, Map<String, Set<Long>>>();
        for (DynamicObject bill : bills) {
            Map<Long, Boolean> ctrlData = DataCtrlServiceHelper.checkDataFromCache(bill, bill.getDataEntityType().getName(), ctrlField, cacheMap);
            result.put((Long)bill.getPkValue(), ctrlData);
        }
        return result;
    }

    public static Map<Long, Map<Long, Boolean>> checkBatchData(DynamicObject[] entitys, String formId, String ctrlField) {
        if (CommonUtils.isNull((Object)entitys) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        HashMap<Long, Map<Long, Boolean>> result = new HashMap<Long, Map<Long, Boolean>>(8);
        HashMap<String, Map<String, Set<Long>>> cacheMap = new HashMap<String, Map<String, Set<Long>>>();
        for (DynamicObject entity : entitys) {
            Map<Long, Boolean> ctrlData = DataCtrlServiceHelper.checkDataFromCache(entity, formId, ctrlField, cacheMap);
            result.put((Long)entity.getPkValue(), ctrlData);
        }
        return result;
    }

    public static Map<Long, Boolean> checkData(DynamicObject bill, String ctrlField) {
        if (CommonUtils.isNull((Object)bill) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        return DataCtrlServiceHelper.checkDataFromCache(bill, bill.getDataEntityType().getName(), ctrlField, null);
    }

    public static Map<Long, Boolean> checkData(DynamicObject bill, String formId, String ctrlField) {
        if (CommonUtils.isNull((Object)bill) || CommonUtils.isNull((Object)formId) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        return DataCtrlServiceHelper.checkDataFromCache(bill, formId, ctrlField, null);
    }

    public static Map<Object, Map<Long, Boolean>> checkBatchDataByScheme(Map<Object, Map<String, Map<String, Object>>> paraMap, Map<Object, Set<Long>> dataColl, Map<Object, String> expressions) {
        if (CommonUtils.isNull(paraMap) || CommonUtils.isNull(dataColl)) {
            return null;
        }
        log.info("ctrlData_param1:" + paraMap);
        log.info("ctrlData_param2:" + dataColl);
        HashMap<Object, Map<Long, Boolean>> result = new HashMap<Object, Map<Long, Boolean>>(8);
        HashMap<String, Map<String, Set<Long>>> cacheMap = new HashMap<String, Map<String, Set<Long>>>();
        for (Map.Entry<Object, Map<String, Map<String, Object>>> next : paraMap.entrySet()) {
            Set<Long> datas = dataColl.get(next.getKey());
            String expression = null;
            if (expressions != null) {
                expression = expressions.get(next.getKey());
            }
            Map<Long, Boolean> checkResult = DataCtrlServiceHelper.checkDataFromCache(next.getValue(), datas, expression, cacheMap);
            result.put(next.getKey(), checkResult);
        }
        log.info("ctrlData_result:" + result);
        return result;
    }

    public static Map<Long, Boolean> checkDataByScheme(Map<String, Map<String, Object>> map, Set<Long> datas, String expression) {
        if (CommonUtils.isNull(map) || CommonUtils.isNull(datas)) {
            return null;
        }
        return DataCtrlServiceHelper.checkDataFromCache(map, datas, expression, null);
    }

    public static Map<String, Set<Long>> getCtrlData(DynamicObject bill, String ctrlField) {
        if (CommonUtils.isNull((Object)bill) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        return DataCtrlServiceHelper.getCtrlData(bill, bill.getDataEntityType().getName(), ctrlField);
    }

    public static Map<String, Set<Long>> getCtrlData(DynamicObject entity, String formId, String ctrlField) {
        if (CommonUtils.isNull((Object)entity) || CommonUtils.isNull((Object)formId) || CommonUtils.isNull((Object)ctrlField)) {
            return null;
        }
        return DataCtrlServiceHelper.getCtrlDataByBillFromCache(entity, formId, ctrlField, null);
    }

    public static Map<String, Set<Long>> getCtrlDataByScheme(Map<String, Map<String, Object>> map, String expression) {
        if (CommonUtils.isNull(map)) {
            return null;
        }
        return DataCtrlServiceHelper.getCtrlDataByMapFromCache(map, expression, null);
    }

    private static Map<Long, Boolean> checkDataFromCache(DynamicObject bill, String formId, String ctrlField, Map<String, Map<String, Set<Long>>> cacheMap) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(8);
        Map<String, Set<Long>> ctrlData = DataCtrlServiceHelper.getCtrlDataByBillFromCache(bill, formId, ctrlField, cacheMap);
        if (ctrlData == null) {
            return null;
        }
        Set<Long> allowSet = ctrlData.get("ALLOW_DATA");
        Set<Long> limitSet = ctrlData.get("LIMIT_DATA");
        Set<Long> billData = DataCtrlServiceHelper.getBillData(bill, ctrlField);
        for (Long data : billData) {
            if (allowSet.size() > 0) {
                if (!allowSet.contains(data)) {
                    resultMap.put(data, Boolean.FALSE);
                    continue;
                }
                resultMap.put(data, Boolean.TRUE);
                continue;
            }
            if (limitSet.size() > 0) {
                if (limitSet.contains(data)) {
                    resultMap.put(data, Boolean.FALSE);
                    continue;
                }
                resultMap.put(data, Boolean.TRUE);
                continue;
            }
            resultMap.put(data, Boolean.FALSE);
        }
        return resultMap;
    }

    private static Map<Long, Boolean> checkDataFromCache(Map<String, Map<String, Object>> map, Set<Long> datas, String expression, Map<String, Map<String, Set<Long>>> cacheMap) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(8);
        Map<String, Set<Long>> ctrlData = DataCtrlServiceHelper.getCtrlDataByMapFromCache(map, expression, cacheMap);
        if (ctrlData == null) {
            return null;
        }
        Set<Long> allowSet = ctrlData.get("ALLOW_DATA");
        Set<Long> limitSet = ctrlData.get("LIMIT_DATA");
        for (Long data : datas) {
            if (allowSet.size() > 0) {
                if (!allowSet.contains(data)) {
                    resultMap.put(data, Boolean.FALSE);
                    continue;
                }
                resultMap.put(data, Boolean.TRUE);
                continue;
            }
            if (limitSet.size() > 0) {
                if (limitSet.contains(data)) {
                    resultMap.put(data, Boolean.FALSE);
                    continue;
                }
                resultMap.put(data, Boolean.TRUE);
                continue;
            }
            resultMap.put(data, Boolean.FALSE);
        }
        return resultMap;
    }

    private static Map<String, Set<Long>> getCtrlDataByBillFromCache(DynamicObject entity, String formId, String ctrlField, Map<String, Map<String, Set<Long>>> cacheMap) {
        try {
            if (CommonUtils.isNull((Object)entity) || CommonUtils.isNull((Object)ctrlField)) {
                return null;
            }
            CtrlStrategyInfo strategyInfo = CtrlStrategyBulider.bulid(formId, ctrlField);
            if (strategyInfo == null) {
                return null;
            }
            ModelMapping mbMapping = strategyInfo.getMBMapping();
            Map<String, String> mbMap = mbMapping.getModelMapping();
            Map<String, Object> mbRvMap = mbMapping.getRightValueMap();
            HashSet conditionSet = new HashSet(8);
            Map<String, CtrlSchemeInfo> ctrlSchemeColl = strategyInfo.getCtrlSchemeColl();
            ctrlSchemeColl.forEach((i, j) -> j.getInputConditionList().forEach(k -> {
                String[] conditionFields;
                for (String conditionField : conditionFields = k.split(",")) {
                    conditionSet.add(conditionField);
                }
            }));
            Iterator<Map.Entry<String, String>> it = mbMap.entrySet().iterator();
            StringBuilder cacheKey = new StringBuilder();
            while (it.hasNext()) {
                DynamicObject value;
                Map.Entry<String, String> entry = it.next();
                if (!conditionSet.contains(entry.getKey()) || (value = entity.getDynamicObject(entry.getValue())) == null) continue;
                mbRvMap.put(entry.getValue(), value.getPkValue());
                if (cacheMap == null) continue;
                cacheKey.append(value.getPkValue());
            }
            mbMapping.convert2LVMap();
            if (cacheMap != null) {
                if (cacheMap.get(cacheKey.toString()) != null) {
                    return cacheMap.get(cacheKey.toString());
                }
                Map<String, Set<Long>> result = DataCtrlService.calcuCtrlData(strategyInfo);
                cacheMap.put(cacheKey.toString(), result);
                return result;
            }
            return DataCtrlService.calcuCtrlData(strategyInfo);
        }
        catch (Exception e) {
            log.info("getCtrlDataByBill_error:" + Arrays.toString(e.getStackTrace()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6570\u636e\u63a7\u5236\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u63a7\u5236\u65b9\u6848\u6216\u6570\u636e\u6e90\u4e0e\u6570\u636e\u63a7\u5236\u6a21\u578b\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"DataCtrlServiceHelper_0", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]), new Object[0]));
        }
    }

    private static Map<String, Set<Long>> getCtrlDataByMapFromCache(Map<String, Map<String, Object>> map, String expression, Map<String, Map<String, Set<Long>>> cacheMap) {
        if (CommonUtils.isNull(map)) {
            return null;
        }
        try {
            CtrlStrategyInfo strategyInfo = CtrlStrategyBulider.bulid(map.keySet(), expression);
            if (strategyInfo == null) {
                return null;
            }
            ModelMapping mbMapping = strategyInfo.getMBMapping();
            Map<String, Object> mbLvMap = mbMapping.getLeftValueMap();
            map.values().forEach(mbLvMap::putAll);
            StringBuilder cacheKey = new StringBuilder();
            mbLvMap.values().forEach(cacheKey::append);
            if (cacheMap != null) {
                if (cacheMap.get(cacheKey.toString()) != null) {
                    return cacheMap.get(cacheKey.toString());
                }
                Map<String, Set<Long>> result = DataCtrlService.calcuCtrlData(strategyInfo);
                cacheMap.put(cacheKey.toString(), result);
                return result;
            }
            return DataCtrlService.calcuCtrlData(strategyInfo);
        }
        catch (Exception e) {
            log.info("getCtrlDataByMap_error:" + Arrays.toString(e.getStackTrace()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6570\u636e\u63a7\u5236\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u63a7\u5236\u65b9\u6848\u6216\u6570\u636e\u6e90\u4e0e\u6570\u636e\u63a7\u5236\u6a21\u578b\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"DataCtrlServiceHelper_0", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]), new Object[0]));
        }
    }

    private static Set<Long> getBillData(DynamicObject bill, String ctrlField) {
        try {
            String[] fields = ctrlField.split("\\.");
            Set<Long> values = DataCtrlServiceHelper.getAllValues(bill, fields, 0);
            return values;
        }
        catch (Exception e) {
            log.info("getBillData_error:" + Arrays.toString(e.getStackTrace()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u63a7\u5236\u670d\u52a1\u83b7\u53d6\u5355\u636e\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u63a7\u5236\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u3002", (String)"DataCtrlServiceHelper_1", (String)"mpscmm-msbd-datacontrol", (Object[])new Object[0]), new Object[0]));
        }
    }

    private static Set<Long> getAllValues(DynamicObject bill, String[] fields, int i) {
        HashSet<Long> valueSet = new HashSet<Long>(8);
        if (bill == null || fields == null || i >= fields.length) {
            return valueSet;
        }
        if (bill.get(fields[i]) != null && bill.get(fields[i]) instanceof DynamicObject) {
            if ("material".equals(fields[i]) && i + 1 < fields.length && "masterid".equals(fields[i + 1])) {
                valueSet.add((Long)bill.getDynamicObject("material").getDynamicObject("masterid").getPkValue());
            } else {
                valueSet.add((Long)bill.getDynamicObject(fields[i]).getPkValue());
            }
        } else if (bill.get(fields[i]) instanceof DynamicObjectCollection) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(fields[i]);
            ++i;
            for (DynamicObject entry : entrys) {
                valueSet.addAll(DataCtrlServiceHelper.getAllValues(entry, fields, i));
            }
        }
        return valueSet;
    }
}

