/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datacontrol.business.helper.ExpointHelper;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlDataInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlSchemeInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlStrategyInfo;
import kd.mpscmm.msbd.datacontrol.business.untils.ExpressionUtils;

public class CtrlDataProcessor {
    private CtrlStrategyInfo strategyInfo = new CtrlStrategyInfo();
    private Set<Long> allowData = new HashSet<Long>();
    private Set<Long> limitData = new HashSet<Long>();

    public Set<Long> getAllowData() {
        return this.allowData;
    }

    public Set<Long> getLimitData() {
        return this.limitData;
    }

    private CtrlDataProcessor() {
    }

    public CtrlDataProcessor(CtrlStrategyInfo strategyInfo) {
        this.strategyInfo = strategyInfo;
    }

    protected void processData(List<CtrlDataInfo> dataList) {
        if (CommonUtils.isNull(dataList)) {
            return;
        }
        HashMap<String, List> schemeDataInfoMap = new HashMap<String, List>(8);
        HashMap<String, Set<Long>> schemeDataMap = new HashMap<String, Set<Long>>(8);
        for (CtrlDataInfo dataInfo : dataList) {
            List schemeList = schemeDataInfoMap.computeIfAbsent(dataInfo.getCtrlScheme(), k -> new ArrayList());
            schemeList.add(dataInfo);
        }
        for (Map.Entry next : schemeDataInfoMap.entrySet()) {
            CtrlSchemeInfo schemeInfo = this.strategyInfo.getCtrlSchemeColl().get(next.getKey());
            List schemeList = (List)next.getValue();
            HashSet<Long> allowDatasByScheme = new HashSet<Long>(8);
            HashSet<Long> limitDatasByScheme = new HashSet<Long>(8);
            HashMap<String, Set<Long>> notMatchAllowMap = new HashMap<String, Set<Long>>(8);
            HashMap<String, Set<Long>> notMatchLimitMap = new HashMap<String, Set<Long>>(8);
            String returnlObj = schemeInfo.getReturnObj();
            for (CtrlDataInfo dataInfo : schemeList) {
                Set datas;
                String outputResult = dataInfo.getOutputResult();
                if (dataInfo.isAllow().booleanValue()) {
                    if (outputResult.equals(returnlObj)) {
                        allowDatasByScheme.add(dataInfo.getData());
                        continue;
                    }
                    datas = notMatchAllowMap.computeIfAbsent(dataInfo.getOutputResult(), k -> new HashSet(8));
                    datas.add(dataInfo.getData());
                    continue;
                }
                if (outputResult.equals(returnlObj)) {
                    limitDatasByScheme.add(dataInfo.getData());
                    continue;
                }
                datas = notMatchLimitMap.computeIfAbsent(dataInfo.getOutputResult(), k -> new HashSet(8));
                datas.add(dataInfo.getData());
            }
            ExpointHelper.beforeCalculate(schemeInfo, notMatchAllowMap, allowDatasByScheme);
            ExpointHelper.beforeCalculate(schemeInfo, notMatchLimitMap, limitDatasByScheme);
            if (allowDatasByScheme.size() > 0) {
                schemeDataMap.put((String)next.getKey(), (Set<Long>)allowDatasByScheme);
            }
            if (limitDatasByScheme.size() > 0) {
                this.limitData.addAll(limitDatasByScheme);
            }
            if (allowDatasByScheme.size() != 0 || limitDatasByScheme.size() <= 0 || !StringUtils.isNotEmpty((CharSequence)this.strategyInfo.getSchemeExpression())) continue;
            String expression = ExpressionUtils.removeString(this.strategyInfo.getSchemeExpression(), (String)next.getKey());
            this.strategyInfo.setSchemeExpression(expression);
        }
        if (schemeDataMap.size() > 0) {
            if (StringUtils.isNotEmpty((CharSequence)this.strategyInfo.getSchemeExpression())) {
                this.allowData = ExpressionUtils.evaluateExpression(this.strategyInfo.getSchemeExpression(), schemeDataMap);
            } else {
                Set firstSet = schemeDataMap.values().stream().findFirst().orElse(null);
                if (firstSet != null) {
                    schemeDataMap.values().stream().forEach(firstSet::retainAll);
                }
                this.allowData.addAll(firstSet);
            }
            if (this.allowData.size() == 0) {
                this.limitData.clear();
                return;
            }
        }
        if (this.allowData.size() > 0 && this.limitData.size() > 0) {
            this.allowData.removeAll(this.limitData);
            this.limitData.clear();
        }
    }
}

