/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datacontrol.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.FieldMapHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class DataCtrlSchemePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataCtrlEntity = (BasedataEdit)this.getView().getControl("datactrlentity");
        if (dataCtrlEntity != null) {
            dataCtrlEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initAreaFilter(null);
    }

    public void afterCopyData(EventObject e) {
        this.initAreaFilter((DynamicObject)this.getModel().getValue("datactrlentity"));
    }

    public void beforeBindData(EventObject e) {
        DynamicObject entityMapping;
        DynamicObject entity = (DynamicObject)this.getModel().getValue("datactrlentity");
        if (!CommonUtils.isNull((Object)entity)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setEntityNumber(entity.getString("number"));
            this.getView().updateView("areafilter");
            String areajson = this.getModel().getDataEntity().getString("areajson_tag");
            FilterCondition condition = CommonUtils.isNull((Object)areajson) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)areajson, FilterCondition.class);
            filterGrid.SetValue(condition);
            this.getView().updateView("areafilter");
        }
        if (!CommonUtils.isNull((Object)(entityMapping = (DynamicObject)this.getModel().getValue("entitymapping")))) {
            this.initComboItems(entityMapping);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "datactrlentity": {
                List srcbills;
                QFilter qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
                QFilter mappingQfilter = new QFilter("targetobj", "=", (Object)"msbd_datactrlmodel");
                mappingQfilter.and(new QFilter("isenable", "=", (Object)true));
                Map mappings = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{mappingQfilter});
                if (!CommonUtils.isNull((Object)mappings) && !CommonUtils.isNull(srcbills = mappings.values().stream().filter(dyn -> dyn.get("sourcebill") != null).map(dyn -> dyn.getDynamicObject("sourcebill").getPkValue()).collect(Collectors.toList()))) {
                    qFilter = new QFilter("id", "in", srcbills);
                }
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (fieldKey) {
            case "datactrlentity": {
                this.changeDataCtrlEntity(changeSet);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
            FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
            model.setValue("areajson_tag", (Object)SerializationUtils.toJsonString((Object)condition));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            Map targetMap;
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            DynamicObject entityMapping = (DynamicObject)this.getModel().getValue("entitymapping");
            if (entityMapping != null && (targetMap = FieldMapHelper.getFieldMapById((Long)((Long)entityMapping.getPkValue()), (String)"target")).get("org") != null) {
                for (int i = 0; i < rowDataEntities.length; ++i) {
                    RowDataEntity rowDataEntity = rowDataEntities[i];
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.getModel().setValue("inputcondition", (Object)"org", rowIndex);
                }
            }
        }
    }

    private void changeDataCtrlEntity(ChangeData[] changeSet) {
        Object newValue = changeSet[0].getNewValue();
        IDataModel model = this.getModel();
        model.setValue("returnobject", null);
        if (newValue != null) {
            DynamicObject entity = (DynamicObject)newValue;
            QFilter targetQfilter = new QFilter("targetobj", "=", (Object)"msbd_datactrlmodel");
            QFilter sourceQfilter = new QFilter("sourcebill", "=", (Object)entity.getString("number"));
            DynamicObject mappings = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{targetQfilter, sourceQfilter});
            model.setValue("entitymapping", (Object)mappings);
            this.initComboItems(mappings);
            this.initAreaFilter((DynamicObject)mappings.get("sourcebill"));
            model.deleteEntryData("entryentity");
            int rowIndex = model.createNewEntryRow("entryentity");
            Set collect = mappings.getDynamicObjectCollection("colsmap").stream().map(dyn -> dyn.getString("targetobjcol")).collect(Collectors.toSet());
            if (collect.contains("org")) {
                model.setValue("inputcondition", (Object)"org", rowIndex);
            }
        } else {
            this.initComboItems(null);
            this.initAreaFilter(null);
            model.setValue("entitymapping", null);
            model.deleteEntryData("entryentity");
            model.createNewEntryRow("entryentity");
        }
    }

    private void initAreaFilter(DynamicObject srcBill) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
        if (srcBill == null) {
            filterGrid.setEntityNumber(null);
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setEntityNumber(srcBill.getString("number"));
        }
        this.getView().updateView("areafilter");
    }

    private void initComboItems(DynamicObject entityMapping) {
        ComboEdit outputResult = (ComboEdit)this.getControl("outputresult");
        ComboEdit returnobject = (ComboEdit)this.getControl("returnobject");
        ComboEdit inputCondition = (ComboEdit)this.getControl("inputcondition");
        if (entityMapping != null) {
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
            Map targetMap = FieldMapHelper.getFieldMapById((Long)((Long)entityMapping.getPkValue()), (String)"target");
            if (!CommonUtils.isNull((Object)targetMap)) {
                Map allFields = EntityMetadataCache.getDataEntityType((String)"msbd_datactrlmodel").getAllFields();
                for (String key : targetMap.keySet()) {
                    IDataEntityProperty property;
                    if ("controltype".equals(key) || (property = (IDataEntityProperty)allFields.get(key)) == null) continue;
                    data.add(new ComboItem(property.getDisplayName(), key));
                }
                outputResult.setComboItems(data);
                inputCondition.setComboItems(data);
                ArrayList<ComboItem> returnObj = new ArrayList<ComboItem>(10);
                for (Map.Entry next : allFields.entrySet()) {
                    if ("controltype".equals(next.getKey())) continue;
                    returnObj.add(new ComboItem(((IDataEntityProperty)next.getValue()).getDisplayName(), (String)next.getKey()));
                }
                returnobject.setComboItems(returnObj);
            }
        } else {
            outputResult.setComboItems(null);
            returnobject.setComboItems(null);
            inputCondition.setComboItems(null);
        }
    }
}

