/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsRecordMappingConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsWriteBackConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleConfig;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;

public class FeeShareConfigManager {
    private Map<Long, FeeShareTypeConfig> feeShareTypeConfigMap = new HashMap<Long, FeeShareTypeConfig>(16);
    private Map<Long, FsSchemeConfig> schemeConfigMap = new HashMap<Long, FsSchemeConfig>(16);
    private Map<Long, FsMatchRuleConfig> matchRuleConfigMap = new HashMap<Long, FsMatchRuleConfig>(16);
    private Map<Long, FlowFeeShareConfig> wflowSchemeConfigMap = new HashMap<Long, FlowFeeShareConfig>(16);
    private Map<Long, FsWriteBackConfig> writeBackConfigMap = new HashMap<Long, FsWriteBackConfig>(16);
    private Map<Long, ShareRuleConfig> shareRuleConfigMap = new HashMap<Long, ShareRuleConfig>(16);
    private Map<Long, FsRecordMappingConfig> recordMappingConfigMap = new HashMap<Long, FsRecordMappingConfig>(16);

    public FeeShareTypeConfig getWfTypeConfigById(Long wfTypeId) {
        FeeShareTypeConfig writeOffTypeConfig = this.feeShareTypeConfigMap.get(wfTypeId);
        if (writeOffTypeConfig == null) {
            throw new KDBizException(EngineLang.wfTypeValidateFail());
        }
        return writeOffTypeConfig;
    }

    public void addFeeShareTypeConfig(FeeShareTypeConfig wftypeConfig) {
        this.feeShareTypeConfigMap.put(wftypeConfig.getId(), wftypeConfig);
    }

    public List<FeeShareTypeConfig> getAllFeeShareTypeConfigs() {
        return new ArrayList<FeeShareTypeConfig>(this.feeShareTypeConfigMap.values());
    }

    public void addMatchRuleConfig(FsMatchRuleConfig config) {
        if (config != null) {
            this.matchRuleConfigMap.put((Long)config.getObjId(), config);
        }
    }

    public FsMatchRuleConfig getMatchRuleConfigById(Long matchRuleId, Long typeId) {
        FsMatchRuleConfig config = this.matchRuleConfigMap.get(matchRuleId);
        if (config == null) {
            DynamicObject matchRuleObj = BusinessDataServiceHelper.loadSingle((Object)matchRuleId, (String)"msmod_matchrule");
            if (matchRuleObj != null) {
                throw new KDBizException(EngineLang.matchValidateFailBan(matchRuleObj.getString("number")));
            }
            throw new KDBizException(EngineLang.matchValidateFailDelete(matchRuleId));
        }
        return config;
    }

    public FsMatchRuleConfig getMatchRuleConfigBySchemeId(Long schemeId, Long typeId) {
        FsSchemeConfig schemeConfig = this.getSchemeConfigById(schemeId, typeId);
        if (schemeConfig.isNoCondition()) {
            return null;
        }
        FsMatchRuleConfig config = this.getMatchRuleConfigById(schemeConfig.getMatchRuleId(), typeId);
        return config;
    }

    public void addSchemeContextConfig(FsSchemeConfig config) {
        if (config != null) {
            this.schemeConfigMap.put(config.getId(), config);
        }
    }

    public FsSchemeConfig getSchemeConfigById(Long schemeId, Long typeId) {
        FsSchemeConfig schemeConfig = this.schemeConfigMap.get(schemeId);
        if (schemeConfig == null) {
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"msmod_scheme");
            if (schemeObj != null) {
                throw new KDBizException(EngineLang.schemeValidateFailBan(schemeObj.getString("number")));
            }
            throw new KDBizException(EngineLang.schemeValidateFailDelete(schemeId));
        }
        return schemeConfig;
    }

    public FsRecordMappingConfig getMappingConfigById(long mappingId) {
        FsRecordMappingConfig recordMappingConfig = this.recordMappingConfigMap.get(mappingId);
        if (recordMappingConfig == null) {
            throw new KDBizException(EngineLang.recordMappingValidateFail());
        }
        return recordMappingConfig;
    }

    public Collection<FsRecordMappingConfig> getAllConfig() {
        return this.recordMappingConfigMap.values();
    }

    public List<FsSchemeConfig> getAllSchemeConfigs() {
        return new ArrayList<FsSchemeConfig>(this.schemeConfigMap.values());
    }

    public FsWriteBackConfig getWriteBackConfigById(Long backConfId) {
        FsWriteBackConfig writeBackConfig = this.writeBackConfigMap.get(backConfId);
        return writeBackConfig;
    }

    public void addRecordMappingConfig(FsRecordMappingConfig rmConfig) {
        if (rmConfig != null) {
            this.recordMappingConfigMap.put((Long)rmConfig.getObjId(), rmConfig);
        }
    }

    public void addWorkflowSchemeConfig(FlowFeeShareConfig schemeConfig) {
        if (schemeConfig != null) {
            this.wflowSchemeConfigMap.put(schemeConfig.getFeeShareTypeId(), schemeConfig);
        }
    }

    public FlowFeeShareConfig getWorkflowSchemeByWriteOffTypeId(Long wrtieOffTypeId) {
        return this.wflowSchemeConfigMap.get(wrtieOffTypeId);
    }

    public List<FlowFeeShareConfig> getAllWorkflowScheme() {
        return new ArrayList<FlowFeeShareConfig>(this.wflowSchemeConfigMap.values());
    }

    public void addWriteBackConfg(FsWriteBackConfig writeBackConfig) {
        if (writeBackConfig != null) {
            this.writeBackConfigMap.put(writeBackConfig.getFeeShareTypeId(), writeBackConfig);
        }
    }

    public void addShareRuleConfig(ShareRuleConfig config) {
        if (config != null) {
            this.shareRuleConfigMap.put((Long)config.getObjId(), config);
        }
    }

    public ShareRuleConfig getShareRuleConfigById(Long shareRuleId) {
        if (shareRuleId == null || Long.compare(shareRuleId, 0L) == 0) {
            return null;
        }
        ShareRuleConfig shareRuleConfig = this.shareRuleConfigMap.get(shareRuleId);
        if (shareRuleConfig == null) {
            throw new KDBizException(EngineLang.shareRuleValidateFail());
        }
        return shareRuleConfig;
    }
}

