/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.feeshare.common.helper.ConditionHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.FilterFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFConditionFilter;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;

public abstract class AbstractFSCondtionConfig
extends AbstractObjMappingConfig {
    private List<QFilter> filters;
    private List<BOSExpression> expressions;
    private List<WFConditionFilter> wfConditionFilters;
    private List<String> highExpressions;
    private List<String> fieldList;

    public AbstractFSCondtionConfig(DynamicObject obj) {
        super(obj);
    }

    private void initCondition() {
        if (this.expressions != null && this.highExpressions != null) {
            return;
        }
        this.expressions = new ArrayList<BOSExpression>(2);
        this.highExpressions = new ArrayList<String>(2);
        this.filters = new ArrayList<QFilter>(2);
        this.fieldList = new ArrayList<String>(2);
        this.wfConditionFilters = new ArrayList<WFConditionFilter>(2);
        String[] expressionArray = this.getExpressions();
        if (expressionArray != null) {
            for (String expression : expressionArray) {
                this.addExpression(expression);
            }
        }
    }

    protected abstract String[] getExpressions();

    private void addExpression(String condition) {
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            String highExpression;
            String[] filterStrings;
            String exprStr;
            CRCondition condtion = ConditionHelper.parseCondtion(condition);
            FilterBuilder buildFilter = ConditionHelper.buildFilter(this.getBillType(), condtion);
            if (buildFilter != null && StringUtils.isNotEmpty((CharSequence)(exprStr = (filterStrings = buildFilter.buildFilterScript())[0]))) {
                this.wfConditionFilters.add(FilterFactory.createCondition((FilterBuilder)buildFilter));
                BOSExpression expression = new BOSExpression(exprStr);
                Set vars = expression.getVars();
                QFilter filter = buildFilter.getQFilter();
                this.expressions.add(expression);
                this.filters.add(filter);
                this.fieldList.addAll(vars);
            }
            if (StringUtils.isNotEmpty((CharSequence)(highExpression = condtion.getExpression()))) {
                String[] extractVariables;
                for (String vars : extractVariables = FormulaEngine.extractVariables((String)highExpression)) {
                    this.fieldList.add(vars);
                }
                this.highExpressions.add(highExpression);
            }
        }
    }

    protected abstract String getBillType();

    public boolean checkCondtion(FeeShareObjectBase feeShareObject) {
        Map<String, Object> params = ConditionHelper.getValueFromFeeShareObjectBase(this.getCondtionParam(), feeShareObject);
        return this.checCondtionByParamMap(params);
    }

    public Map<String, Object> getCondtionValueMap(FeeShareObjectBase feeShareObject) {
        return ConditionHelper.getValueFromFeeShareObjectBase(this.getCondtionParam(), feeShareObject);
    }

    public boolean checCondtionByParamMap(Map<String, Object> params) {
        for (BOSExpression bosExpression : this.expressions) {
            if (((Boolean)FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), params)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Set<String> getCondtionParam() {
        this.initCondition();
        HashSet<String> params = new HashSet<String>();
        for (BOSExpression expr : this.expressions) {
            params.addAll(expr.getVars());
        }
        return params;
    }

    public boolean checkHighCondtion(FeeShareObjectBase feeShareObj) {
        this.initCondition();
        for (String highExpression : this.highExpressions) {
            if (ConditionHelper.checkHighCondition(highExpression, feeShareObj, null)) continue;
            return false;
        }
        return true;
    }

    public List<WFConditionFilter> getWfConditionFilters() {
        this.initCondition();
        return this.wfConditionFilters;
    }

    public List<QFilter> getFilters() {
        this.initCondition();
        return this.filters;
    }

    public List<BOSExpression> getFilterExpressions() {
        if (this.expressions == null) {
            return Collections.emptyList();
        }
        return this.expressions;
    }

    public List<String> getFieldList() {
        this.initCondition();
        return this.fieldList;
    }

    public void setFieldList(List<String> fieldList) {
        this.fieldList = fieldList;
    }
}

