/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;

public class FsBillFieldInfo {
    private String billentity;
    private String entryKey;
    private Map<String, String> mapKey = new HashMap<String, String>(16);
    private Set<String> fields = new LinkedHashSet<String>(16);
    private Set<String> entryField = new LinkedHashSet<String>(16);

    public static FsBillFieldInfo build(String billentity, String entryKey, Map<String, Map<String, IDataEntityProperty>> map, Map<String, Set<String>> refMap) {
        FsBillFieldInfo billFieldInfo = new FsBillFieldInfo(billentity, entryKey);
        billFieldInfo.init(map, refMap);
        return billFieldInfo;
    }

    private FsBillFieldInfo(String billentity, String entryKey) {
        this.billentity = billentity;
        this.entryKey = entryKey;
    }

    private void init(Map<String, Map<String, IDataEntityProperty>> map, Map<String, Set<String>> refMap) {
        for (Map.Entry<String, Map<String, IDataEntityProperty>> fieldInfo : map.entrySet()) {
            Collection<IDataEntityProperty> curEntryfields;
            String curEntrykey = fieldInfo.getKey();
            if (StringUtils.isEmpty((CharSequence)curEntrykey)) {
                curEntryfields = fieldInfo.getValue().values();
                for (IDataEntityProperty fieldKeyProp : curEntryfields) {
                    Set<String> refFields;
                    this.fields.add(fieldKeyProp.getName());
                    if (refMap == null || (refFields = refMap.get(fieldKeyProp.getName())) == null) continue;
                    for (String refField : refFields) {
                        this.fields.add(fieldKeyProp.getName() + "." + refField);
                    }
                }
                continue;
            }
            if (!curEntrykey.equals(this.entryKey)) continue;
            curEntryfields = fieldInfo.getValue().values();
            this.mapKey.put(curEntrykey + ".seq", "seq");
            this.entryField.add(curEntrykey + ".seq");
            this.fields.add(curEntrykey + ".seq as seq");
            for (IDataEntityProperty fieldKeyProp : curEntryfields) {
                Set<String> refFields;
                String fieldKey = fieldKeyProp.getName();
                String entryFieldKey = curEntrykey + "." + fieldKey;
                if ("id".equals(fieldKey)) {
                    this.fields.add(entryFieldKey);
                    continue;
                }
                this.mapKey.put(entryFieldKey, fieldKey);
                this.entryField.add(entryFieldKey);
                this.fields.add(entryFieldKey + " as " + fieldKey);
                if (refMap == null || (refFields = refMap.get(fieldKeyProp.getName())) == null) continue;
                for (String refField : refFields) {
                    String refEntryFieldkey = entryFieldKey + "." + refField;
                    this.mapKey.put(refEntryFieldkey, fieldKey);
                    this.entryField.add(refEntryFieldkey);
                    this.fields.add(refEntryFieldkey + " as " + fieldKey + "." + refField);
                }
            }
        }
    }

    public String getSelectField() {
        return String.join((CharSequence)",", this.fields);
    }

    public String getFullSelectField() {
        LinkedHashSet<String> fullFields = new LinkedHashSet<String>();
        fullFields.addAll(this.fields);
        fullFields.addAll(this.entryField);
        return String.join((CharSequence)",", fullFields);
    }

    public Map<String, String> getMapKey() {
        return this.mapKey;
    }

    public String getBillentity() {
        return this.billentity;
    }
}

