/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.writeoff.business.engine.core.sort.CommonComparator;

public class FsLargeTextValue {
    private String key;
    private final List<Long> ids;
    private final List<Long> entryIds;
    private final String srcText;

    public static FsLargeTextValue create(String largeText) {
        List<Long> entryIds;
        if (StringUtils.isBlank((CharSequence)largeText) || "null".equals(largeText)) {
            return new FsLargeTextValue(Collections.emptyList(), Collections.emptyList(), largeText);
        }
        Map largeTextInfo = (Map)SerializationUtils.fromJsonString((String)largeText, Map.class);
        if (largeTextInfo == null) {
            throw new KDBizException("large text format error:" + largeText);
        }
        List<Long> ids = (List<Long>)largeTextInfo.get("id");
        if (ids == null) {
            ids = Collections.emptyList();
        }
        if ((entryIds = (List<Long>)largeTextInfo.get("entryid")) == null) {
            entryIds = Collections.emptyList();
        }
        return new FsLargeTextValue(ids, entryIds, largeText);
    }

    private FsLargeTextValue(List<Long> ids, List<Long> entryIds, String srcText) {
        ids.sort((Comparator<Long>)CommonComparator.getInstance());
        this.ids = ids;
        entryIds.sort((Comparator<Long>)CommonComparator.getInstance());
        this.entryIds = entryIds;
        this.srcText = srcText;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public List<Long> getEntryIds() {
        return this.entryIds;
    }

    public boolean isEmpty() {
        return this.ids.isEmpty() && this.entryIds.isEmpty();
    }

    public String getKey() {
        if (this.key == null) {
            String text = this.ids.toString() + this.entryIds.toString();
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(text.getBytes());
                byte[] digest = md5.digest();
                StringBuilder digestCode = new StringBuilder();
                for (byte b : digest) {
                    digestCode.append(b);
                }
                this.key = digestCode.toString();
            }
            catch (NoSuchAlgorithmException e) {
                this.key = text;
            }
        }
        return this.key;
    }

    public String toString() {
        return this.srcText;
    }
}

