/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.feeshare.business.config.vo.AbstractObjToFSTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsWriteBackRuleConfig;

public class FsWriteBackConfig
extends AbstractObjToFSTypeConfig {
    private Map<String, List<FsWriteBackRuleConfig>> backRuleConfigs = new HashMap<String, List<FsWriteBackRuleConfig>>(16);

    private FsWriteBackConfig(DynamicObject obj) {
        super(obj);
    }

    public static FsWriteBackConfig build(DynamicObject writeBackEntity) {
        FsWriteBackConfig config = new FsWriteBackConfig(writeBackEntity);
        config.initWriteBackRuleConfigs();
        return config;
    }

    private void initWriteBackRuleConfigs() {
        DynamicObjectCollection entries = this.getObj().getDynamicObjectCollection("rewritebillentity");
        for (DynamicObject entry : entries) {
            String pluginName = this.getObj().getString("rewriteplugin");
            DynamicObject billAlias = entry.getDynamicObject("alias");
            if (billAlias == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219\u6838\u9500\u5355\u636e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteBackConfigManager_0", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]));
            }
            String srcBillAlias = String.valueOf(billAlias.getPkValue());
            String billType = billAlias.getDynamicObject("wfbill").getString("number");
            DynamicObjectCollection reWtFormuls = entry.getDynamicObjectCollection("rewtformulentity");
            ArrayList<FsWriteBackRuleConfig> WBRConfigs = new ArrayList<FsWriteBackRuleConfig>(16);
            for (DynamicObject reWtFormul : reWtFormuls) {
                FsWriteBackRuleConfig writeBackRuleConfig = FsWriteBackRuleConfig.build(reWtFormul);
                writeBackRuleConfig.setPluginName(pluginName);
                writeBackRuleConfig.setSourceBillType(billType);
                writeBackRuleConfig.setSourceBillAlias(srcBillAlias);
                WBRConfigs.add(writeBackRuleConfig);
            }
            this.backRuleConfigs.put(srcBillAlias, WBRConfigs);
        }
    }

    public List<FsWriteBackRuleConfig> getBackRuleConfigs() {
        ArrayList<FsWriteBackRuleConfig> backRules = new ArrayList<FsWriteBackRuleConfig>(16);
        for (List<FsWriteBackRuleConfig> writeBackRuleConfig : this.backRuleConfigs.values()) {
            backRules.addAll(writeBackRuleConfig);
        }
        return backRules;
    }

    public List<FsWriteBackRuleConfig> getBackRuleConfigsByAlias(String billAlias) {
        return this.backRuleConfigs.get(billAlias);
    }

    @Override
    protected String writeOffTypeKey() {
        return "writeofftype";
    }
}

