/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.feeshare.business.config.vo.AbstractFSCondtionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.DenomBillMatchConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.DenominatorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.NumeratorConfig;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;

public class ShareRuleBillConfig
extends AbstractFSCondtionConfig {
    private NumeratorConfig nume = null;
    private DenominatorConfig denom = null;
    private DenomBillMatchConfig denomMatchConfigs;

    private ShareRuleBillConfig(DynamicObject obj) {
        super(obj);
    }

    public static ShareRuleBillConfig build(DynamicObject obj) {
        ShareRuleBillConfig srBillConfig = new ShareRuleBillConfig(obj);
        srBillConfig.init();
        return srBillConfig;
    }

    private void init() {
        DynamicObjectCollection entries = this.getObj().getDynamicObjectCollection("subentryentity");
        for (DynamicObject entry : entries) {
            String shareWeight = entry.getString("shareweight");
            if ("1".equals(shareWeight)) {
                this.denom = new DenominatorConfig(entry);
                continue;
            }
            if (!"0".equals(shareWeight)) continue;
            this.nume = new NumeratorConfig(entry);
        }
        if (this.denom != null && !this.denom.isPluginMatch()) {
            DynamicObjectCollection shareMatchEntires = this.getObj().getDynamicObjectCollection("matchconditionentity");
            DynamicObject numeBillObj = this.nume.getObj().getDynamicObject("sharewfbillalias");
            DynamicObject denomBillObj = this.denom.getObj().getDynamicObject("sharewfbillalias");
            this.denomMatchConfigs = DenomBillMatchConfig.build(shareMatchEntires, this.nume, this.denom);
            if (!StringUtils.equals((CharSequence)numeBillObj.getString("number"), (CharSequence)denomBillObj.getString("number")) && this.denomMatchConfigs.getMatchConditionConfigs().isEmpty()) {
                throw new KDBizException(FormLang.plsConfigSrcToTgtBillMatchEntry((int)this.getObj().getInt("seq"), (DynamicObject)numeBillObj, (DynamicObject)denomBillObj));
            }
        }
    }

    public boolean onSameBillAlias() {
        if (this.denom == null) {
            return true;
        }
        DynamicObject numeBillObj = this.nume.getObj().getDynamicObject("sharewfbillalias");
        DynamicObject denomBillObj = this.denom.getObj().getDynamicObject("sharewfbillalias");
        return this.denomMatchConfigs.getMatchConditionConfigs().isEmpty() && Long.compare(numeBillObj.getLong("id"), denomBillObj.getLong("id")) == 0;
    }

    public NumeratorConfig getNumerator() {
        return this.nume;
    }

    public DenominatorConfig getDenominator() {
        return this.denom;
    }

    @Override
    protected String[] getExpressions() {
        return new String[]{this.getObj().getString("filterconditiondesc_tag")};
    }

    @Override
    public String getBillType() {
        DynamicObject wfBillObj = this.getObj().getDynamicObject("wfbillalias");
        return wfBillObj.getDynamicObject("wfbill").getString("number");
    }

    public DenomBillMatchConfig getDenomMatchConfigs() {
        return this.denomMatchConfigs;
    }
}

