/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.feeshare.business.config.vo.AbstractObjToFSTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsFieldInfo;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.NumeratorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;

public class ShareRuleConfig
extends AbstractObjToFSTypeConfig {
    private List<ShareRuleBillConfig> billConfigs = new ArrayList<ShareRuleBillConfig>(16);

    public static ShareRuleConfig build(DynamicObject obj) {
        ShareRuleConfig config = new ShareRuleConfig(obj);
        config.init();
        return config;
    }

    private ShareRuleConfig(DynamicObject obj) {
        super(obj);
    }

    private void init() {
        DynamicObjectCollection entires = this.getObj().getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entires) {
            ShareRuleBillConfig srBillConfig = ShareRuleBillConfig.build(entry);
            this.billConfigs.add(srBillConfig);
        }
    }

    public ShareRuleBillConfig getShareBillConifg(FeeShareObject wfObj) {
        return this.getShareBillConifg(wfObj.getFeeShareObjectBase());
    }

    public ShareRuleBillConfig getShareBillConifg(FeeShareObjectBase fsObj) {
        for (ShareRuleBillConfig shareRuleBillConfig : this.billConfigs) {
            if (!shareRuleBillConfig.checkCondtion(fsObj)) continue;
            return shareRuleBillConfig;
        }
        return null;
    }

    public ShareRuleBillConfig getShareBillConfig(Long billConfigId) {
        for (ShareRuleBillConfig shareRuleBillConfig : this.billConfigs) {
            if (!shareRuleBillConfig.getObjId().equals(billConfigId)) continue;
            return shareRuleBillConfig;
        }
        return null;
    }

    public List<ShareRuleBillConfig> getShareBillConfigs() {
        return this.billConfigs;
    }

    @Override
    protected String writeOffTypeKey() {
        return "writeofftype";
    }

    public String getMainEntryKey() {
        List<ShareRuleBillConfig> shareBillConfigs = this.getShareBillConfigs();
        if (shareBillConfigs.isEmpty()) {
            throw new KDBizException("sharerule not config numerator`s mainFieldKey!");
        }
        NumeratorConfig numerator = shareBillConfigs.get(0).getNumerator();
        FsFieldInfo mainColumn = numerator.getWfFieldInfo();
        return mainColumn.getMainFieldCalClass().mainFieldEntry();
    }
}

