/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.mscommon.feeshare.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.feeshare.business.config.manager.FeeShareConfigManager;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.BillDataSource;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareManualGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.param.IFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.AbstractManualReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.FlowFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.ManualAutoFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.ManualFeeShareReqParam;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.PluginFactory;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import kd.mpscmm.mscommon.writeoff.common.log.WriteOffExeucteInfo;

public class FeeShareExecuteContext {
    private final IFeeShareReqParam reqParam;
    private FeeShareConfigManager configManager;
    private BillFieldInfoManager billFieldInfoManager = null;
    private WriteOffParamManager wfParamManager = WriteOffParamManager.create();
    private PluginFactory pluginFactory = null;
    private BillDataSource billDataSource = null;
    private WriteOffExeucteInfo executeInfo = new WriteOffExeucteInfo();
    private String seq;
    private List<FeeShareMatchGroup> matchGroupMap = new ArrayList<FeeShareMatchGroup>(16);
    private List<FeeShareManualGroup> writeOffManualGroups = new ArrayList<FeeShareManualGroup>(16);
    private Map<Long, FeeShareTypeContext> typeContexts = new HashMap<Long, FeeShareTypeContext>(16);
    private Map<Long, FeeShareLogInfo> logs = new HashMap<Long, FeeShareLogInfo>(16);
    private Map<String, Object> custParams = new HashMap<String, Object>(16);

    public static FeeShareExecuteContext createFlow(String reqbillEntity, List<Object> billIds, String operationKey) {
        FlowFeeShareReqParam param = new FlowFeeShareReqParam(reqbillEntity, billIds, operationKey);
        FeeShareExecuteContext context = new FeeShareExecuteContext(param);
        context.setSeq(WriteSeqHelper.getSeq());
        return context;
    }

    public static FeeShareExecuteContext createAuto(Long wfTypeId, Map<String, Object> schemaMap, Date wfDate, Map<String, Object> params, Map<String, Map<String, String>> conditionsMap) {
        ManualAutoFeeShareReqParam param = new ManualAutoFeeShareReqParam(wfTypeId, schemaMap, wfDate, params, conditionsMap);
        FeeShareExecuteContext context = new FeeShareExecuteContext(param);
        context.setSeq(WriteSeqHelper.getSeq());
        return context;
    }

    public static FeeShareExecuteContext createManual(Long wfTypeId, Map<String, Object> schemaMap, Date wfDate, List<Map<Object, BigDecimal>> curMainFieldValueMaps, Map<String, Object> params) {
        ManualFeeShareReqParam param = new ManualFeeShareReqParam(wfTypeId, schemaMap, wfDate, curMainFieldValueMaps, params);
        FeeShareExecuteContext context = new FeeShareExecuteContext(param);
        context.setSeq(WriteSeqHelper.getSeq());
        return context;
    }

    public FeeShareExecuteContext(IFeeShareReqParam reqParam) {
        this.reqParam = reqParam;
    }

    public void addParam(String key, Object value) {
        this.custParams.put(key, value);
    }

    public Object getParam(String key) {
        return this.custParams.get(key);
    }

    public String getSeq() {
        return this.seq;
    }

    private void setSeq(String seq) {
        this.seq = seq;
    }

    public boolean isManualFeeShare() {
        return "3".equals(this.getWfMode());
    }

    public boolean isFlowFeeShare() {
        return this.reqParam instanceof FlowFeeShareReqParam;
    }

    public List<FeeShareManualGroup> getWriteOffManualGroups() {
        return this.writeOffManualGroups;
    }

    public void addWriteOffManualGroups(Collection<FeeShareManualGroup> groups) {
        this.writeOffManualGroups.addAll(groups);
    }

    public List<FeeShareMatchGroup> getMatchGroupMap() {
        return this.matchGroupMap;
    }

    public void addFeeShareGroups(Collection<FeeShareMatchGroup> groups) {
        this.matchGroupMap.addAll(groups);
    }

    public IFeeShareReqParam getReqParam() {
        return this.reqParam;
    }

    public FeeShareConfigManager getConfigManager() {
        if (this.configManager == null) {
            this.configManager = new FeeShareConfigManager();
        }
        return this.configManager;
    }

    public void setConfigManager(FeeShareConfigManager configManager) {
        this.configManager = configManager;
    }

    public WriteOffExeucteInfo getExecuteInfo() {
        return this.executeInfo;
    }

    public FeeShareLogInfo getWriteOffLogByTypeId(Long typeId) {
        FeeShareLogInfo logInfo = this.logs.get(typeId);
        if (logInfo == null) {
            FeeShareTypeConfig typeConfig = this.getConfigManager().getWfTypeConfigById(typeId);
            logInfo = FeeShareLogInfo.createLog(this.getSeq(), typeConfig);
            if (this.reqParam instanceof FlowFeeShareReqParam) {
                logInfo.getWfLogObj().set("srcbillentity", (Object)((FlowFeeShareReqParam)this.reqParam).getReqbillEntity());
                logInfo.getWfLogObj().set("wfmode", (Object)"F");
                logInfo.getWfLogObj().set("operate", (Object)((FlowFeeShareReqParam)this.reqParam).getOperationKey());
            } else if (this.reqParam instanceof ManualFeeShareReqParam) {
                logInfo.getWfLogObj().set("wfmode", (Object)"M");
            } else if (this.reqParam instanceof ManualAutoFeeShareReqParam) {
                logInfo.getWfLogObj().set("wfmode", (Object)"A");
            }
            this.logs.put(typeId, logInfo);
        }
        return logInfo;
    }

    public List<FeeShareLogInfo> getLogs() {
        ArrayList<FeeShareLogInfo> doLogs = new ArrayList<FeeShareLogInfo>(8);
        Collection<FeeShareLogInfo> values = this.logs.values();
        for (FeeShareLogInfo value : values) {
            DynamicObject wfType = value.getWfLogObj().getDynamicObject("wftype");
            FeeShareTypeContext writeOffTypeContext = this.typeContexts.get(wfType.getPkValue());
            if (!writeOffTypeContext.isWriteOff()) continue;
            doLogs.add(value);
        }
        return doLogs;
    }

    public List<FeeShareLogInfo> getErrorLogs() {
        ArrayList<FeeShareLogInfo> doLogs = new ArrayList<FeeShareLogInfo>(8);
        Collection<FeeShareLogInfo> values = this.logs.values();
        for (FeeShareLogInfo value : values) {
            doLogs.add(value);
        }
        return doLogs;
    }

    public FeeShareTypeContext getTypeContext(long writeOffTypeId) {
        FeeShareTypeContext typeContext = this.typeContexts.get(writeOffTypeId);
        if (typeContext == null) {
            typeContext = new FeeShareTypeContext(this, this.getConfigManager().getWfTypeConfigById(writeOffTypeId));
            this.typeContexts.put(writeOffTypeId, typeContext);
            FeeShareLogInfo writeOffLog = this.getWriteOffLogByTypeId(writeOffTypeId);
            typeContext.setWriteOffLog(writeOffLog);
        }
        return typeContext;
    }

    public BillFieldInfoManager getBillFieldInfo() {
        if (this.billFieldInfoManager == null) {
            this.billFieldInfoManager = BillFieldInfoManager.create();
        }
        return this.billFieldInfoManager;
    }

    public BillDataSource getBillDataSource() {
        if (this.billDataSource == null) {
            this.billDataSource = new BillDataSource(this.getBillFieldInfo());
        }
        return this.billDataSource;
    }

    public WriteOffParamManager getWfParam() {
        return this.wfParamManager;
    }

    public String getWfMode() {
        if (this.reqParam instanceof FlowFeeShareReqParam) {
            return "1";
        }
        if (this.reqParam instanceof ManualFeeShareReqParam) {
            return "2";
        }
        if (this.reqParam instanceof ManualAutoFeeShareReqParam) {
            return "3";
        }
        return "";
    }

    public PluginFactory getPluginFactory() {
        if (this.pluginFactory == null) {
            this.pluginFactory = new PluginFactory(this);
        }
        return this.pluginFactory;
    }

    public Date getFeeShareDate() {
        Date fsDate = null;
        if (this.reqParam instanceof AbstractManualReqParam && (fsDate = ((AbstractManualReqParam)this.reqParam).getWfDate()) != null) {
            return fsDate;
        }
        return new Date();
    }
}

