/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsWriteBackConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.context.FeeShareSnapshotContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.context.IFeeShareQtyHolder;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.HintDataMatcher;
import kd.mpscmm.mscommon.feeshare.business.engine.core.record.FeeShareRecordManager;
import kd.mpscmm.mscommon.feeshare.business.engine.core.record.FeeShareRecordMapper;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.PluginFactory;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class FeeShareTypeContext
implements IFeeShareQtyHolder {
    private String billTypeKey = "";
    private List<FeeShareMatchGroup> writeOffMatchGroups;
    private FeeShareTypeConfig typeConfig;
    private FeeShareLogInfo writeOffLog;
    private FeeShareExecuteContext executeContext;
    private FeeShareSnapshotContext snapshotContext;
    private FeeShareRecordManager recordManager = new FeeShareRecordManager();
    private Map<String, Object> custParams = new HashMap<String, Object>(16);
    private HintDataMatcher hintDataLoader = new HintDataMatcher();

    public FeeShareTypeContext(FeeShareExecuteContext executeContext, FeeShareTypeConfig wfType) {
        this.typeConfig = wfType;
        this.executeContext = executeContext;
        this.snapshotContext = new FeeShareSnapshotContext(wfType);
    }

    public void addRecordBill(FeeShareRecordMapper writeOffRecordMapper) {
        FsWriteBackConfig writeBackConfig = this.getExecuteContext().getConfigManager().getWriteBackConfigById(this.typeConfig.getId());
        writeOffRecordMapper.initBackWrite(this.typeConfig, writeBackConfig);
        this.snapshotContext.addSnapShots(writeOffRecordMapper.getNeedAddSnapShoot());
        this.recordManager.addRecord(writeOffRecordMapper);
    }

    @Override
    public BigDecimal getFeeShareQty(FeeShareObject writeOffObj) {
        return this.snapshotContext.getFeeShareQty(writeOffObj);
    }

    public String getBillTypeKey() {
        return this.billTypeKey;
    }

    public void setBillTypeKey(String billTypeKey) {
        this.billTypeKey = billTypeKey;
    }

    public FeeShareExecuteContext getExecuteContext() {
        return this.executeContext;
    }

    public void loadSnapShootMap(Collection<Object> ids, String entityName) {
        this.snapshotContext.loadSnapShootMap(ids, entityName);
    }

    public FeeShareTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public FeeShareRecordManager getRecordManager() {
        return this.recordManager;
    }

    public FeeShareSnapshotContext getSnapshotContext() {
        return this.snapshotContext;
    }

    public FeeShareLogInfo getWriteOffLog() {
        return this.writeOffLog;
    }

    public boolean isMatch() {
        return this.getBooleanFromCustParam("ismatch");
    }

    public boolean isWriteOff() {
        return this.getBooleanFromCustParam("canwriteoff");
    }

    private boolean getBooleanFromCustParam(String key) {
        Object isMatch = this.custParams.get(key);
        if (isMatch != null) {
            return (Boolean)isMatch;
        }
        return false;
    }

    void setWriteOffLog(FeeShareLogInfo writeOffLog) {
        this.writeOffLog = writeOffLog;
    }

    public void addMatchParams(Long schemeId, Map<String, List<List<Map<String, Object>>>> value) {
        Map<Long, Map<String, List<List<Map<String, Object>>>>> preMatchData = this.getPreMatchMap();
        Map params = MapUtils.mapGetMapValue(preMatchData, (Object)schemeId);
        params.putAll(value);
    }

    public Map<Long, Map<String, List<List<Map<String, Object>>>>> getPreMatchMap() {
        HashMap preMatchData = (HashMap)this.custParams.get("preMatchData");
        if (preMatchData == null) {
            preMatchData = new HashMap(16);
            this.custParams.put("preMatchData", preMatchData);
        }
        return preMatchData;
    }

    public void addMatchParams(String key, Object value) {
        this.custParams.put(key, value);
    }

    public Map<String, Object> getCustParams() {
        return this.custParams;
    }

    public List<FeeShareMatchGroup> getMatchGroup() {
        return this.writeOffMatchGroups;
    }

    public void setMatchGroup(List<FeeShareMatchGroup> matchGroups) {
        this.writeOffMatchGroups = matchGroups;
    }

    public HintDataMatcher getHintDataLoader() {
        return this.hintDataLoader;
    }

    public PluginFactory getPluginFactory() {
        return this.executeContext.getPluginFactory();
    }
}

