/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.IBackFsStrategy;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.entity.BackFsKdtxParamHolder;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.impl.AbstractBackFsStrategy;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.impl.UpDownBackFsStrategy;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.UnFsPluginExtFactory;
import kd.mpscmm.mscommon.feeshare.common.helper.FeeShareRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import org.apache.commons.lang3.StringUtils;

public class ReverseFeeShareEngine {
    private static final Log logger = LogFactory.getLog(ReverseFeeShareEngine.class);

    public static void execute(DynamicObject[] dataEntities, String operationKey, Map<String, Object> paramMap) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String billType = dataEntities[0].getDataEntityType().getName();
        if ("cal_costrecord_subentity".equals(billType) || "im_saloutbill".equals(billType) || "ap_finapbill".equals(billType) || "ap_busbill".equals(billType)) {
            ReverseFeeShareEngine.startBackWriteOff(dataEntities, operationKey);
        } else if ("cal_sale_feeshare_record".equals(billType) || "cal_feeshare_newrecord".equals(billType)) {
            ReverseFeeShareEngine.startHandBackWriteOff(dataEntities);
        }
    }

    private static void startBackWriteOff(DynamicObject[] dataEntities, String operationKey) {
        long start = System.currentTimeMillis();
        String seq = WriteSeqHelper.getSeq();
        IDataEntityType entityType = dataEntities[0].getDataEntityType();
        String billType = entityType.getName();
        List<FeeShareTypeConfig> typeConfigs = ReverseFeeShareEngine.getGetWfTypes(entityType, operationKey);
        UnFsPluginExtFactory unWfPluginExtFactory = new UnFsPluginExtFactory();
        for (int i = typeConfigs.size() - 1; i >= 0; --i) {
            FeeShareTypeConfig typeConfig = typeConfigs.get(i);
            String recordBillType = typeConfig.getRecordNum();
            if (StringUtils.isBlank((CharSequence)recordBillType)) continue;
            Map<Long, List<DynamicObject>> wfRecordMap = FeeShareRecordHelper.loadWfRecord(typeConfig, dataEntities);
            BackFsKdtxParamHolder holder = new BackFsKdtxParamHolder();
            holder.setUnWfPluginExtFactory(unWfPluginExtFactory);
            List<DynamicObject> allWfRecordList = ReverseFeeShareEngine.mergeWfRecord(wfRecordMap);
            unWfPluginExtFactory.batchCheck(allWfRecordList, typeConfig, false);
            for (DynamicObject entity : dataEntities) {
                Long billId = (Long)entity.getPkValue();
                List recordList = wfRecordMap.getOrDefault(billId, Collections.emptyList());
                for (DynamicObject record : recordList) {
                    UpDownBackFsStrategy upDown = new UpDownBackFsStrategy();
                    upDown.setFlowBillType(billType);
                    upDown.setFlowBillIds(Collections.singletonList(billId));
                    ReverseFeeShareEngine.setBackWfStrategyParam(typeConfig, seq, holder, upDown);
                    upDown.backWriteOff(record);
                }
            }
            long end = System.currentTimeMillis();
            logger.info("startBackWriteOff\u53cd\u6838\u9500\u6267\u884c\u7684\u65f6\u95f4:" + (end - start) + "ms");
            holder.doKdtx();
        }
    }

    private static List<DynamicObject> mergeWfRecord(Map<Long, List<DynamicObject>> wfRecordMap) {
        HashMap<Long, DynamicObject> newWfRecordMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : wfRecordMap.entrySet()) {
            List<DynamicObject> wfRecordList = entry.getValue();
            for (DynamicObject wfRecord : wfRecordList) {
                newWfRecordMap.putIfAbsent((Long)wfRecord.getPkValue(), wfRecord);
            }
        }
        return new ArrayList<DynamicObject>(newWfRecordMap.values());
    }

    private static List<FeeShareTypeConfig> getGetWfTypes(IDataEntityType entityType, String operationKey) {
        ArrayList<FeeShareTypeConfig> list = new ArrayList<FeeShareTypeConfig>(16);
        List<Long> wfTypeList = ReverseFeeShareEngine.getWfTypeList(operationKey, entityType.getName());
        if (wfTypeList.isEmpty()) {
            logger.info("\u6838\u9500\u7c7b\u522b\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        QFilter typeFilter = new QFilter("id", "in", wfTypeList);
        typeFilter.and("writeofftype", "=", (Object)"B");
        Map writeOffObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])typeFilter.toArray());
        for (DynamicObject wfType : writeOffObjs.values()) {
            list.add(FeeShareTypeConfig.build(wfType));
        }
        return list;
    }

    private static List<Long> getWfTypeList(String operationKey, String reqbillEntity) {
        QFilter billFilter = new QFilter("msmod_scheme_bill.writeoffbill.wfbill", "=", (Object)reqbillEntity);
        billFilter.and("writeofftype.writeofftype", "=", (Object)"B");
        Map schemeSetObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_schemeset", (QFilter[])billFilter.toArray());
        ArrayList<Long> wfTypeIdList = new ArrayList<Long>(8);
        for (DynamicObject schemeObj : schemeSetObjs.values()) {
            boolean isContainOp = false;
            DynamicObjectCollection schemeBills = schemeObj.getDynamicObjectCollection("msmod_scheme_bill");
            for (DynamicObject schemeBill : schemeBills) {
                String op = schemeBill.getString("rewriteoffop");
                DynamicObject writeOffBill = schemeBill.getDynamicObject("writeoffbill");
                String billEntity = writeOffBill.getDynamicObject("wfbill").getString("number");
                String[] ops = op.split(",");
                HashSet<String> opSet = new HashSet<String>(Arrays.asList(ops));
                if (!reqbillEntity.equals(billEntity) || !opSet.contains(operationKey)) continue;
                isContainOp = true;
            }
            if (!isContainOp) continue;
            Long wfTypeId = (Long)schemeObj.getDynamicObject("writeofftype").getPkValue();
            wfTypeIdList.add(wfTypeId);
        }
        return wfTypeIdList;
    }

    public static void getDynamicObject(List<DynamicObject> objects, String sortId, String autoBillNo, String ... entryBillNo) {
        DynamicObject dysObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_updownwfrecordt_inh");
        String wfInfo = "{\"autoList\":[{\"billId\":1118072973727679488,\"billNo\":\"" + autoBillNo + "\",\"billType\":\"im_transinbill\",\"delete\":true,\"filterString\":\"\"}]}";
        dysObj.set("headwfinfo_tag", (Object)wfInfo);
        dysObj.set("wfnumber", (Object)sortId);
        DynamicObjectCollection dynamicObjectCollection = dysObj.getDynamicObjectCollection("entry");
        for (String billNo : entryBillNo) {
            DynamicObject object = dynamicObjectCollection.addNew();
            object.set("billno", (Object)billNo);
        }
        objects.add(dysObj);
    }

    private static void startHandBackWriteOff(DynamicObject[] dataEntities) {
        String seq = WriteSeqHelper.getSeq();
        String name = dataEntities[0].getDataEntityType().getName();
        WriteoffTemplateTypeEnum wfTemplateType = WriteOffRecordHelper.getWfTemplateTypeByChildEntity((String)name);
        if (wfTemplateType == null) {
            return;
        }
        DynamicObject wfTypeOb = dataEntities[0].getDynamicObject("writeofftypeid");
        if (wfTypeOb == null) {
            return;
        }
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(Arrays.asList(dataEntities));
        BackFsKdtxParamHolder holder = new BackFsKdtxParamHolder();
        FeeShareTypeConfig wfType = ReverseFeeShareEngine.getWfType(dataEntities[0]);
        holder.getUnWfPluginExtFactory().batchCheck(records, wfType, false);
        if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfTemplateType) {
            for (DynamicObject entry : dataEntities) {
                UpDownBackFsStrategy upDown = new UpDownBackFsStrategy();
                ReverseFeeShareEngine.setBackWfStrategyParam(wfType, seq, holder, upDown);
                upDown.backWriteOff(entry);
            }
        }
        holder.doKdtx();
    }

    private static void setBackWfStrategyParam(FeeShareTypeConfig wfType, String seq, BackFsKdtxParamHolder holder, IBackFsStrategy strategy) {
        if (strategy instanceof AbstractBackFsStrategy) {
            AbstractBackFsStrategy abstractBackWfStrategy = (AbstractBackFsStrategy)strategy;
            abstractBackWfStrategy.setSeq(seq);
            abstractBackWfStrategy.setHolder(holder);
            abstractBackWfStrategy.setTypeConfig(wfType);
        }
        holder.addWfType(wfType);
    }

    private static FeeShareTypeConfig getWfType(DynamicObject wfRecord) {
        DynamicObject wfTypeOb = wfRecord.getDynamicObject("writeofftypeid");
        DynamicObject writeOffObj = BusinessDataServiceHelper.loadSingleFromCache((Object)wfTypeOb.getPkValue(), (String)"msmod_writeofftype");
        FeeShareTypeConfig config = FeeShareTypeConfig.build(writeOffObj);
        return config;
    }
}

