/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareStepAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step.FeeShareCoreSetpAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step.HintQueryBillSetpAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step.UpdateFeeShareNumberSetpAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step.WriteBackBillSetpAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.business.engine.executor.AbstractFeeShareGroupExecutor;
import kd.mpscmm.mscommon.feeshare.common.helper.FeeShareLogHelper;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.proxy.FeeSharePluginProxy;
import kd.mpscmm.mscommon.writeoff.business.engine.action.ActionProcessor;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;

public abstract class AbstractBillFsExecuteAction
extends AbstractFeeShareAction {
    private static final Log logger = LogFactory.getLog(AbstractBillFsExecuteAction.class);

    protected void doAction() {
        Map<Long, List<FeeShareMatchGroup>> typeToScheme = this.getTypeToScheme();
        List<Long> feeShareType = this.sortWriteOffType(typeToScheme.keySet());
        this.doGoupeWriteOff(typeToScheme, feeShareType);
        List<FeeShareLogInfo> logs = ((FeeShareExecuteContext)this.getExecuteContext()).getLogs();
        FeeShareLogHelper.saveLogs(logs);
        try {
            for (FeeShareLogInfo log : logs) {
                FeeSharePluginProxy pluginProxy = ((FeeShareExecuteContext)this.getExecuteContext()).getPluginFactory().createWriteOffPluginProxy(log.getTypeConfig());
                pluginProxy.viewWfLog(Collections.singletonList(log.getWfLogObj()));
            }
        }
        catch (Exception e) {
            logger.error("\u5206\u644a\u65e5\u5fd7\u6269\u5c55\u63d2\u6267\u884c\u62a5\u9519" + e.getMessage());
        }
    }

    private Map<Long, List<FeeShareMatchGroup>> getTypeToScheme() {
        List<FeeShareMatchGroup> groupMap = ((FeeShareExecuteContext)this.getExecuteContext()).getMatchGroupMap();
        HashMap<Long, List<FeeShareMatchGroup>> tsMatchGroup = new HashMap<Long, List<FeeShareMatchGroup>>(16);
        for (FeeShareMatchGroup group : groupMap) {
            Long typeId = group.getTypeConfig().getId();
            MapUtils.mapGetListValue(tsMatchGroup, (Object)typeId).add(group);
        }
        return tsMatchGroup;
    }

    private List<Long> sortWriteOffType(Collection<Long> wfTypeIds) {
        ArrayList<Long> sortWfTypeIds = new ArrayList<Long>(wfTypeIds);
        if (wfTypeIds.size() <= 1) {
            return sortWfTypeIds;
        }
        sortWfTypeIds.sort(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                FeeShareTypeConfig wfType1 = AbstractBillFsExecuteAction.this.getConfigManager().getWfTypeConfigById(o1);
                FeeShareTypeConfig wfType2 = AbstractBillFsExecuteAction.this.getConfigManager().getWfTypeConfigById(o2);
                return wfType1.getPriority().compareTo(wfType2.getPriority());
            }
        });
        return sortWfTypeIds;
    }

    private void doGoupeWriteOff(Map<Long, List<FeeShareMatchGroup>> typeToScheme, List<Long> feeShareType) {
        for (Long wfTypeId : feeShareType) {
            FeeShareTypeContext typeContext = ((FeeShareExecuteContext)this.getExecuteContext()).getTypeContext(wfTypeId);
            List<FeeShareMatchGroup> groups = typeToScheme.get(wfTypeId);
            typeContext.setMatchGroup(groups);
            for (FeeShareMatchGroup group : groups) {
                List<FeeShareObject> feeShareObjects = group.getFeeShareObjects();
                for (FeeShareObject feeShareObject : feeShareObjects) {
                    FeeShareLogInfo feeShareLog = typeContext.getWriteOffLog();
                    FeeShareObjectBase feeShareObjectBase = feeShareObject.getFeeShareObjectBase();
                    feeShareLog.addSrcBillInfo(typeContext.getBillTypeKey(), feeShareObjectBase.getBillNo(), feeShareObjectBase.getBillPk());
                }
            }
            List<AbstractFeeShareStepAction> actions = this.getSetpActions();
            log.info("\u5206\u644a\u5e73\u53f0\u6267\u884c\u5206\u644a\u2014\u2014\u5206\u644a\u7c7b\u522b\uff1a\u3010" + typeContext.getTypeConfig().getName() + "\u3011\u5f00\u59cb");
            new ActionProcessor(actions).doProcess((Object)typeContext);
            typeContext.getHintDataLoader().clearCachedData();
            log.info("\u5206\u644a\u5e73\u53f0\u6267\u884c\u5206\u644a\u2014\u2014\u5206\u644a\u7c7b\u522b\uff1a\u3010" + typeContext.getTypeConfig().getName() + "\u3011\u7ed3\u675f");
        }
    }

    private List<AbstractFeeShareStepAction> getSetpActions() {
        ArrayList<AbstractFeeShareStepAction> actions = new ArrayList<AbstractFeeShareStepAction>();
        actions.add(new UpdateFeeShareNumberSetpAction());
        actions.add(new HintQueryBillSetpAction());
        actions.add(new FeeShareCoreSetpAction(this.getWfGroupExecutor()));
        actions.add(new WriteBackBillSetpAction());
        return actions;
    }

    @Override
    protected void handleException(Exception e) {
        super.handleException(e);
        List<FeeShareLogInfo> logs = ((FeeShareExecuteContext)this.getExecuteContext()).getErrorLogs();
        FeeShareLogHelper.saveLogsWithExeption(logs, e);
    }

    protected abstract AbstractFeeShareGroupExecutor getWfGroupExecutor();
}

