/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareAction;

public class LoadMatchRuleAction
extends AbstractFeeShareAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || this.getConfigManager().getAllSchemeConfigs().isEmpty();
    }

    protected void doAction() {
        List<FsSchemeConfig> schemeConfigMap = this.getConfigManager().getAllSchemeConfigs();
        HashSet<Long> ruleIds = new HashSet<Long>(16);
        for (FsSchemeConfig schemeConfig : schemeConfigMap) {
            DynamicObject matchRule = schemeConfig.getObj().getDynamicObject("matchrule");
            if (matchRule == null) continue;
            ruleIds.add(matchRule.getLong("id"));
        }
        if (ruleIds.isEmpty()) {
            return;
        }
        QFilter matchRuleFilter = new QFilter("id", "in", ruleIds).and("enable", "=", (Object)Boolean.TRUE);
        Map matchRuleEntities = BusinessDataServiceHelper.loadFromCache((String)"msmod_matchrule", (QFilter[])matchRuleFilter.toArray());
        for (DynamicObject matchRuleEntity : matchRuleEntities.values()) {
            FsMatchRuleConfig matchRuleConfig = FsMatchRuleConfig.build(matchRuleEntity);
            this.getConfigManager().addMatchRuleConfig(matchRuleConfig);
        }
    }
}

