/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareBillOperateConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareSchemeContextConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareStepAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.executor.AbstractFeeShareGroupExecutor;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class FeeShareCoreSetpAction
extends AbstractFeeShareStepAction {
    private AbstractFeeShareGroupExecutor wfGroupExecutor;

    public FeeShareCoreSetpAction(AbstractFeeShareGroupExecutor wfGroupExecutor) {
        this.wfGroupExecutor = wfGroupExecutor;
    }

    protected void doAction() {
        FeeShareTypeContext executeContext = (FeeShareTypeContext)this.getExecuteContext();
        List<FeeShareMatchGroup> allWriteOffGourps = executeContext.getMatchGroup();
        if (this.getWFExecuteContext().isFlowFeeShare()) {
            LinkedHashMap<String, List<FeeShareMatchGroup>> sortByFlows = this.sortByFlows(allWriteOffGourps);
            for (List<FeeShareMatchGroup> writeOffMatchGroup : sortByFlows.values()) {
                this.doFeeShare(writeOffMatchGroup);
            }
        } else {
            this.doFeeShare(allWriteOffGourps);
        }
    }

    private LinkedHashMap<String, List<FeeShareMatchGroup>> sortByFlows(List<FeeShareMatchGroup> allWriteOffGourps) {
        allWriteOffGourps.sort((o1, o2) -> {
            FlowFeeShareBillOperateConfig wfFlowConfig = o1.getWfFlowConfig();
            FlowFeeShareBillOperateConfig wfFlowConfig2 = o2.getWfFlowConfig();
            if (wfFlowConfig == null) {
                return -1;
            }
            if (wfFlowConfig2 == null) {
                return 1;
            }
            Integer seq1 = wfFlowConfig.getObj().getInt("seq");
            Integer seq2 = wfFlowConfig2.getObj().getInt("seq");
            if (Integer.compare(seq1, seq2) != 0) {
                return seq1 - seq2;
            }
            FsSchemeConfig schemeConfig1 = o1.getSchemeConfig();
            FsSchemeConfig schemeConfig2 = o2.getSchemeConfig();
            for (FlowFeeShareSchemeContextConfig configs : wfFlowConfig.getSchemeContextConfigs()) {
                if (schemeConfig1.getId().equals(configs.getSchemeId())) {
                    return -1;
                }
                if (!schemeConfig2.getId().equals(configs.getSchemeId())) continue;
                return 1;
            }
            return 0;
        });
        LinkedHashMap<String, List<FeeShareMatchGroup>> sortedMap = new LinkedHashMap<String, List<FeeShareMatchGroup>>();
        for (FeeShareMatchGroup writeOffMatchGroup : allWriteOffGourps) {
            StringBuilder key = new StringBuilder();
            FsSchemeConfig schemeConfig = writeOffMatchGroup.getSchemeConfig();
            if (schemeConfig != null) {
                key.append(schemeConfig.getId());
            }
            key.append("-");
            FlowFeeShareBillOperateConfig wfFlowConfig = writeOffMatchGroup.getWfFlowConfig();
            if (wfFlowConfig != null) {
                key.append(wfFlowConfig.getObjId());
            }
            MapUtils.mapGetListValue(sortedMap, (Object)key.toString()).add(writeOffMatchGroup);
        }
        return sortedMap;
    }

    private void doFeeShare(List<FeeShareMatchGroup> matchGroups) {
        log.info("\u6838\u9500\u5e73\u53f0\u6267\u884c\u6838\u9500\u65b9\u6848" + matchGroups.get(0).getSchemeConfig().getName());
        Iterator<FeeShareMatchGroup> iterator = matchGroups.iterator();
        while (iterator.hasNext()) {
            FeeShareMatchGroup matchGroup = iterator.next();
            matchGroup.filter();
            if (!matchGroup.getFeeShareObjects().isEmpty()) continue;
            iterator.remove();
        }
        if (matchGroups.isEmpty()) {
            return;
        }
        ((FeeShareTypeContext)this.getExecuteContext()).addMatchParams("canwriteoff", true);
        this.wfGroupExecutor.init((FeeShareTypeContext)this.getExecuteContext());
        this.wfGroupExecutor.doExecute(matchGroups);
        if (this.wfGroupExecutor.getMatchObj().booleanValue()) {
            ((FeeShareTypeContext)this.getExecuteContext()).addMatchParams("ismatch", true);
        }
    }
}

