/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareColumnConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.NumeratorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareStepAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.BillDataSource;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.HintDataMatcher;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareManualGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.proxy.MatchPluginProxy;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillBotpLinkInfoManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class HintQueryBillSetpAction
extends AbstractFeeShareStepAction {
    protected void doAction() {
        FeeShareTypeContext executeContext = (FeeShareTypeContext)this.getExecuteContext();
        Map<Long, List<FeeShareMatchGroup>> matchGroup = this.sortBySchemes(executeContext.getMatchGroup());
        for (List<FeeShareMatchGroup> schemeGroup : matchGroup.values()) {
            this.doHintQuery(schemeGroup);
        }
    }

    private Map<Long, List<FeeShareMatchGroup>> sortBySchemes(List<FeeShareMatchGroup> matchGroup) {
        HashMap<Long, List<FeeShareMatchGroup>> schemeGroups = new HashMap<Long, List<FeeShareMatchGroup>>(16);
        for (FeeShareMatchGroup writeOffMatchGroup : matchGroup) {
            MapUtils.mapGetListValue(schemeGroups, (Object)writeOffMatchGroup.getSchemeConfig().getId()).add(writeOffMatchGroup);
        }
        return schemeGroups;
    }

    private void doHintQuery(List<FeeShareMatchGroup> groups) {
        FeeShareMatchGroup writeOffMatchGroup = groups.get(0);
        FsSchemeConfig schemeConfig = writeOffMatchGroup.getSchemeConfig();
        if (schemeConfig.isNoCondition()) {
            return;
        }
        FeeShareTypeConfig typeConfig = writeOffMatchGroup.getTypeConfig();
        FeeShareBillConfig srcBillConf = writeOffMatchGroup.getBillTypeConfig();
        String srcBillAlias = srcBillConf.getBillAlias();
        FsMatchRuleConfig matchRuleConfigById = this.getWFExecuteContext().getConfigManager().getMatchRuleConfigById(schemeConfig.getMatchRuleId(), typeConfig.getId());
        List<FsMatchRelationConfig> byPromoter = matchRuleConfigById.getByPromoter(srcBillAlias);
        for (FsMatchRelationConfig matchRelationConfig : byPromoter) {
            FeeShareBillConfig tgtBillConf = typeConfig.getBillConf(matchRelationConfig.getTargetBillTypeKey());
            MatchPluginProxy matchPluginProxy = ((FeeShareTypeContext)this.getExecuteContext()).getPluginFactory().createMatchPluginProxy(typeConfig, matchRuleConfigById);
            String botpTrackRelation = matchPluginProxy.botpTrackRelation(srcBillConf.getObj(), tgtBillConf.getObj());
            if ("trackup".equals(botpTrackRelation) || "trackdown".equals(botpTrackRelation)) {
                log.info(String.format("HintQueryBill\uff1a\u6838\u9500\u65b9\u6848\u3010%s\u3011\u6267\u884c\u6279\u91cfBotp\u5173\u7cfb\u67e5\u8be2\uff0c\u5173\u7cfb\u4e3a%s", schemeConfig.getName(), botpTrackRelation));
                this.doBotpLinkQuery(botpTrackRelation, groups, schemeConfig, matchRelationConfig, tgtBillConf);
                continue;
            }
            if (!matchRelationConfig.isOnHint()) continue;
            log.info(String.format("HintQueryBill\uff1a\u6838\u9500\u65b9\u6848\u3010%s\u3011\u6267\u884c\u6279\u91cfHint\u6761\u4ef6\u67e5\u8be2", schemeConfig.getName()));
            this.doHintQuery(groups, schemeConfig, matchRelationConfig, tgtBillConf);
        }
    }

    private void doBotpLinkQuery(String botpTrackRelation, List<FeeShareMatchGroup> groups, FsSchemeConfig schemeConfig, FsMatchRelationConfig matchRelationConfig, FeeShareBillConfig tgtBillConf) {
        FeeShareBillConfig srcBillConf = groups.get(0).getBillTypeConfig();
        if (srcBillConf.getWriteOffColumnConfig() == null) {
            return;
        }
        HashMap billToFieldIds = new HashMap(16);
        for (FeeShareMatchGroup group : groups) {
            List<FeeShareObject> feeShareObjects = group.getFeeShareObjects();
            Iterator<FeeShareObject> iterator = feeShareObjects.iterator();
            while (iterator.hasNext()) {
                FeeShareObject writeOffObject = iterator.next();
                MapUtils.mapGetSetValue(billToFieldIds, (Object)((Long)writeOffObject.getBillPk())).add((Long)writeOffObject.getPkValue());
            }
        }
        Map findNodes = null;
        if ("trackup".equals(botpTrackRelation)) {
            findNodes = new BillBotpLinkInfoManager().findLinkUpNodes(srcBillConf.getBillType(), srcBillConf.getMainFieldEntry(), billToFieldIds, tgtBillConf.getBillType());
        } else if ("trackdown".equals(botpTrackRelation)) {
            findNodes = new BillBotpLinkInfoManager().findLinkDownNodes(srcBillConf.getBillType(), srcBillConf.getMainFieldEntry(), billToFieldIds, tgtBillConf.getBillType());
        }
        if (findNodes == null || findNodes.isEmpty()) {
            HintDataMatcher hintDataLoader = ((FeeShareTypeContext)this.getExecuteContext()).getHintDataLoader();
            hintDataLoader.addMatchData(matchRelationConfig.getMatchId(), Collections.emptyList(), Collections.singletonList(CommonHelper.getEmptyFilter()), tgtBillConf, Collections.emptyList());
            return;
        }
        HashMap<Long, Set<Long>> srcToTgtList = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry entry : findNodes.entrySet()) {
            HashSet<Long> targetIds = new HashSet<Long>(16);
            for (BFRowId row : (List)entry.getValue()) {
                targetIds.add(row.getEntryId());
            }
            srcToTgtList.put((Long)entry.getKey(), (Set<Long>)targetIds);
        }
        String entryKey = this.getEntryKey(tgtBillConf, schemeConfig);
        List<QFilter> list = this.buildBotpLinkQueryFilter(matchRelationConfig, tgtBillConf, groups, entryKey, srcToTgtList);
        ArrayList<FsMatchConditionConfig> botpFields = new ArrayList<FsMatchConditionConfig>(2);
        botpFields.add(FsMatchConditionConfig.build(entryKey + ".id", entryKey + ".id"));
        BillDataSource billDataSource = this.getWFExecuteContext().getBillDataSource();
        DynamicObjectCollection hintQueryResults = billDataSource.queryBillData(tgtBillConf.getBillType(), entryKey, list.toArray(new QFilter[list.size()]));
        HintDataMatcher hintDataLoader = ((FeeShareTypeContext)this.getExecuteContext()).getHintDataLoader();
        hintDataLoader.addBotpLinkMatchData(matchRelationConfig.getMatchId(), (List<DynamicObject>)hintQueryResults, list, srcToTgtList, botpTrackRelation, tgtBillConf, botpFields);
    }

    public List<QFilter> buildBotpLinkQueryFilter(FsMatchRelationConfig matchRelationConfig, FeeShareBillConfig tgtBillConf, List<FeeShareMatchGroup> groups, String entryKey, Map<Long, Set<Long>> srcToTgtList) {
        String wfMainFieldId = null;
        wfMainFieldId = StringUtils.isNotEmpty((CharSequence)entryKey) ? entryKey + ".id" : "id";
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Set<Long> rows : srcToTgtList.values()) {
            ids.addAll(rows);
        }
        ArrayList<QFilter> botpLinkFilters = new ArrayList<QFilter>(16);
        botpLinkFilters.add(new QFilter(wfMainFieldId, "in", ids));
        botpLinkFilters.addAll(this.getCommonFilter(tgtBillConf));
        return botpLinkFilters;
    }

    private void doHintQuery(List<FeeShareMatchGroup> groups, FsSchemeConfig schemeConfig, FsMatchRelationConfig matchRelationConfig, FeeShareBillConfig tgtBillConf) {
        String entryKey = this.getEntryKey(tgtBillConf, schemeConfig);
        List<QFilter> hintQueryFilters = this.buildHintQueryFilter(matchRelationConfig, tgtBillConf, groups, entryKey);
        List<FsMatchConditionConfig> hintConfigs = matchRelationConfig.getHintConfigs();
        this.queryHintData(tgtBillConf, matchRelationConfig, hintQueryFilters, entryKey, hintConfigs);
    }

    public List<QFilter> buildHintQueryFilter(FsMatchRelationConfig matchRelationConfig, FeeShareBillConfig tgtBillConf, List<FeeShareMatchGroup> groups, String entryKey) {
        String wfMainFieldId = null;
        if (StringUtils.isNotEmpty((CharSequence)entryKey)) {
            wfMainFieldId = entryKey + ".id";
        }
        ArrayList<QFilter> hintQueryFilters = new ArrayList<QFilter>(16);
        List<QFilter> hintFilter = matchRelationConfig.getHintFilter(groups, wfMainFieldId);
        hintQueryFilters.addAll(hintFilter);
        hintQueryFilters.addAll(this.getCommonFilter(tgtBillConf));
        return hintQueryFilters;
    }

    private String getEntryKey(FeeShareBillConfig tgtBillConf, FsSchemeConfig schemeConfig) {
        FeeShareTypeConfig typeConfig = tgtBillConf.getTypeConfig();
        if (typeConfig.isShare()) {
            Long shareRuleId = schemeConfig.getShareRuleId();
            if (shareRuleId != null) {
                ShareRuleConfig shareRuleConfig = this.getWFExecuteContext().getConfigManager().getShareRuleConfigById(shareRuleId);
                List<ShareRuleBillConfig> shareBillConfigs = shareRuleConfig.getShareBillConfigs();
                for (ShareRuleBillConfig shareRuleBillConfig : shareBillConfigs) {
                    NumeratorConfig numerator = shareRuleBillConfig.getNumerator();
                    String mainFieldEntry = numerator.getWfFieldInfo().getMainFieldCalClass().mainFieldEntry();
                    if (StringUtils.isEmpty((CharSequence)mainFieldEntry)) continue;
                    return mainFieldEntry;
                }
            }
            return null;
        }
        return tgtBillConf.getWriteOffColumnConfig().mainFieldCalClass().mainFieldEntry();
    }

    private List<QFilter> getCommonFilter(FeeShareBillConfig tgtBillConf) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        List<QFilter> wfTypeFilter = tgtBillConf.getFilters();
        filters.addAll(wfTypeFilter);
        List<FeeShareManualGroup> manualGroups = this.getWFExecuteContext().getWriteOffManualGroups();
        for (FeeShareManualGroup mGroup : manualGroups) {
            List<IWFFilter> filter = mGroup.getFilter();
            if (!tgtBillConf.getBillAlias().equals(mGroup.getBillTypeConfig().getBillAlias()) || filter.isEmpty()) continue;
            filters.add(IWFFilter.toSingleQFilter(mGroup.getFilter()));
        }
        FeeShareColumnConfig writeOffColumnConfig = tgtBillConf.getWriteOffColumnConfig();
        if (writeOffColumnConfig != null && writeOffColumnConfig.getWfFieldInfo().isWfBillField()) {
            String mainField = writeOffColumnConfig.getWriteOffFieldKey();
            filters.add(new QFilter(mainField, "!=", (Object)BigDecimal.ZERO));
        }
        return filters;
    }

    private void queryHintData(FeeShareBillConfig tgtBillConf, FsMatchRelationConfig matchRelationConfig, List<QFilter> hintQueryFilters, String entryKey, List<FsMatchConditionConfig> hintConfigs) {
        if (hintQueryFilters.isEmpty()) {
            log.info("\u6838\u9500Hint\u67e5\u8be2\u9519\u8bef\uff0c\u65e0\u6cd5\u751f\u6210Hint\u67e5\u8be2\u8fc7\u6ee4\u6761\u4ef6");
            return;
        }
        log.info("\u6838\u9500Hint\u67e5\u8be2\u8fc7\u6ee4\u6761\u4ef6\uff1a" + hintQueryFilters);
        boolean isExistEmptyQFilter = this.isExistEmptyQFilter(hintQueryFilters);
        DynamicObjectCollection hintQueryResults = null;
        if (isExistEmptyQFilter) {
            hintQueryResults = Collections.emptyList();
        } else {
            BillDataSource billDataSource = this.getWFExecuteContext().getBillDataSource();
            hintQueryResults = billDataSource.queryBillData(tgtBillConf.getBillType(), entryKey, hintQueryFilters.toArray(new QFilter[hintQueryFilters.size()]));
            log.info("Hint\u5339\u914d\u67e5\u8be2\u6570\u636e\u91cfSize\uff1a" + hintQueryResults.size());
        }
        HintDataMatcher hintDataLoader = ((FeeShareTypeContext)this.getExecuteContext()).getHintDataLoader();
        hintDataLoader.addMatchData(matchRelationConfig.getMatchId(), (List<DynamicObject>)hintQueryResults, hintQueryFilters, tgtBillConf, hintConfigs);
    }

    private boolean isExistEmptyQFilter(List<QFilter> hintQueryFilters) {
        for (QFilter qFilter : hintQueryFilters) {
            if (!"1 != 1".equals(qFilter.toString())) continue;
            return true;
        }
        return false;
    }
}

