/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.action.impl.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareStepAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareBillGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.business.engine.param.impl.ManualFeeShareReqParam;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;
import org.apache.commons.collections.CollectionUtils;

public class UpdateFeeShareNumberSetpAction
extends AbstractFeeShareStepAction {
    protected boolean isSkipAction() {
        FeeShareTypeContext executeContext = (FeeShareTypeContext)this.getExecuteContext();
        List<FeeShareMatchGroup> matchGroup = executeContext.getMatchGroup();
        if (CollectionUtils.isEmpty(matchGroup) || executeContext.getExecuteContext().isManualFeeShare()) {
            return true;
        }
        if (matchGroup.get(0).getBillTypeConfig().isShareAssist()) {
            return true;
        }
        return super.isSkipAction();
    }

    protected void doAction() {
        FeeShareTypeContext executeContext = (FeeShareTypeContext)this.getExecuteContext();
        List<FeeShareMatchGroup> matchGroupList = ((FeeShareTypeContext)this.getExecuteContext()).getMatchGroup();
        FeeShareBillConfig billTypeConfig = matchGroupList.get(0).getBillTypeConfig();
        if (billTypeConfig.isShareAssist()) {
            return;
        }
        ArrayList<Object> wfObIdList = new ArrayList<Object>(16);
        ArrayList<Object> wfBillIds = new ArrayList<Object>(16);
        for (FeeShareBillGroup feeShareBillGroup : matchGroupList) {
            List<FeeShareObject> writeOffObjects = feeShareBillGroup.getFeeShareObjects();
            for (FeeShareObject feeShareObject : writeOffObjects) {
                wfObIdList.add(feeShareObject.getPkValue());
                wfBillIds.add(feeShareObject.getBillPk());
            }
        }
        String reqbillEntity = billTypeConfig.getBillType();
        executeContext.setBillTypeKey(reqbillEntity);
        executeContext.getSnapshotContext().loadSnapShootMap(wfBillIds, reqbillEntity);
        boolean bl = executeContext.getExecuteContext().getReqParam() instanceof ManualFeeShareReqParam;
        if (bl) {
            return;
        }
        Map<Object, BigDecimal> wfNumberMap = UpdateFeeShareNumberSetpAction.getWfNumberMap(billTypeConfig, wfObIdList);
        for (FeeShareBillGroup feeShareBillGroup : matchGroupList) {
            Iterator<FeeShareObject> iterator = feeShareBillGroup.getFeeShareObjects().iterator();
            while (iterator.hasNext()) {
                FeeShareObject feeShareObject = iterator.next();
                BigDecimal wfNumber = wfNumberMap.get(feeShareObject.getPkValue());
                BigDecimal subtractNum = wfNumber.subtract(executeContext.getFeeShareQty(feeShareObject));
                if (subtractNum.compareTo(BigDecimal.ZERO) == 0) {
                    iterator.remove();
                    continue;
                }
                feeShareObject.setCurFeeShareNumber(wfNumber);
                feeShareObject.setFeeShareNumber(subtractNum);
            }
        }
    }

    private static Map<Object, BigDecimal> getWfNumberMap(FeeShareBillConfig writeOffBillConfig, List<Object> wfObjectIds) {
        HashMap<Object, BigDecimal> wfNumberMap = new HashMap<Object, BigDecimal>(16);
        String wfCalcFieldIdName = writeOffBillConfig.getWfCalcFieldIdName();
        IWriteOffMainFieldCalPlugin mainFieldCalPlugin = writeOffBillConfig.getWriteOffColumnConfig().mainFieldCalClass();
        List fields = mainFieldCalPlugin.calNeedFields();
        String billType = writeOffBillConfig.getBillType();
        String selectFields = BillFieldInfoManager.buildSelectField(billType, mainFieldCalPlugin.mainFieldEntry(), fields);
        QFilter wfObjectIdFilter = new QFilter(wfCalcFieldIdName, "in", wfObjectIds);
        DynamicObjectCollection queryBills = QueryServiceHelper.query((String)billType, (String)(wfCalcFieldIdName + "," + selectFields), (QFilter[])wfObjectIdFilter.toArray());
        for (DynamicObject bill : queryBills) {
            BigDecimal wfNumber = writeOffBillConfig.getWriteOffColumnConfig().mainFieldCalClass().mainFieldCal(bill);
            wfNumberMap.put(bill.get(wfCalcFieldIdName), wfNumber);
        }
        return wfNumberMap;
    }
}

