/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.kdtx.KdtxUnFeeShareService;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.UnFsPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;

public class BackFsKdtxParamHolder {
    private static final Log logger = LogFactory.getLog(BackFsKdtxParamHolder.class);
    private Map<String, Map<String, List<Object[]>>> sqlListMap = new HashMap<String, Map<String, List<Object[]>>>(16);
    private Map<Long, List<DynamicObject>> recordMap = new HashMap<Long, List<DynamicObject>>(16);
    private Set<String> businessInfos = new HashSet<String>(16);
    Map<Long, FeeShareTypeConfig> wfTypeMap = new HashMap<Long, FeeShareTypeConfig>(8);
    private UnFsPluginExtFactory unWfPluginExtFactory = new UnFsPluginExtFactory();

    public void doKdtx() {
        if (TX.inTX()) {
            this.exectKdtx();
        } else {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    this.exectKdtx();
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private void exectKdtx() {
        long start = System.currentTimeMillis();
        this.buildBusinessKeys();
        KdtxUnFeeShareService service = new KdtxUnFeeShareService(this.businessInfos, this.wfTypeMap, false, false);
        this.backPluginSql();
        service.kdtxUnWfPlugin(this.recordMap);
        service.kdtxDeleteWriteOffRecord(this.recordMap);
        service.kdtxBackWriteBill(this.sqlListMap, this.recordMap);
        long end = System.currentTimeMillis();
        logger.info("\u6267\u884c\u6700\u7ec8\u4e00\u81f4\u6027\u63a5\u53e3\u65f6\u95f4exectKdtx:" + (end - start) + "ms");
    }

    private void buildBusinessKeys() {
        for (Map.Entry<Long, List<DynamicObject>> record : this.recordMap.entrySet()) {
            List<DynamicObject> recordList = record.getValue();
            for (DynamicObject recordBill : recordList) {
                String recordType = recordBill.getDataEntityType().getName();
                this.businessInfos.add(recordType + "#" + recordBill.getPkValue());
            }
        }
    }

    private void backPluginSql() {
        for (Map.Entry<Long, List<DynamicObject>> record : this.recordMap.entrySet()) {
            Long wfTypeId = record.getKey();
            List<DynamicObject> value = record.getValue();
            Map<String, Map<String, List<Object[]>>> stringMapMap = this.getUnWfPluginExtFactory().buildBackSql(value, this.getWfType(wfTypeId));
            CommonUtils.buildSqlMap(this.sqlListMap, stringMapMap);
        }
    }

    public void addSql(String dbRouteKey, String sql, Object[] param) {
        List<Object[]> objects;
        Map<String, List<Object[]>> stringListMap = this.sqlListMap.get(dbRouteKey);
        if (stringListMap == null) {
            stringListMap = new HashMap<String, List<Object[]>>(16);
        }
        if ((objects = stringListMap.get(sql)) == null) {
            objects = new ArrayList<Object[]>(16);
        }
        objects.add(param);
        stringListMap.put(sql, objects);
        this.sqlListMap.put(dbRouteKey, stringListMap);
    }

    public void addWfType(FeeShareTypeConfig typeConfig) {
        this.wfTypeMap.put(typeConfig.getId(), typeConfig);
    }

    public void addWfRecord(DynamicObject record, FeeShareTypeConfig config) {
        List<DynamicObject> longListMap = this.recordMap.get(config.getId());
        if (longListMap == null) {
            longListMap = new ArrayList<DynamicObject>(16);
        }
        longListMap.add(record);
        this.recordMap.put(config.getId(), longListMap);
    }

    private FeeShareTypeConfig getWfType(Long typeId) {
        return this.wfTypeMap.get(typeId);
    }

    public Map<String, Map<String, List<Object[]>>> getSqlListMap() {
        return this.sqlListMap;
    }

    public void setSqlListMap(Map<String, Map<String, List<Object[]>>> sqlListMap) {
        this.sqlListMap = sqlListMap;
    }

    public Map<Long, List<DynamicObject>> getRecordMap() {
        return this.recordMap;
    }

    public void setRecordMap(Map<Long, List<DynamicObject>> recordMap) {
        this.recordMap = recordMap;
    }

    public UnFsPluginExtFactory getUnWfPluginExtFactory() {
        return this.unWfPluginExtFactory;
    }

    public BackFsKdtxParamHolder setUnWfPluginExtFactory(UnFsPluginExtFactory unWfPluginExtFactory) {
        this.unWfPluginExtFactory = unWfPluginExtFactory;
        return this;
    }
}

