/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.context;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareColumnConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.context.AbstractFeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.context.IFeeShareQtyHolder;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.FsPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffOverCheckResult;
import kd.mpscmm.mscommon.writeoff.common.consts.WfSnapShootConst;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class FeeShareSnapshotContext
extends AbstractFeeShareTypeContext
implements IFeeShareQtyHolder {
    private static final Log logger = LogFactory.getLog(FeeShareTypeContext.class);
    private static final String UPDATESTATUSSQL = "update t_msmod_wf_sp set fstatus = 'B' where fid = ?";
    private static DBRoute SP_DBRoute = new DBRoute(MetadataServiceHelper.getDataEntityType((String)WfSnapShootConst.ENTITY).getDBRouteKey());
    private Set<DynamicObject> snapShoots = new HashSet<DynamicObject>(8);
    private Set<Long> snapShootIds = new HashSet<Long>(8);
    private Map<String, Set<Long>> snapShootIdMap = new HashMap<String, Set<Long>>(8);
    private Map<String, BigDecimal> snapShootWfQtyMap = new HashMap<String, BigDecimal>(16);
    private Map<String, BigDecimal> loadSnapShootWfQtyMap = new HashMap<String, BigDecimal>(16);

    public FeeShareSnapshotContext(FeeShareTypeConfig typeConfig) {
        super(typeConfig);
    }

    public void loadSnapShootMap(Map<String, List<Object>> entityids) {
        this.loadSnapShootWfQtyMap.clear();
        for (Map.Entry<String, List<Object>> entityId : entityids.entrySet()) {
            this.loadSnapShootData((Collection<Object>)entityId.getValue(), entityId.getKey());
        }
    }

    public void loadSnapShootMap(Collection<Object> ids, String entityName) {
        this.loadSnapShootWfQtyMap.clear();
        this.loadSnapShootData(ids, entityName);
    }

    private void loadSnapShootData(Collection<Object> ids, String entityName) {
        QFilter spFilter = new QFilter("verifybillid", "in", ids);
        spFilter.and("verifyform", "=", (Object)entityName);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)WfSnapShootConst.ENTITY, (String)"verifyform,verifybillid,verifyentrysign,verifybilleid,verifyfield,verifyqty", (QFilter[])spFilter.toArray(), null).groupBy(new String[]{"verifyform", "verifybillid", "verifyentrysign", "verifybilleid", "verifyfield"}).sum("verifyqty").finish();){
            for (Row row : dataSet) {
                String veriform = row.getString("verifyform");
                Long verifybillid = row.getLong("verifybillid");
                String verifyentrysign = row.getString("verifyentrysign");
                Long verifybilleid = row.getLong("verifybilleid");
                String verifyfield = row.getString("verifyfield");
                BigDecimal verifyqty = row.getBigDecimal("verifyqty");
                String spKey = this.buildSnapShotKey(verifyfield, verifybillid, veriform, verifybilleid, verifyentrysign);
                this.loadSnapShootWfQtyMap.put(spKey, verifyqty);
            }
        }
    }

    public void addSnapShots(Collection<FeeShareObjectBase> writeOffObjects) {
        for (FeeShareObjectBase writeOffObjectBase : writeOffObjects) {
            this.addSnapShot(writeOffObjectBase);
        }
    }

    public void addSnapShot(FeeShareObjectBase feeShareObject) {
        FeeShareBillConfig writeOffBillConfig;
        Long billid = (Long)feeShareObject.getBillPk();
        MainEntityType wfBillEntityType = feeShareObject.getWFBillEntityType();
        String entity = feeShareObject.getWFBillEntityName();
        Long entryid = (Long)feeShareObject.getPkValue();
        String entrysign = feeShareObject.getMainFieldEntityType().getName();
        boolean isHead = entity.equals(entrysign);
        if (isHead) {
            entrysign = " ";
            entryid = 0L;
        }
        if ((writeOffBillConfig = this.getTypeConfig().getBillConfigsById((Long)feeShareObject.getWfBillEntity().getPkValue())).isShareAssist()) {
            return;
        }
        FeeShareColumnConfig writeOffColumnConfig = writeOffBillConfig.getWriteOffColumnConfig();
        boolean isplugin = "C".equals(writeOffColumnConfig.getValueMethod());
        String verifyField = feeShareObject.getPrimaryColumn();
        if (isplugin) {
            verifyField = writeOffColumnConfig.mainFieldCalClass().getClass().getName();
        }
        DynamicObject snapShoot = BusinessDataServiceHelper.newDynamicObject((String)WfSnapShootConst.ENTITY);
        Long id = DB.genLongId((String)WfSnapShootConst.TABLE);
        snapShoot.set("id", (Object)id);
        snapShoot.set(WfSnapShootConst.STATUS, (Object)"A");
        snapShoot.set(WfSnapShootConst.EXETIME, (Object)TimeServiceHelper.now());
        snapShoot.set(WfSnapShootConst.VERIFYFORM, (Object)entity);
        snapShoot.set(WfSnapShootConst.VERIFYBILLID, (Object)billid);
        snapShoot.set(WfSnapShootConst.VERIFYENTRYSIGN, (Object)entrysign);
        snapShoot.set(WfSnapShootConst.VERIFYBILLENTRYID, (Object)entryid);
        snapShoot.set(WfSnapShootConst.ISPLUGIN, (Object)isplugin);
        snapShoot.set(WfSnapShootConst.VERIFYFIELD, (Object)verifyField);
        snapShoot.set(WfSnapShootConst.VERIFYQTY, (Object)feeShareObject.getFeeShareNumber());
        String snapShootKey = this.buildSnapShotKey(verifyField, billid, entity, entryid, entrysign);
        BigDecimal snapShootWfQty = this.snapShootWfQtyMap.get(snapShootKey);
        snapShootWfQty = snapShootWfQty != null ? snapShootWfQty.add(feeShareObject.getFeeShareNumber()) : feeShareObject.getFeeShareNumber();
        this.snapShootWfQtyMap.put(snapShootKey, snapShootWfQty);
        this.snapShoots.add(snapShoot);
        this.snapShootIds.add(id);
        Set ids = this.snapShootIdMap.computeIfAbsent(wfBillEntityType.getDBRouteKey(), k -> new HashSet());
        ids.add(id);
    }

    public void deleteSnapShoots() {
        if (this.snapShootIds.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)WfSnapShootConst.ENTITY), (Object[])this.snapShootIds.toArray());
        }
    }

    public void updateSnapShootStatus() {
        if (this.snapShootIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(8);
        for (Long snapShootId : this.snapShootIds) {
            params.add(new Object[]{snapShootId});
        }
        try (TXHandle tx = TX.requiresNew();){
            DB.executeBatch((DBRoute)SP_DBRoute, (String)UPDATESTATUSSQL, params);
        }
    }

    public void saveWfSnapShoot() {
        if (this.snapShoots.isEmpty()) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])this.snapShoots.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public BigDecimal getFeeShareQty(FeeShareObject feeShareObj) {
        String snapShotKey = feeShareObj.getMainColumn().getWriteOffFieldKey();
        return this.getFeeShareQty(feeShareObj.getFeeShareObjectBase(), snapShotKey);
    }

    private BigDecimal getFeeShareQty(FeeShareObjectBase baseObj, String snapFieldKey) {
        BigDecimal wfQty2;
        Long billid = (Long)baseObj.getBillPk();
        String entity = baseObj.getWFBillEntityName();
        Long entryid = (Long)baseObj.getPkValue();
        String entrysign = baseObj.getMainFieldEntityType().getName();
        boolean isHead = entity.equals(entrysign);
        if (isHead) {
            entrysign = " ";
            entryid = 0L;
        }
        String snapShootKey = this.buildSnapShotKey(snapFieldKey, billid, entity, entryid, entrysign);
        BigDecimal writeOffQty = BigDecimal.ZERO;
        BigDecimal wfQty1 = this.snapShootWfQtyMap.get(snapShootKey);
        if (wfQty1 != null) {
            writeOffQty = writeOffQty.add(wfQty1);
        }
        if ((wfQty2 = this.loadSnapShootWfQtyMap.get(snapShootKey)) != null) {
            writeOffQty = writeOffQty.add(wfQty2);
        }
        return writeOffQty;
    }

    public BigDecimal getSnapShotValue(String snapFieldKey, Long billid, String entity, Long entryid, String entrysign) {
        String key = this.buildSnapShotKey(snapFieldKey, billid, entity, entryid, entrysign);
        BigDecimal result = this.loadSnapShootWfQtyMap.get(key);
        return result == null ? BigDecimal.ZERO : result;
    }

    public List<WriteOffOverCheckResult> checkPass() {
        this.checkWriteOffTx();
        HashMap<String, Set<Long>> entityField2BillIds = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set<Long>> entityField2BillEntryIds = new HashMap<String, Set<Long>>(16);
        HashMap<String, String> entrySignMap = new HashMap<String, String>(16);
        HashSet<DynamicObject> isPluginSPs = new HashSet<DynamicObject>(16);
        HashMap<String, Set<String>> queryFieldMap = new HashMap<String, Set<String>>(16);
        HashMap<String, IWriteOffMainFieldCalPlugin> mainFieldCals = new HashMap<String, IWriteOffMainFieldCalPlugin>(16);
        HashMap<String, Set<Long>> entity2isPluginIdMap = new HashMap<String, Set<Long>>(16);
        HashSet<Long> verifybillids = new HashSet<Long>(16);
        HashSet<Long> verifybilleids = new HashSet<Long>(16);
        HashSet<String> entitys = new HashSet<String>(16);
        HashSet<String> keys = new HashSet<String>(16);
        for (DynamicObject snapShoot : this.snapShoots) {
            String entitykey = snapShoot.getString(WfSnapShootConst.VERIFYFORM);
            String verifyfield = snapShoot.getString(WfSnapShootConst.VERIFYFIELD);
            Long billid = snapShoot.getLong(WfSnapShootConst.VERIFYBILLID);
            Long billEntryid = snapShoot.getLong(WfSnapShootConst.VERIFYBILLENTRYID);
            String entrySign = snapShoot.getString(WfSnapShootConst.VERIFYENTRYSIGN);
            boolean isplugin = snapShoot.getBoolean(WfSnapShootConst.ISPLUGIN);
            entitys.add(entitykey);
            verifybillids.add(billid);
            verifybilleids.add(billEntryid);
            keys.add(entitykey + billid + billEntryid + verifyfield);
            if (isplugin) {
                isPluginSPs.add(snapShoot);
                Set billIds = entity2isPluginIdMap.computeIfAbsent(entitykey, k -> new HashSet(16));
                billIds.add(billid);
                IWriteOffMainFieldCalPlugin mainFieldCalClass = (IWriteOffMainFieldCalPlugin)mainFieldCals.get(entitykey + verifyfield);
                if (mainFieldCalClass != null || (mainFieldCalClass = FsPluginExtFactory.getWfMainFiledPlugin(verifyfield)) == null) continue;
                ArrayList<String> fields = new ArrayList<String>(16);
                fields.add("id");
                String entryKey = mainFieldCalClass.mainFieldEntry();
                if (StringUtils.isNotEmpty((CharSequence)entryKey)) {
                    fields.add(entryKey + ".id");
                }
                fields.addAll(mainFieldCalClass.calNeedFields());
                MapUtils.mapGetSetValue(queryFieldMap, (Object)entitykey).addAll(fields);
                mainFieldCals.put(entitykey + verifyfield, mainFieldCalClass);
                continue;
            }
            String key = entitykey + "#" + verifyfield;
            Set billIds = entityField2BillIds.computeIfAbsent(key, k -> new HashSet(16));
            Set billEntryIds = entityField2BillEntryIds.computeIfAbsent(key, k -> new HashSet(16));
            billIds.add(billid);
            billEntryIds.add(billEntryid);
            entrySignMap.put(key, entrySign);
        }
        DataSet spDS = this.getCheckSPDS(entitys, verifybillids, verifybilleids, keys);
        if (spDS == null) {
            return Collections.emptyList();
        }
        DataSet bill = this.getCheckBillDSByPlugin(isPluginSPs, entity2isPluginIdMap, mainFieldCals, queryFieldMap);
        DataSet billDS = this.getCheckBillDS(entityField2BillIds, entityField2BillEntryIds, entrySignMap, bill);
        if (billDS == null) {
            return Collections.emptyList();
        }
        billDS.updateField("entryid", "LONG(entryid)");
        DataSet dataSet = billDS.join(spDS, JoinType.INNER).on("id", "verifybillid").on("entryid", "verifybilleid").on("groupno", "groupno").select(new String[]{"id", "entryid", "groupno", "qty"}, new String[]{"verifyqty"}).finish();
        dataSet = dataSet.where("abs(qty)-abs(verifyqty) < 0");
        HashMap<String, WriteOffOverCheckResult> results = new HashMap<String, WriteOffOverCheckResult>(16);
        for (Row row : dataSet) {
            String groupno = row.getString("groupno");
            Long id = row.getLong("id");
            Long entryid = row.getLong("entryid");
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal verifyqty = row.getBigDecimal("verifyqty");
            WriteOffOverCheckResult reuslt = new WriteOffOverCheckResult(groupno, entryid, id, qty, verifyqty);
            results.put(reuslt.buildKey(), reuslt);
        }
        if (!results.isEmpty()) {
            logger.error("\u5206\u644a\u53cd\u5199\u8d85\u989d\uff1a" + results.keySet());
            return new ArrayList<WriteOffOverCheckResult>(results.values());
        }
        return Collections.emptyList();
    }

    private void checkWriteOffTx() {
        if (!TX.inTX()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u670d\u52a1\u5fc5\u987b\u5728\u4e8b\u52a1\u5185\u6ce8\u518c\u3002", (String)"WfSnapShootHolder_5", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]));
        }
    }

    private DataSet getCheckSPDS(Set<String> entitys, Set<Long> verifybillids, Set<Long> verifybilleids, Set<String> keys) {
        QFilter spFilter = new QFilter("verifyform", "in", entitys);
        spFilter.and("verifybillid", "in", verifybillids);
        spFilter.and("verifybilleid", "in", verifybilleids);
        try (DataSet spDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)WfSnapShootConst.ENTITY, (String)"verifyform,verifybillid,verifybilleid,verifyfield,verifyqty", (QFilter[])spFilter.toArray(), null);){
            DataSet sp;
            RowMeta rowMeta = new RowMeta(new Field[]{new Field("verifybillid", (DataType)DataType.LongType), new Field("verifybilleid", (DataType)DataType.LongType), new Field("groupno", (DataType)DataType.StringType), new Field("verifyqty", (DataType)DataType.BigDecimalType)});
            DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
            for (Row row : spDataSet) {
                Long verifybillid = row.getLong("verifybillid");
                Long verifybilleid = row.getLong("verifybilleid");
                String entity = row.getString("verifyform");
                String verifyfield = row.getString("verifyfield");
                BigDecimal verifyqty = row.getBigDecimal("verifyqty");
                if (!keys.contains(entity + verifybillid + verifybilleid + verifyfield)) continue;
                builder.append(new Object[]{verifybillid, verifybilleid, entity + "#" + verifyfield, verifyqty});
            }
            DataSet dataSet = sp = builder.build().groupBy(new String[]{"verifybillid", "verifybilleid", "groupno"}).sum("verifyqty").finish();
            return dataSet;
        }
    }

    private DataSet getCheckBillDSByPlugin(Set<DynamicObject> isPluginSPs, Map<String, Set<Long>> entity2isPluginIdMap, Map<String, IWriteOffMainFieldCalPlugin> mainFieldCals, Map<String, Set<String>> queryFieldMap) {
        if (isPluginSPs == null || isPluginSPs.isEmpty()) {
            return null;
        }
        HashMap<String, DynamicObject> infoMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<String, Set<Long>> entry : entity2isPluginIdMap.entrySet()) {
            DynamicObject[] infos;
            String entity = entry.getKey();
            Set<Long> ids = entry.getValue();
            Set<String> selectFields = queryFieldMap.get(entity);
            for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)entity, (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter("id", "in", ids).toArray())) {
                Long id = info.getLong("id");
                infoMap.put((String)entity + "#" + id, info);
            }
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("entryid", (DataType)DataType.LongType), new Field("groupno", (DataType)DataType.StringType), new Field("qty", (DataType)DataType.BigDecimalType)});
        DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (DynamicObject snapShoot : isPluginSPs) {
            DynamicObject info;
            String entitykey = snapShoot.getString(WfSnapShootConst.VERIFYFORM);
            String verifyfield = snapShoot.getString(WfSnapShootConst.VERIFYFIELD);
            Long billid = snapShoot.getLong(WfSnapShootConst.VERIFYBILLID);
            Long billEntryid = snapShoot.getLong(WfSnapShootConst.VERIFYBILLENTRYID);
            String entrySign = snapShoot.getString(WfSnapShootConst.VERIFYENTRYSIGN);
            info = (DynamicObject)infoMap.get(entitykey + "#" + billid);
            if (info == null) continue;
            IWriteOffMainFieldCalPlugin mainFieldCalClass = mainFieldCals.get(entitykey + verifyfield);
            BigDecimal value = null;
            if (StringUtils.isBlank((CharSequence)entrySign)) {
                value = mainFieldCalClass.mainFieldCal(info);
            } else {
                DynamicObjectCollection entry = info.getDynamicObjectCollection(entrySign);
                for (DynamicObject entryRow : entry) {
                    Long id = entryRow.getLong("id");
                    if (id.compareTo(billEntryid) != 0) continue;
                    value = mainFieldCalClass.mainFieldCal(entryRow).setScale(10, RoundingMode.HALF_UP);
                }
            }
            if (value == null) continue;
            builder.append(new Object[]{billid, billEntryid, entitykey + "#" + verifyfield, value});
        }
        DataSet bill = builder.build();
        return bill;
    }

    private DataSet getCheckBillDS(Map<String, Set<Long>> entityField2BillIds, Map<String, Set<Long>> entityField2BillEntryIds, Map<String, String> entrySignMap, DataSet bill) {
        ArrayList<DataSet> bills = new ArrayList<DataSet>(16);
        for (Map.Entry<String, Set<Long>> entry : entityField2BillIds.entrySet()) {
            String expression;
            String[] fields;
            String key = entry.getKey();
            Set<Long> billIds = entry.getValue();
            Set<Long> entryids = entityField2BillEntryIds.get(key);
            String entrySign = entrySignMap.get(key);
            String[] keys = key.split("#");
            String entity = keys[0];
            String realFields = this.getRealFields(entity, fields = FormulaEngine.extractVariables((String)(expression = keys[1])));
            String realFieldSelects = StringUtils.isEmpty((CharSequence)realFields) ? "" : "," + realFields;
            String billSelects = StringUtils.isBlank((CharSequence)entrySign) ? "id,0 as entryid,'" + key + "' as groupno" + realFieldSelects : "id," + entrySign + ".id as entryid,'" + key + "' as groupno" + realFieldSelects;
            QFilter billFilter = new QFilter("id", "in", billIds);
            if (!StringUtils.isBlank((CharSequence)entrySign)) {
                billFilter.and(entrySign + ".id", "in", entryids);
            }
            DataSet billDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)billSelects, (QFilter[])billFilter.toArray(), null);
            billDS = this.resolveBillDS(billDS, fields, expression);
            if (bill == null) {
                bill = billDS;
                continue;
            }
            bills.add(billDS);
        }
        if (bill == null) {
            return null;
        }
        if (!bills.isEmpty()) {
            bill = bill.union(bills.toArray(new DataSet[0]));
        }
        return bill;
    }

    private DataSet resolveBillDS(DataSet billDS, String[] fields, String expression) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("entryid", (DataType)DataType.LongType), new Field("groupno", (DataType)DataType.StringType), new Field("qty", (DataType)DataType.BigDecimalType)});
        DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        for (Row row : billDS) {
            params.clear();
            for (String field : fields) {
                params.put(field, row.get(field));
            }
            BigDecimal qty = (BigDecimal)FormulaEngine.execExcelFormula((String)expression, params);
            builder.append(new Object[]{row.getLong("id"), row.getLong("entryid"), row.getString("groupno"), qty});
        }
        return builder.build();
    }

    private String getRealFields(String entity, String[] fields) {
        HashSet<String> results = new HashSet<String>(16);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        for (String field : fields) {
            IDataEntityProperty dataEntity = entityType.findProperty(field);
            if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
                results.add(dataEntity.getParent().getName() + "." + field + " as " + field);
                continue;
            }
            results.add(field);
        }
        return String.join((CharSequence)",", results);
    }

    private String buildSnapShotKey(String snapFieldKey, Long billid, String entity, Long entryid, String entrysign) {
        return entity + "#" + billid + "#" + entrysign + "#" + entryid + "#" + snapFieldKey;
    }

    public Map<String, Set<Long>> getSnapShootIdMap() {
        return this.snapShootIdMap;
    }

    public Set<DynamicObject> getSnapShoots() {
        return this.snapShoots;
    }
}

