/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.feeshare;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.FeeShareHandleGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.feeshare.impl.AbstractTemplateFeeShareStrategy;
import kd.mpscmm.mscommon.feeshare.business.engine.core.feeshare.impl.StandardFeeShareStrategy;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.FsPluginExtFactory;
import kd.sdk.mpscmm.mscommon.feeshare.extpoint.IFeeShareStrategyPlugin;

public class FeeShareStrategyExecutor {
    private static final Log logger = LogFactory.getLog(FeeShareStrategyExecutor.class);
    private final ShareRuleConfig shareRuleConfig;
    private final FeeShareExecuteContext executeContext;
    private final FeeShareTypeContext writeOffTypeContext;

    public FeeShareStrategyExecutor(FeeShareTypeContext writeOffTypeContext, ShareRuleConfig shareRuleConfig) {
        this.writeOffTypeContext = writeOffTypeContext;
        this.executeContext = writeOffTypeContext.getExecuteContext();
        this.shareRuleConfig = shareRuleConfig;
    }

    public void feeShare(List<FeeShareHandleGroup> queueGroups) {
        FeeShareTypeConfig typeConfig = this.writeOffTypeContext.getTypeConfig();
        List<IFeeShareStrategyPlugin> plugins = FsPluginExtFactory.execute(typeConfig);
        if (plugins != null && !plugins.isEmpty()) {
            IFeeShareStrategyPlugin writeOffStrategy = plugins.get(plugins.size() - 1);
            this.doBatcFeeShare(writeOffStrategy, queueGroups);
        } else {
            this.doBatcFeeShare(new StandardFeeShareStrategy(), queueGroups);
        }
    }

    private void doBatcFeeShare(IFeeShareStrategyPlugin feeShareStrategy, List<FeeShareHandleGroup> queueGroups) {
        FeeShareTypeConfig typeConfig = this.writeOffTypeContext.getTypeConfig();
        if (feeShareStrategy instanceof AbstractTemplateFeeShareStrategy) {
            AbstractTemplateFeeShareStrategy strategy = (AbstractTemplateFeeShareStrategy)feeShareStrategy;
            strategy.setExecuteContext(this.executeContext);
            strategy.setSnapShootHolder(this.writeOffTypeContext);
            strategy.setTypeConfig(typeConfig);
            strategy.setShareRuleConfig(this.shareRuleConfig);
        }
        long startTime = System.currentTimeMillis();
        logger.info(String.format("\u6838\u9500\u7c7b\u522b\u3010%s\u3011\u6267\u884c\u6838\u9500\u7b56\u7565%s\u5f00\u59cb\u3002", typeConfig.getName(), feeShareStrategy.getClass().getSimpleName()));
        feeShareStrategy.batchExecute(queueGroups);
        long endTime = System.currentTimeMillis();
        logger.info(String.format("\u6838\u9500\u7c7b\u522b\u3010%s\u3011\u6267\u884c\u6838\u9500\u7b56\u7565%s\u7ed3\u675f\uff0c\u8017\u65f6%sms\u3002", typeConfig.getName(), feeShareStrategy.getClass().getSimpleName(), endTime - startTime));
    }
}

