/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.kdtx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.entity.BackFsParam;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.UnFsPluginExtFactory;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.common.helper.DynamicSerializeHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IKdtxUnWfPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class KdtxUnFeeShareService {
    private static final Log logger = LogFactory.getLog(KdtxUnFeeShareService.class);
    private static final String KDTX_RE_FEESHARE_SCENE_CODE = "msmod_backfeeshare";
    private static final String KDTX_RE_FEESHARE_PLUGIN_SUBSCENE_CODE = "msmod_backwf_plugin";
    private static final String KDTX_RE_FEESHARE_DEL_RECORD_SUBSCENE_CODE = "msmod_backwf_record_delete";
    private static final String KDTX_RE_FEESHARE_WRITEBACK_SUBSCENE_CODE = "msmod_backwf_writeback";
    private static final String KDTX_RE_FEESHARE_WRITEBACK_SERVICE = "ReFeeShareWriteBackService";
    private static final String KDTX_RE_FEESHARE_PLUGIN_SERVICE = "ReFeeSharePluginService";
    private static final String KDTX_RE_FEESHARE_DEL_RECORD_SERVICE = "ReFeeShareDelRecordService";
    private List<String> businessInfos;
    Map<Long, FeeShareTypeConfig> wfTypeMap = new HashMap<Long, FeeShareTypeConfig>(8);
    private boolean isChargeOff = false;
    private boolean isAysn = false;

    public KdtxUnFeeShareService(Set<String> businessInfos, Map<Long, FeeShareTypeConfig> wfTypeMap, boolean isChargeOff, boolean isAysn) {
        this.businessInfos = new ArrayList<String>(businessInfos);
        this.wfTypeMap = wfTypeMap;
        this.isChargeOff = isChargeOff;
        this.isAysn = isAysn;
    }

    public void kdtxBackWriteBill(Map<String, Map<String, List<Object[]>>> map, Map<Long, List<DynamicObject>> recordMap) {
        this.backBillDeal(map, recordMap);
    }

    private void backBillDeal(Map<String, Map<String, List<Object[]>>> map, Map<Long, List<DynamicObject>> recordMap) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        Map<String, String[]> recordSerMap = this.resolveRecordMap(recordMap);
        for (Map.Entry<String, Map<String, List<Object[]>>> sqlBuilderEntry : map.entrySet()) {
            BackFsParam commonParam = new BackFsParam();
            String dbRout = sqlBuilderEntry.getKey();
            commonParam.setDbRout(dbRout);
            Map<String, List<Object[]>> value = sqlBuilderEntry.getValue();
            commonParam.setParam(value);
            commonParam.setRecordMap(recordSerMap);
            commonParam.setChargeOff(this.isChargeOff);
            try {
                logger.info("\u6267\u884c\u64cd\u4f5cbackBillDeal");
                ECServiceHelper.execute((String)KDTX_RE_FEESHARE_SCENE_CODE, (String)KDTX_RE_FEESHARE_WRITEBACK_SUBSCENE_CODE, (String)"mpscmm", (String)"mscommon", (String)dbRout, (String)KDTX_RE_FEESHARE_WRITEBACK_SERVICE, this.businessInfos, (Param)commonParam, (String)this.businessInfos.get(0), (boolean)this.isAysn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }

    public void kdtxUnWfPlugin(Map<Long, List<DynamicObject>> recordMap) {
        UnFsPluginExtFactory unWfPluginExtFactory = new UnFsPluginExtFactory();
        for (Map.Entry<Long, List<DynamicObject>> record : recordMap.entrySet()) {
            Long wfTypeId = record.getKey();
            List<DynamicObject> recordList = record.getValue();
            List<IKdtxUnWfPlugin> iKdtxUnWfPluginPlugins = unWfPluginExtFactory.kdtxBackWfPlugin(wfTypeId);
            for (IKdtxUnWfPlugin plugin : iKdtxUnWfPluginPlugins) {
                BackFsParam commonParam = new BackFsParam();
                List ids = recordList.stream().map(n -> n.getPkValue()).collect(Collectors.toList());
                commonParam.setBillNumber(recordList.get(0).getDataEntityType().getName());
                commonParam.setValue(plugin.getClass().getName());
                commonParam.setTypeId(wfTypeId);
                commonParam.setRecordIds(ids);
                try {
                    ECServiceHelper.execute((String)KDTX_RE_FEESHARE_SCENE_CODE, (String)KDTX_RE_FEESHARE_PLUGIN_SUBSCENE_CODE, (String)"mpscmm", (String)"mscommon", (String)"scm", (String)KDTX_RE_FEESHARE_PLUGIN_SERVICE, this.businessInfos, (Param)commonParam, (String)this.businessInfos.get(0), (boolean)this.isAysn);
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u6027\u5931\u8d25\u3002", (Throwable)e);
                    throw new KDBizException(EngineLang.kdtxCallFail(e));
                }
            }
        }
    }

    private Map<String, String[]> resolveRecordMap(Map<Long, List<DynamicObject>> recordMap) {
        HashMap<String, String[]> recordSerMap = new HashMap<String, String[]>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : recordMap.entrySet()) {
            Long wfTypeId = entry.getKey();
            List<DynamicObject> recordList = entry.getValue();
            if (recordList.isEmpty()) continue;
            DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
            String[] serializes = DynamicSerializeHelper.serializeTwo((DynamicObject[])records);
            String key = wfTypeId + "#" + records[0].getDataEntityType().getName();
            recordSerMap.put(key, serializes);
        }
        return recordSerMap;
    }

    public void kdtxDeleteWriteOffRecord(Map<Long, List<DynamicObject>> recordMap) {
        this.wfRecordDeal(recordMap, null);
    }

    public void kdtxCaWriteOffRecord(Map<Long, List<DynamicObject>> recordMap, Map<String, Object> paramMap) {
        this.wfRecordDeal(recordMap, paramMap);
    }

    private void wfRecordDeal(Map<Long, List<DynamicObject>> recordMap, Map<String, Object> paramMap) {
        for (Map.Entry<Long, List<DynamicObject>> record : recordMap.entrySet()) {
            Long wfTypeId = record.getKey();
            DynamicObject wfType = BusinessDataServiceHelper.loadSingleFromCache((Object)wfTypeId, (String)"msmod_writeofftype", (String)"writeoffrecordbill");
            BackFsParam commonParam = new BackFsParam();
            String wfRecordNum = wfType.getDynamicObject("writeoffrecordbill").getString("number");
            commonParam.setBillNumber(wfRecordNum);
            List<DynamicObject> recordList = record.getValue();
            if (CollectionUtils.isEmpty(recordList)) continue;
            List ids = recordList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            String dbRouteKey = recordList.get(0).getDataEntityType().getDBRouteKey();
            commonParam.setTypeId(wfTypeId);
            commonParam.setRecordIds(ids);
            if (this.isChargeOff) {
                commonParam.setChargeOff(true);
                commonParam.setParamMap(paramMap);
            }
            try {
                ECServiceHelper.execute((String)KDTX_RE_FEESHARE_SCENE_CODE, (String)KDTX_RE_FEESHARE_DEL_RECORD_SUBSCENE_CODE, (String)"mpscmm", (String)"mscommon", (String)dbRouteKey, (String)KDTX_RE_FEESHARE_DEL_RECORD_SERVICE, this.businessInfos, (Param)commonParam, (String)this.businessInfos.get(0), (boolean)this.isAysn);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u6700\u7ec8\u4e00\u81f4\u5931\u8d25", (Throwable)e);
                throw new KDBizException(EngineLang.kdtxCallFail(e));
            }
        }
    }
}

