/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareColumnConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsFieldInfo;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.NumeratorConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareTypeContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.HintDataMatcher;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.entity.HintData;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.proxy.MatchPluginProxy;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.AbstractWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFConditionFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFMatchFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.lang.NounLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class FeeShareBillMatcher {
    protected static final Log logger = LogFactory.getLog(FeeShareBillMatcher.class);
    protected static final String ID = "id";
    protected static final String WF_MAINFIELD_ID = "wfCalcFieldId";
    private FsMatchRelationConfig relationConfig;
    private FeeShareTypeConfig writeOffTypeConfig;
    private FeeShareMatchGroup writeOffMatchGroup;
    private FeeShareExecuteContext executeContext;
    private FeeShareTypeContext writeOffTypeContext;
    private List<IWFFilter> additionQFilter = new ArrayList<IWFFilter>(16);
    private Map<Object, BigDecimal> curMainFieldValueMap = null;
    private final FeeShareBillConfig writeOffBillConfig;
    private String billTypeEntity = null;
    private String mainField;
    private boolean isBillField = true;
    private String wfCalcFieldIdName;
    private IWriteOffMainFieldCalPlugin mainFieldCalClass;
    private NumeratorConfig numeratorConfig = null;
    protected List<WriteOffMatchConditionInfo> writeOffMatchConditionInfos = new ArrayList<WriteOffMatchConditionInfo>(16);
    private QFilter matchConditionQFilter;

    public static FeeShareBillMatcher create(FeeShareMatchGroup writeOffMatchGroup, FsMatchRelationConfig relationConfig, FeeShareExecuteContext executeContext, FeeShareTypeContext writeOffTypeContext) {
        String targetBillTypeKey;
        FeeShareTypeConfig writeOffTypeConfig = writeOffMatchGroup.getTypeConfig();
        FeeShareBillConfig targetBillConfig = writeOffTypeConfig.getBillConf(targetBillTypeKey = relationConfig.getTargetBillTypeKey());
        if (targetBillConfig == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5339\u914d\u65b9\u5355\u636e\u914d\u7f6e\u3002", (String)"WriteOffBillMatcher_0", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]));
        }
        return new FeeShareBillMatcher(writeOffTypeConfig, targetBillConfig, relationConfig, writeOffMatchGroup, executeContext, writeOffTypeContext, false);
    }

    protected FeeShareBillMatcher(FeeShareTypeConfig writeOffTypeConfig, FeeShareBillConfig writeOffBillConfig, FsMatchRelationConfig relationConfig, FeeShareMatchGroup writeOffMatchGroup, FeeShareExecuteContext executeContext, FeeShareTypeContext writeOffTypeContext, boolean isSelf) {
        this.relationConfig = relationConfig;
        this.writeOffTypeConfig = writeOffMatchGroup.getTypeConfig();
        this.writeOffMatchGroup = writeOffMatchGroup;
        this.executeContext = executeContext;
        this.writeOffTypeContext = writeOffTypeContext;
        this.writeOffBillConfig = writeOffBillConfig;
        this.initMatchInfo();
    }

    private void initMatchInfo() {
        this.billTypeEntity = this.relationConfig.getTargetBillType();
        ShareRuleBillConfig shareRuleBillConfig = this.writeOffMatchGroup.getShareRuleBillConfig();
        FeeShareColumnConfig writeOffColumnConfig = this.writeOffBillConfig.getWriteOffColumnConfig();
        if (writeOffColumnConfig == null && shareRuleBillConfig != null) {
            this.numeratorConfig = shareRuleBillConfig.getNumerator();
            FsFieldInfo numerator = this.numeratorConfig.getWfFieldInfo();
            this.isBillField = numerator.isWfBillField();
            this.mainField = numerator.getWriteOffFieldKey();
            this.wfCalcFieldIdName = numerator.getWfCalcFieldIdName();
            this.mainFieldCalClass = numerator.getMainFieldCalClass();
        } else if (writeOffColumnConfig != null) {
            this.isBillField = writeOffColumnConfig.isWfBillField();
            this.mainField = writeOffColumnConfig.getWriteOffFieldKey();
            this.wfCalcFieldIdName = this.writeOffBillConfig.getWfCalcFieldIdName();
            this.mainFieldCalClass = writeOffColumnConfig.mainFieldCalClass();
        } else {
            throw new KDBizException(EngineLang.NotCongfigMainField(this.writeOffBillConfig));
        }
    }

    public List<FeeShareObject> executeMatch() {
        List<DynamicObject> matchEntryDatas = this.getMatchResult();
        if (matchEntryDatas.isEmpty()) {
            return Collections.emptyList();
        }
        return this.handleMatchResult(matchEntryDatas);
    }

    public List<DynamicObject> getMatchResult() {
        Object matchedBillData;
        String targetAlias;
        Long matchId;
        HintDataMatcher hintDataLoader = null;
        hintDataLoader = this.writeOffTypeContext != null ? this.writeOffTypeContext.getHintDataLoader() : new HintDataMatcher();
        HintData hintData = hintDataLoader.getHintData(matchId = this.relationConfig.getMatchId(), targetAlias = this.writeOffBillConfig.getBillAlias());
        if (hintData != null) {
            if (hintData.isNoMatchData()) {
                logger.info("\u6838\u9500\u5e73\u53f0\u67e5\u8be2Hint\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\u3002");
                this.writeOffMatchConditionInfos.addAll(hintData.getConditionInfos());
                return Collections.emptyList();
            }
            String expressionStr = this.buildMatchExpression();
            Set<Long> linkInfo = hintData.getLinkInfo(this.writeOffMatchGroup.getFeeShareObjects());
            if (linkInfo != null) {
                if (linkInfo.isEmpty()) {
                    logger.info("\u6838\u9500\u5e73\u53f0\u67e5\u8be2BotpLink\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\u3002");
                    this.writeOffMatchConditionInfos.add(new WriteOffMatchConditionInfo(NounLang.botpLink(), "=", EngineLang.noBotpLink()));
                    return Collections.emptyList();
                }
                String botpLinkExpr = new WFMatchFilter(this.wfCalcFieldIdName, "in", linkInfo).toExpression();
                expressionStr = StringUtils.isNotEmpty((CharSequence)expressionStr) ? expressionStr + " and " + botpLinkExpr : botpLinkExpr;
                this.writeOffMatchConditionInfos.add(new WriteOffMatchConditionInfo(NounLang.botpLink(), "=", botpLinkExpr));
                matchedBillData = hintData.getMatchedBillByBotpLink(this.wfCalcFieldIdName, expressionStr, linkInfo);
            } else {
                matchedBillData = hintData.getMatchedBillByHintKey(this.wfCalcFieldIdName, expressionStr, this.writeOffMatchGroup.getFeeShareObjects());
            }
            if (CollectionUtils.isEmpty((Collection)matchedBillData)) {
                logger.info("\u6838\u9500\u5e73\u53f0Hint\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\uff1a" + this.billTypeEntity + ":" + expressionStr);
                return Collections.emptyList();
            }
            if (this.numeratorConfig == null && !hintData.isAlreadyGetIds()) {
                this.writeOffTypeContext.loadSnapShootMap(hintData.getHintDataIds(), this.billTypeEntity);
            }
        } else {
            QFilter queryFilter = this.buildMatchQFilter();
            matchedBillData = this.executeContext.getBillDataSource().queryBillData(this.billTypeEntity, this.mainFieldCalClass.mainFieldEntry(), queryFilter);
            if (CollectionUtils.isEmpty((Collection)matchedBillData)) {
                logger.info("\u6838\u9500\u5e73\u53f0\u67e5\u8be2\u5339\u914d\u5355\u636e\u7ed3\u679c\u4e3a\u7a7a\uff1a" + this.billTypeEntity + ":" + queryFilter.toString());
                return Collections.emptyList();
            }
            List<Object> idList = this.getMatchBillIds((List<DynamicObject>)matchedBillData);
            if (this.numeratorConfig == null) {
                this.writeOffTypeContext.loadSnapShootMap(idList, this.billTypeEntity);
            }
        }
        return matchedBillData;
    }

    private List<Object> getMatchBillIds(List<DynamicObject> matchedBillData) {
        List<Object> idList = matchedBillData.stream().map(n -> n.get(ID)).collect(Collectors.toList());
        if (idList.size() > this.getMaxHandleSize()) {
            throw new KDBizException(EngineLang.overMaxHandleBillSize(this.getMaxHandleSize()));
        }
        return idList;
    }

    private String buildMatchExpression() {
        List<IWFFilter> filters = this.buildMatchWFFilter(true);
        return IWFFilter.toSingleExpression(filters);
    }

    private QFilter buildMatchQFilter() {
        List<IWFFilter> filters = this.buildMatchWFFilter(false);
        return IWFFilter.toSingleQFilter(filters);
    }

    private List<IWFFilter> buildMatchWFFilter(boolean isHint) {
        List<IWFFilter> wfExtQfilter;
        ArrayList<IWFFilter> filters = new ArrayList<IWFFilter>();
        List<IWFFilter> matchRuleFilter = this.relationConfig.buildMatchRuleFilter(this.writeOffMatchGroup, this.wfCalcFieldIdName, !isHint);
        filters.addAll(matchRuleFilter);
        if (this.isBillField) {
            WFMatchFilter qtyFilter = new WFMatchFilter(this.mainField, "!=", (Object)BigDecimal.ZERO);
            qtyFilter.setInfo(new WriteOffMatchConditionInfo(NounLang.mainField((String)this.mainField), "!=", String.valueOf(BigDecimal.ZERO)));
            filters.add((IWFFilter)qtyFilter);
        }
        if ((wfExtQfilter = this.wfExtQfilter(this.billTypeEntity, this.wfCalcFieldIdName)) != null) {
            filters.addAll(wfExtQfilter);
        }
        if (this.numeratorConfig != null) {
            filters.addAll(this.numeratorConfig.getWfConditionFilters());
        }
        if (!isHint) {
            if (!this.additionQFilter.isEmpty()) {
                filters.addAll(this.additionQFilter);
            }
            List<WFConditionFilter> wfConditionFilters = this.writeOffBillConfig.getWfConditionFilters();
            filters.addAll(wfConditionFilters);
        }
        for (IWFFilter filter : filters) {
            AbstractWFFilter wfFilter;
            WriteOffMatchConditionInfo info;
            if (!(filter instanceof AbstractWFFilter) || (info = (wfFilter = (AbstractWFFilter)filter).getInfo()) == null) continue;
            this.writeOffMatchConditionInfos.add(info);
        }
        return filters;
    }

    protected List<IWFFilter> wfExtQfilter(String billTypeEntity, String wfCalcFieldIdName) {
        List<Object> fieldValue = this.writeOffMatchGroup.getMatchKeys();
        List<IWFFilter> wfExtQfilter = this.getMatchPluginProxy().getMatchFilters(fieldValue.get(fieldValue.size() - 1), billTypeEntity, wfCalcFieldIdName);
        if (wfExtQfilter != null && !wfExtQfilter.isEmpty()) {
            return wfExtQfilter;
        }
        return null;
    }

    private MatchPluginProxy getMatchPluginProxy() {
        return this.executeContext.getPluginFactory().createMatchPluginProxy(this.writeOffTypeConfig, this.relationConfig.getMatchRuleConfig());
    }

    private List<FeeShareObject> handleMatchResult(List<DynamicObject> matchEntryDatas) {
        ArrayList<FeeShareObject> targetBillList = new ArrayList<FeeShareObject>(12);
        for (DynamicObject entryDynamicObject : matchEntryDatas) {
            Object entryPk = entryDynamicObject.get(this.wfCalcFieldIdName);
            FeeShareObject writeOffObject = null;
            if (this.numeratorConfig != null) {
                writeOffObject = FeeShareObject.createShareAssist(this.writeOffTypeConfig, this.writeOffBillConfig, entryDynamicObject, this.numeratorConfig);
            } else {
                writeOffObject = FeeShareObject.create(this.writeOffTypeConfig, this.writeOffBillConfig, entryDynamicObject);
                BigDecimal snapShotQty = this.writeOffTypeContext.getFeeShareQty(writeOffObject);
                writeOffObject.setFeeShareNumber(writeOffObject.getFeeShareNumber().subtract(snapShotQty));
            }
            if (this.curMainFieldValueMap != null) {
                BigDecimal curWFDecimal = this.curMainFieldValueMap.get(entryPk);
                writeOffObject.setFeeShareNumber(curWFDecimal);
            }
            if (writeOffObject.isCurWriteOffZero() || writeOffObject.isWfNumZero() || !this.writeOffBillConfig.checkHighCondtion(writeOffObject.getFeeShareObjectBase())) continue;
            targetBillList.add(writeOffObject);
        }
        return targetBillList;
    }

    private Integer getMaxHandleSize() {
        Integer maxHandleBillSize = this.executeContext.getWfParam().getMaxHandleBillSize();
        if (maxHandleBillSize != null) {
            return maxHandleBillSize;
        }
        return 5000;
    }

    public void addFilter(IWFFilter additionQFilter) {
        this.additionQFilter.add(additionQFilter);
    }

    public void addFilters(List<IWFFilter> additionQFilters) {
        this.additionQFilter.addAll(additionQFilters);
    }

    public void setCurMainFieldValueMap(Map<Object, BigDecimal> curMainFieldValueMap) {
        this.curMainFieldValueMap = curMainFieldValueMap;
    }

    public QFilter getMatchConditionQFilter() {
        return this.matchConditionQFilter;
    }

    public List<WriteOffMatchConditionInfo> getWriteOffMatchConditionInfos() {
        return this.writeOffMatchConditionInfos;
    }
}

