/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.record.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.UDFunction;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.feeshare.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsRecordColumnConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsRecordMappingConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.entity.BackFeeShareDetail;
import kd.mpscmm.mscommon.feeshare.business.engine.core.record.FeeShareRecordMapper;
import kd.mpscmm.mscommon.feeshare.common.helper.ConditionHelper;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.proxy.FeeSharePluginProxy;
import kd.mpscmm.mscommon.feeshare.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteSeqHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;

public abstract class AbstractFeeShareRecordStrategy {
    private static final String CUR_DATA = "curdata";
    private FeeShareTypeConfig typeConfig;
    private FeeShareExecuteContext executeContext;
    private FsSchemeConfig SchemeConfig;
    private ShareRuleBillConfig shareRuleBillConfig;

    public FeeShareRecordMapper generate(List<List<FeeShareObjectBase>> writeOffQueues, String writeDetail) {
        String recordBillType = this.typeConfig.getRecordNum();
        String recordEntryType = this.typeConfig.getRecordEntryType();
        DynamicObject recordBill = BusinessDataServiceHelper.newDynamicObject((String)recordBillType);
        FeeShareRecordMapper recordMapping = this.generateRecordEntries(recordEntryType, recordBill, writeOffQueues);
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST != this.typeConfig.getWfRecordTemplateEnum()) {
            this.setBillHeadColumns(recordBill);
        }
        DynamicObjectUtil.setBillId((DynamicObject)recordBill, (String)"entry");
        if (StringUtils.isEmpty((String)writeDetail)) {
            writeDetail = JSONObject.toJSONString((Object)new BackFeeShareDetail());
        }
        recordBill.set("headwfinfo_tag", (Object)writeDetail);
        String seq = this.buidSeq(recordBillType, recordBill, this.typeConfig.getWfRecordTemplateEnum());
        recordBill.set("wfnumber", (Object)seq);
        recordMapping.setRecordBill(recordBill);
        FeeSharePluginProxy iWriteOffPluginProxy = this.getExecuteContext().getPluginFactory().createWriteOffPluginProxy(this.typeConfig);
        iWriteOffPluginProxy.beforeWfRecordGenerate(recordMapping);
        return recordMapping;
    }

    private String buidSeq(String recordBillType, DynamicObject recordBill, WriteoffTemplateTypeEnum templateTypeEnum) {
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == templateTypeEnum) {
            return String.valueOf(recordBill.getPkValue());
        }
        String seq = WriteSeqHelper.getSeq((String)recordBillType);
        if (StringUtils.isEmpty((String)seq)) {
            seq = String.valueOf(recordBill.getPkValue());
        }
        return seq;
    }

    abstract FeeShareRecordMapper generateRecordEntries(String var1, DynamicObject var2, List<List<FeeShareObjectBase>> var3);

    protected final void initWriteOffObject(FeeShareObjectBase wfobj, DynamicObject recordObj, String billIdField, String wfObjectIdField, String billEntityField, String billNoField) {
        Object billPkValue = wfobj.getWfBillPk();
        recordObj.set(billIdField, billPkValue);
        Object entryPkValue = wfobj.getPkValue();
        recordObj.set(wfObjectIdField, entryPkValue);
        DynamicObject bosEntity = wfobj.getWFBillEntityObj();
        recordObj.set(billEntityField, (Object)bosEntity);
        String billNo = wfobj.getWfBillBillNo();
        recordObj.set(billNoField, (Object)billNo);
    }

    protected void setEntryColumns(FeeShareObjectBase writeOffObject, DynamicObject entry) {
        if (writeOffObject == null) {
            return;
        }
        FeeShareBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
        List<FsRecordColumnConfig> recordColumnConfigs = this.getBillWfMapping(writeOffBillConfig).getRecordEntryColumnConfigs();
        this.setEntryColumn(writeOffObject, entry, recordColumnConfigs);
    }

    protected void setBillHeadMappingColumns(FeeShareObjectBase writeOffObject, DynamicObject recordBill) {
        if (writeOffObject != null) {
            FeeShareBillConfig writeOffBillConfig = this.getBillConfig(writeOffObject);
            List<FsRecordColumnConfig> recordHeadColumnConfigs = this.getBillWfMapping(writeOffBillConfig).getRecordHeadColumnConfigs();
            for (FsRecordColumnConfig columnConfig : recordHeadColumnConfigs) {
                String targetColumn = columnConfig.getTargetColumn();
                String sourceColumn = columnConfig.getSourceColumn();
                if ("1".equals(columnConfig.getSelectValue())) {
                    this.setByExpression(writeOffObject, recordBill, targetColumn, columnConfig);
                    continue;
                }
                BillFieldInfoManager billFieldInfo = this.getExecuteContext().getBillFieldInfo();
                Object value = billFieldInfo.getObjWithTransDO(writeOffObject, sourceColumn);
                recordBill.set(targetColumn, value);
            }
        }
    }

    protected final void setEntryColumn(FeeShareObjectBase writeOffObject, DynamicObject recordEntry, List<FsRecordColumnConfig> recordColumnConfigs) {
        for (FsRecordColumnConfig recordColumnConfig : recordColumnConfigs) {
            String targetColumn = recordColumnConfig.getTargetColumn().split("\\.")[1];
            String sourceColumn = recordColumnConfig.getSourceColumn();
            if ("1".equals(recordColumnConfig.getSelectValue())) {
                this.setByExpression(writeOffObject, recordEntry, targetColumn, recordColumnConfig);
                continue;
            }
            BillFieldInfoManager billFieldInfo = this.getExecuteContext().getBillFieldInfo();
            Object value = billFieldInfo.getObjWithTransDO(writeOffObject, sourceColumn);
            recordEntry.set(targetColumn, value);
        }
    }

    protected void setByExpression(FeeShareObjectBase writeOffObject, DynamicObject entry, String targetColumn, FsRecordColumnConfig recordColumnConfig) {
        AmountProp amountProp;
        String controlPropName;
        DynamicObject amount;
        String expression = recordColumnConfig.getExpression();
        String[] columns = FormulaEngine.extractVariables((String)expression);
        BOSExpression function = recordColumnConfig.getFunction();
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        HashMap<String, BigDecimal> writeOffValues = new HashMap<String, BigDecimal>(writeOffObject.getWriteOffValues());
        writeOffValues.put(writeOffObject.getPrimaryColumn(), writeOffObject.getWriteOffNumber());
        MainEntityType mainEntityType = writeOffObject.getWFBillEntityType();
        BigDecimal writeOffNumber = writeOffObject.getWriteOffNumber();
        args.put(CUR_DATA, writeOffNumber);
        for (String column : columns) {
            BigDecimal bigDecimal;
            if (CUR_DATA.equals(column)) continue;
            Object result = writeOffObject.getValue(column);
            IDataEntityProperty property = mainEntityType.findProperty(column);
            String columnName = "";
            if (property != null && property.getParent() != null) {
                IDataEntityType parent = property.getParent();
                columnName = parent.getName() + "." + column;
            }
            if ((bigDecimal = (BigDecimal)writeOffValues.get(columnName)) != null) {
                result = bigDecimal;
            }
            args.put(column, result);
        }
        BOSExpressionContext expContext = new BOSExpressionContext(null);
        BOSUDFunction[] udFunctions = ConditionHelper.createUdFunctions(function, (ExpressionContext)expContext);
        Object result = FormulaEngine.execExcelFormula((String)expression, args, (UDFunction[])udFunctions);
        if (!(result instanceof BigDecimal)) {
            entry.set(targetColumn, result);
            return;
        }
        BigDecimal resultBig = (BigDecimal)result;
        Integer precision = 10;
        Integer preciSionAccount = 1;
        RowDataModel rowDataModel = CommonUtils.getBillEntry((DynamicObject)entry);
        IDataEntityProperty property = recordColumnConfig.getTgtProp();
        if (property instanceof QtyProp) {
            QtyProp qtyProp = (QtyProp)property;
            String relatedUnit = qtyProp.getControlPropName();
            DynamicObject unit = (DynamicObject)rowDataModel.getValue(relatedUnit);
            if (unit != null) {
                precision = unit.getInt("precision");
                preciSionAccount = unit.getInt("precisionaccount");
            }
        } else if (property instanceof AmountProp && (amount = (DynamicObject)rowDataModel.getValue(controlPropName = (amountProp = (AmountProp)property).getControlPropName())) != null) {
            precision = amount.getInt("amtprecision");
        }
        BigDecimal newAssistValue = BigDecimal.ZERO;
        newAssistValue = preciSionAccount == 1 ? resultBig.setScale((int)precision, RoundingMode.HALF_UP) : (preciSionAccount == 2 ? resultBig.setScale((int)precision, RoundingMode.DOWN) : (preciSionAccount == 3 ? resultBig.setScale((int)precision, RoundingMode.UP) : resultBig.setScale((int)precision, RoundingMode.UP)));
        entry.set(targetColumn, (Object)newAssistValue);
    }

    private void setBillHeadColumns(DynamicObject recordBill) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        recordBill.set("wfseq", (Object)this.executeContext.getSeq());
        recordBill.set("createtime", (Object)this.executeContext.getFeeShareDate());
        recordBill.set("createdate", (Object)new Date());
        recordBill.set("creator", (Object)currentUserId);
        recordBill.set("writeofftypeid", (Object)this.typeConfig.getObj());
        recordBill.set("wfscheme", this.SchemeConfig.getObjId());
        recordBill.set("billstatus", (Object)"C");
    }

    protected final FsRecordMappingConfig getBillWfMapping(FeeShareBillConfig writeOffBillConfig) {
        FsRecordMappingConfig configById = this.executeContext.getConfigManager().getMappingConfigById(writeOffBillConfig.getWfMappingId());
        if (configById == null) {
            throw new KDBizException(EngineLang.wfMappingFail(writeOffBillConfig.getWfMappingNumber()));
        }
        return configById;
    }

    protected final FeeShareBillConfig getBillConfig(FeeShareObjectBase writeOffObject) {
        return this.getTypeConfig().getBillConfigsById((Long)writeOffObject.getWfBillEntity().getPkValue());
    }

    protected final FeeShareExecuteContext getExecuteContext() {
        return this.executeContext;
    }

    public void setExecuteContext(FeeShareExecuteContext executeContext) {
        this.executeContext = executeContext;
    }

    protected final FeeShareTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    protected final FsSchemeConfig getSchemeContextConfig() {
        return this.SchemeConfig;
    }

    public void setTypeConfig(FeeShareTypeConfig typeConfig) {
        this.typeConfig = typeConfig;
    }

    public void setSchemeContextConfig(FsSchemeConfig schemeContextConfig) {
        this.SchemeConfig = schemeContextConfig;
    }

    protected final ShareRuleBillConfig getShareRuleBillConfig() {
        return this.shareRuleBillConfig;
    }

    public void setShareRuleBillConfig(ShareRuleBillConfig shareRuleBillConfig) {
        this.shareRuleBillConfig = shareRuleBillConfig;
    }
}

