/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;

public class FeeShareLogInfo {
    private final DynamicObject wfLogObj;
    private String billEntity;
    private Set<String> billNos = new HashSet<String>(16);
    private Set<Object> billIds = new HashSet<Object>(16);
    private String op;
    private FeeShareTypeConfig typeConfig;

    private FeeShareLogInfo(DynamicObject wfLogObj) {
        this.wfLogObj = wfLogObj;
    }

    public static FeeShareLogInfo createLog(String wfSeq, FeeShareTypeConfig typeConfig) {
        DynamicObject newLogObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_wf_nlog");
        newLogObj.set("id", (Object)DB.genLongId((String)"t_msmod_wfnlog"));
        RequestContext requestContext = RequestContext.get();
        if (requestContext != null) {
            newLogObj.set("traceid", (Object)requestContext.getTraceId());
            newLogObj.set("creater", (Object)requestContext.getCurrUserId());
        }
        newLogObj.set("createdate", (Object)new Date());
        newLogObj.set("status", (Object)"S");
        newLogObj.set("wfseq", (Object)wfSeq);
        newLogObj.set("wftype", (Object)typeConfig.getObj());
        FeeShareLogInfo logInfo = new FeeShareLogInfo(newLogObj);
        logInfo.typeConfig = typeConfig;
        return logInfo;
    }

    public void addSrcBillInfo(String billEntity, String billNo, Object id) {
        this.billEntity = billEntity;
        this.billNos.add(billNo);
        this.billIds.add(id);
    }

    public void setMatchLogsInfo(FeeShareMatchGroup writeOffMatchGroup, List<FeeShareObject> matchedObjs, FsMatchRelationConfig relationConfig, List<WriteOffMatchConditionInfo> matchchCondition, QFilter matchQFilter, String matchstatus) {
        String targetBillType = relationConfig.getTargetBillType();
        this.setMatchLogsInfo(writeOffMatchGroup, matchedObjs, targetBillType, matchchCondition, matchstatus);
    }

    public void setMatchLogsInfo(FeeShareMatchGroup writeOffMatchGroup, List<FeeShareObject> matchedObjs, String targetBillType, List<WriteOffMatchConditionInfo> matchchCondition, String matchstatus) {
        DynamicObject wfSchemeObj = writeOffMatchGroup.getSchemeConfig().getObj();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)targetBillType);
        DynamicObjectCollection entries = this.wfLogObj.getDynamicObjectCollection("entryentity1");
        DynamicObject newEntry = entries.addNew();
        long entryId = DB.genLongId((String)"t_msmod_matchlogentry");
        newEntry.set("id", (Object)entryId);
        newEntry.set("scheme", (Object)wfSchemeObj.getString("name"));
        newEntry.set("targetbill", (Object)entityType.getDisplayName());
        newEntry.set("matchstatus", (Object)matchstatus);
        StringBuilder markDownStrBuilder = new StringBuilder();
        String markDownStr = this.buildMarkDownStr(matchchCondition, entityType.getDisplayName().toString());
        markDownStrBuilder.append(markDownStr);
        if (writeOffMatchGroup != null && writeOffMatchGroup.getFeeShareObjects() != null) {
            markDownStrBuilder.append("\n");
            markDownStrBuilder.append(String.format("Group Size:%s", writeOffMatchGroup.getFeeShareObjects().size()));
        }
        if (matchedObjs != null) {
            markDownStrBuilder.append("\n");
            markDownStrBuilder.append(String.format("Match Size:%s", matchedObjs.size()));
        }
        newEntry.set("matchcondition", (Object)"");
        newEntry.set("matchcondition_tag", (Object)markDownStrBuilder.toString());
    }

    public void setErrorMessage(Exception e) {
        this.getWfLogObj().set("executeinfo", (Object)CommonUtils.cutStr((String)e.getMessage(), (int)200));
    }

    public void setErrorType(String errorType) {
        this.getWfLogObj().set("errortype", (Object)errorType);
    }

    public String getErrorType() {
        return this.getWfLogObj().getString("errortype");
    }

    private String buildMarkDownStr(List<WriteOffMatchConditionInfo> matchchCondition, String targetBillName) {
        String targetBill = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\uff1a", (String)"WriteOffNLogInfo_targetBill", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]);
        String prop = ResManager.loadKDString((String)"\u5c5e\u6027", (String)"WriteOffNLogInfo_prop", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]);
        String comparison = ResManager.loadKDString((String)"\u6bd4\u8f83\u7b26", (String)"WriteOffNLogInfo_comparison", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]);
        String value = ResManager.loadKDString((String)"\u6bd4\u8f83\u503c", (String)"WriteOffNLogInfo_value", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]);
        String comparisonStr = ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"WriteOffNLogInfo_comparisonStr", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]);
        String uncomparisonStr = ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"WriteOffNLogInfo_uncomparisonStr", (String)"mpscmm-mscommon-feeshare", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("# **");
        sb.append(targetBill).append(targetBillName);
        sb.append("**").append("\n");
        sb.append(prop).append("|").append(comparison).append("|").append(value).append("\n");
        sb.append("----").append("|").append("----").append("|").append("----").append("\n");
        if (matchchCondition != null) {
            for (WriteOffMatchConditionInfo condition : matchchCondition) {
                sb.append(condition.getPropName()).append("|");
                String comparisonMark = condition.getComparison();
                if ("!=".equals(comparisonMark)) {
                    sb.append(uncomparisonStr).append("|");
                } else if ("=".equals(comparisonMark)) {
                    sb.append(comparisonStr).append("|");
                } else {
                    sb.append(comparisonMark).append("|");
                }
                sb.append(condition.getValue()).append("|").append("\n");
            }
        }
        return sb.toString();
    }

    public Long addTaskEntry(String taskName, String taskClass, String branchcode, String businessid, Object reqInfo) {
        DynamicObjectCollection entries = this.wfLogObj.getDynamicObjectCollection("entryentity");
        DynamicObject newEntry = entries.addNew();
        long entryId = DB.genLongId((String)"t_msmod_wfnlogentry");
        newEntry.set("id", (Object)entryId);
        newEntry.set("taskClass", (Object)taskClass);
        newEntry.set("branchcode", (Object)branchcode);
        newEntry.set("businessid", (Object)businessid);
        newEntry.set("taskname", (Object)taskName);
        newEntry.set("taskstatus", (Object)"A");
        if (reqInfo != null) {
            String reqInfoStr = String.valueOf(reqInfo);
            newEntry.set("reqinfo", (Object)CommonUtils.cutStr((String)reqInfoStr, (int)200));
            newEntry.set("reqinfo_tag", (Object)reqInfoStr);
        }
        return entryId;
    }

    public DynamicObject getWfLogObj() {
        return this.wfLogObj;
    }

    public DynamicObject preSave() {
        this.fillSrcBillNos();
        this.fillSrcBillIds();
        this.fillSrcBillEntity();
        return this.wfLogObj;
    }

    private void fillSrcBillNos() {
        StringBuilder strs = new StringBuilder();
        boolean isFrist = true;
        for (String billNo : this.billNos) {
            if (!isFrist) {
                strs.append(",");
            }
            strs.append(billNo);
            isFrist = false;
        }
        String billInfo = this.getWfLogObj().getString("srcbillno");
        if (StringUtils.isNotEmpty((CharSequence)billInfo)) {
            strs.append(",");
            strs.append(billInfo);
            billInfo = strs.toString();
        } else {
            billInfo = strs.toString();
        }
        this.getWfLogObj().set("srcbillno", (Object)CommonUtils.cutStr((String)billInfo, (int)50));
        this.getWfLogObj().set("srcbillno_tag", (Object)billInfo);
    }

    private void fillSrcBillIds() {
        StringBuilder strs = new StringBuilder();
        boolean isFrist = true;
        for (Object billId : this.billIds) {
            if (!isFrist) {
                strs.append(",");
            }
            strs.append(billId);
            isFrist = false;
        }
        String billInfo = this.getWfLogObj().getString("srcbillid_tag");
        if (StringUtils.isNotEmpty((CharSequence)billInfo)) {
            strs.append(",");
            strs.append(billInfo);
            billInfo = strs.toString();
        } else {
            billInfo = strs.toString();
        }
        this.getWfLogObj().set("srcbillid", (Object)CommonUtils.cutStr((String)billInfo, (int)25));
        this.getWfLogObj().set("srcbillid_tag", (Object)billInfo);
    }

    private void fillSrcBillEntity() {
        if (StringUtils.isNotEmpty((CharSequence)this.billEntity)) {
            DynamicObject billEntityObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_billmainentity");
            billEntityObj.set("id", (Object)this.billEntity);
            this.getWfLogObj().set("srcbillentity", (Object)billEntityObj);
        }
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public FeeShareTypeConfig getTypeConfig() {
        return this.typeConfig;
    }
}

