/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.business.engine.executor;

import java.util.ArrayList;
import java.util.List;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.FeeShareHandleGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.match.FeeShareBillMatcher;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareManualGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.business.engine.executor.AbstractFeeShareGroupExecutor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import org.apache.commons.collections.CollectionUtils;

public class ManualFeeShareGroupExecutor
extends AbstractFeeShareGroupExecutor {
    @Override
    public void doExecute(List<FeeShareMatchGroup> matchGroups) {
        FeeShareLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(this.getTypeConfig().getId());
        FeeShareMatchGroup wfMatchGroup = matchGroups.get(0);
        ArrayList<FeeShareHandleGroup> handleGroups = new ArrayList<FeeShareHandleGroup>(16);
        try (TraceSpan trace = Tracer.create((String)"WriteOff-Matcher", (String)"executeManualMatch");){
            for (FeeShareMatchGroup writeOffMatchGroup : matchGroups) {
                FeeShareHandleGroup queueGroup = new FeeShareHandleGroup(writeOffMatchGroup);
                List<FeeShareObject> writeOffObjects = writeOffMatchGroup.getFeeShareObjects();
                this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(writeOffObjects);
                if (CollectionUtils.isEmpty(writeOffObjects)) continue;
                List<FeeShareManualGroup> manualGroups = this.getExecuteContext().getWriteOffManualGroups();
                if (!this.createParticipantQueues(queueGroup, manualGroups)) {
                    this.setMatchObj(Boolean.FALSE);
                    continue;
                }
                handleGroups.add(queueGroup);
            }
        }
        if (!handleGroups.isEmpty()) {
            this.doFeeShare(handleGroups);
        }
    }

    private boolean createParticipantQueues(FeeShareHandleGroup dispatcher, List<FeeShareManualGroup> manualGroups) {
        FsSchemeConfig schemeConfig = dispatcher.getGroup().getSchemeConfig();
        if (!schemeConfig.isNoCondition()) {
            return this.createMatchQueue(dispatcher, manualGroups);
        }
        this.noConditionMatchQueue(dispatcher, manualGroups);
        return true;
    }

    protected void noConditionMatchQueue(FeeShareHandleGroup dispatcher, List<FeeShareManualGroup> manualGroups) {
        FeeShareMatchGroup writeOffMatchGroup = dispatcher.getGroup();
        ShareRuleBillConfig shareRuleBillConfig = writeOffMatchGroup.getShareRuleBillConfig();
        for (int i = 0; i < manualGroups.size(); ++i) {
            FeeShareManualGroup feeShareManualGroup = manualGroups.get(i);
            if (shareRuleBillConfig != null) {
                feeShareManualGroup.initFeeShareObject(shareRuleBillConfig);
            }
            List<FeeShareObject> feeShareObjects = feeShareManualGroup.getFeeShareObjects();
            dispatcher.setMatchedQueues(feeShareObjects);
        }
    }

    protected boolean createMatchQueue(FeeShareHandleGroup dispatcher, List<FeeShareManualGroup> manualGroups) {
        FeeShareMatchGroup writeOffMatchGroup = dispatcher.getGroup();
        FeeShareBillConfig billTypeConfig = writeOffMatchGroup.getBillTypeConfig();
        List<FsMatchRelationConfig> relationConfigs = this.getMatchRule(writeOffMatchGroup).getByPromoter(billTypeConfig.getBillAlias());
        FeeShareLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(writeOffMatchGroup.getTypeConfig().getId());
        for (int i = 0; i < relationConfigs.size(); ++i) {
            FsMatchRelationConfig matchRelationConfig = relationConfigs.get(i);
            String targetBillTypeKey = matchRelationConfig.getTargetBillTypeKey();
            FeeShareManualGroup group = manualGroups.stream().filter(n -> targetBillTypeKey.equals(n.getBillTypeConfig().getBillAlias())).findFirst().orElse(null);
            if (group == null) {
                return false;
            }
            FeeShareBillMatcher writeOffBillMatcher = FeeShareBillMatcher.create(writeOffMatchGroup, matchRelationConfig, this.getExecuteContext(), this.getHolder());
            writeOffBillMatcher.addFilters(group.getFilter());
            writeOffBillMatcher.setCurMainFieldValueMap(group.getCurMainFieldValueMap());
            List<FeeShareObject> matchObjects = writeOffBillMatcher.executeMatch();
            List<WriteOffMatchConditionInfo> matchchCondition = writeOffBillMatcher.getWriteOffMatchConditionInfos();
            if (CollectionUtils.isEmpty(matchObjects)) {
                logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, matchRelationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "B");
                return false;
            }
            this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(matchObjects);
            if (CollectionUtils.isEmpty(matchObjects)) {
                logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, matchRelationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "C");
                return false;
            }
            logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, matchRelationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "A");
            dispatcher.setMatchedQueues(matchObjects);
        }
        return true;
    }
}

