/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.AbstractFSCondtionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FlowFeeShareBillOperateConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsGroupKeyResponse;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsLargeTextValue;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRelationConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsSchemeConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.common.util.MatcherUtil;
import kd.mpscmm.mscommon.feeshare.ext.defaultplugin.PluginFactory;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.sdk.mpscmm.mscommon.feeshare.params.FeeShareObjectBase;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import org.apache.commons.collections.CollectionUtils;

public class FeeShareGroupHelper {
    public static List<FeeShareObject> getMatchedObjAndRemove(AbstractFSCondtionConfig billOperateConfig, Collection<FeeShareObject> objs) {
        ArrayList<FeeShareObject> matchedObjs = new ArrayList<FeeShareObject>(16);
        Iterator<FeeShareObject> iterator = objs.iterator();
        while (iterator.hasNext()) {
            FeeShareObject fsObject = iterator.next();
            if (!billOperateConfig.checkCondtion(fsObject.getFeeShareObjectBase()) || !billOperateConfig.checkHighCondtion(fsObject.getFeeShareObjectBase())) continue;
            matchedObjs.add(fsObject);
            iterator.remove();
        }
        return matchedObjs;
    }

    public static List<FeeShareMatchGroup> groupByMatchRule(FlowFeeShareBillOperateConfig schemeContextConfig, FeeShareTypeConfig typeConfig, FeeShareBillConfig billTypeConfig, FsSchemeConfig schemeConfig, FsMatchRuleConfig matchRuleConfig, List<FeeShareObject> writeOffObjects, PluginFactory pf) {
        List<FeeShareMatchGroup> groups = FeeShareGroupHelper.groupByMatchRule(typeConfig, billTypeConfig, schemeConfig, matchRuleConfig, writeOffObjects, pf);
        for (FeeShareMatchGroup matchGroup : groups) {
            matchGroup.setWfFlowConfig(schemeContextConfig);
        }
        return groups;
    }

    public static List<FeeShareMatchGroup> groupByMatchRule(FeeShareTypeConfig typeConfig, FeeShareBillConfig billTypeConfig, FsSchemeConfig schemeConfig, FsMatchRuleConfig matchRuleConfig, List<FeeShareObject> feeShareObjects, PluginFactory pf) {
        String alias = billTypeConfig.getBillAlias();
        if (matchRuleConfig == null) {
            FeeShareMatchGroup writeOffMatchGroup = FeeShareMatchGroup.build(typeConfig, billTypeConfig, schemeConfig, feeShareObjects);
            return Collections.singletonList(writeOffMatchGroup);
        }
        HashMap<String, FeeShareMatchGroup> writeOffMatchGroupMap = new HashMap<String, FeeShareMatchGroup>(16);
        FsMatchRelationConfig matchConditionConfig = matchRuleConfig.getFristByPromoter(alias);
        if (matchConditionConfig == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5339\u914d\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchRuleSaveValidatorDataRepeat_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        List<FsMatchConditionConfig> srcFieldList = matchConditionConfig.getMatchConditionConfigs();
        for (FeeShareObject writeOffObject : feeShareObjects) {
            ArrayList<Object> matchKeys;
            FsGroupKeyResponse groupKeyResponse = FeeShareGroupHelper.getGroupKey(writeOffObject, srcFieldList, matchKeys = new ArrayList<Object>(16), matchRuleConfig, pf);
            String groupKey = groupKeyResponse.getGroupKey();
            FeeShareMatchGroup writeOffMatchGroup = (FeeShareMatchGroup)writeOffMatchGroupMap.get(groupKey);
            if (writeOffMatchGroup == null) {
                writeOffMatchGroup = FeeShareMatchGroup.build(typeConfig, billTypeConfig, schemeConfig, new ArrayList<FeeShareObject>(0));
                writeOffMatchGroup.setMatchKeys(matchKeys);
                writeOffMatchGroup.setGroupKey(groupKey);
                writeOffMatchGroupMap.put(groupKey, writeOffMatchGroup);
            }
            writeOffMatchGroup.getFeeShareObjects().add(writeOffObject);
        }
        return new ArrayList<FeeShareMatchGroup>(writeOffMatchGroupMap.values());
    }

    private static FsGroupKeyResponse getGroupKey(FeeShareObject feeShareObject, List<FsMatchConditionConfig> srcFieldList, List<Object> params, FsMatchRuleConfig matchRuleConfig, PluginFactory pf) {
        StringBuilder builder = new StringBuilder();
        FsGroupKeyResponse response = new FsGroupKeyResponse();
        BillEntityType dataEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)feeShareObject.getBillEntityName());
        for (FsMatchConditionConfig fieldConfig : srcFieldList) {
            boolean isApField;
            Object fieldValue = FeeShareGroupHelper.getFieldValue(fieldConfig, feeShareObject.getFeeShareObjectBase());
            String field = fieldConfig.getSrcBillFieldKey();
            boolean bl = isApField = "ap_finapbill".equals(dataEntityType.getName()) && fieldValue != null && ("detailentry.e_sourcebillid".equals(field) || "detailentry.e_sourcebillentryid".equals(field));
            if (isApField) {
                if (StringUtils.isEmpty((CharSequence)((String)fieldValue))) {
                    params.add(0L);
                } else {
                    params.add(Long.parseLong((String)fieldValue));
                }
            } else {
                params.add(fieldValue);
            }
            if (fieldValue instanceof DynamicObject) {
                builder.append(((DynamicObject)fieldValue).getPkValue()).append("#@#");
                continue;
            }
            if (fieldValue instanceof Object[]) {
                List collect = Arrays.stream((Object[])fieldValue).map(n -> {
                    if (n instanceof DynamicObject) {
                        return ((DynamicObject)n).getPkValue();
                    }
                    return n;
                }).collect(Collectors.toList());
                builder.append(collect).append("#@#");
                continue;
            }
            if (fieldValue instanceof FsLargeTextValue) {
                builder.append(((FsLargeTextValue)fieldValue).getKey());
                continue;
            }
            builder.append(fieldValue).append("#@#");
        }
        List<MatchPluginResult> responses = pf.createMatchPluginProxy(feeShareObject.getTypeConfig(), matchRuleConfig).matchCondition(feeShareObject);
        if (CollectionUtils.isNotEmpty(responses)) {
            for (MatchPluginResult plugin : responses) {
                params.add(plugin.getMatchValue());
                builder.append(plugin.getMatchValue());
                response.addPluginConditionName(plugin.getMatchName());
            }
        }
        response.setGroupKey(builder.toString());
        return response;
    }

    private static Object getFieldValue(FsMatchConditionConfig field, FeeShareObjectBase writeOffObject) {
        IDataEntityProperty srcPropType;
        Object value = writeOffObject.getValue(field.getSrcBillFieldKey());
        if (field.isLargeText()) {
            value = FsLargeTextValue.create(String.valueOf(value));
        }
        if ((srcPropType = field.getSrcPropType()) instanceof ItemClassProp) {
            return value;
        }
        if (MatcherUtil.isUseMasterid(srcPropType)) {
            String fieldKey = field.getSrcBillFieldKey() + ".masterid";
            value = writeOffObject.getValue(fieldKey);
        }
        return value;
    }

    public static List<FeeShareMatchGroup> splitByShareRule(List<FeeShareMatchGroup> writeOffMatchGroups, ShareRuleConfig shareRuleConfig) {
        ArrayList<FeeShareMatchGroup> result = new ArrayList<FeeShareMatchGroup>(16);
        for (FeeShareMatchGroup writeOffMatchGroup : writeOffMatchGroups) {
            HashMap splitByShareRule = new HashMap(16);
            List<FeeShareObject> writeOffObjects = writeOffMatchGroup.getFeeShareObjects();
            for (FeeShareObject feeShareObject : writeOffObjects) {
                ShareRuleBillConfig shareBillConifg = shareRuleConfig.getShareBillConifg(feeShareObject);
                if (shareBillConifg == null) continue;
                List objList = MapUtils.mapGetListValue(splitByShareRule, (Object)((Long)shareBillConifg.getObjId()));
                objList.add(feeShareObject);
            }
            for (Map.Entry entry : splitByShareRule.entrySet()) {
                FeeShareMatchGroup doClone = writeOffMatchGroup.doClone();
                doClone.addFeeShareObjects((List)entry.getValue());
                doClone.setShareRuleBillConfig(shareRuleConfig, shareRuleConfig.getShareBillConfig((Long)entry.getKey()));
                result.add(doClone);
            }
        }
        return result;
    }
}

