/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareLogInfo;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;

public class FeeShareLogHelper {
    public static void saveLogs(Collection<FeeShareLogInfo> logs) {
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(16);
        for (FeeShareLogInfo writeOffNLogInfo : logs) {
            logObjs.add(writeOffNLogInfo.preSave());
        }
        try (TXHandle tx = TX.notSupported();){
            SaveServiceHelper.save((DynamicObject[])logObjs.toArray(new DynamicObject[logObjs.size()]));
        }
    }

    public static void saveLogsWithExeption(Collection<FeeShareLogInfo> logs, Exception e) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(16);
        for (FeeShareLogInfo writeOffNLogInfo : logs) {
            long logid = writeOffNLogInfo.getWfLogObj().getLong("id");
            ids.add(logid);
            String errorType = writeOffNLogInfo.getErrorType();
            writeOffNLogInfo.setErrorType(errorType == null ? "D" : errorType);
            writeOffNLogInfo.setErrorMessage(e);
            logObjs.add(writeOffNLogInfo.preSave());
        }
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"msmod_wf_nlog", (QFilter[])new QFilter("id", "in", ids).toArray());
            SaveServiceHelper.save((DynamicObject[])logObjs.toArray(new DynamicObject[logObjs.size()]));
        }
    }

    public static void updateTaskLogSuccess(long logTaskId) {
        String sql = "update t_msmod_wfnlogentry set ftaskexectime = ? , ftaskstatus = 'S' where fentryid = ?";
        Object[] param = new Object[]{new Date(), logTaskId};
        try (TXHandle tx = TX.notSupported();){
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])param);
        }
    }

    public static void updateTaskLogFail(long logTaskId, String failReason) {
        String failStr = CommonUtils.cutStr((String)failReason, (int)250);
        String sql = "update t_msmod_wfnlogentry set ftaskexectime = ? , ftaskstatus = 'F' , ftaskexecinfo = ? where fentryid = ?";
        Object[] param = new Object[]{new Date(), failStr, logTaskId};
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])param);
        }
    }

    public static void updateTaskLogFail(long logTaskId, Exception e) {
        FeeShareLogHelper.updateTaskLogFail(logTaskId, e.getClass().getSimpleName() + ":" + e.getMessage());
    }

    @Deprecated
    public static String cutStr(String message, int size) {
        return CommonUtils.cutStr((String)message, (int)size);
    }
}

