/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FeeShareTypeConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.backfeeshare.entity.BackFeeShareDetail;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.EntityParseHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class FeeShareRecordHelper {
    public static BackFeeShareDetail getWfInfo(DynamicObject record) {
        String headWfInfo = record.getString("headwfinfo_tag");
        BackFeeShareDetail backWriteOffDetail = (BackFeeShareDetail)JSONObject.parseObject((String)headWfInfo, BackFeeShareDetail.class);
        return backWriteOffDetail;
    }

    public static WriteoffTemplateTypeEnum getWfTemplateTypeByChildEntity(String recordTypeName) {
        MainEntityType inheritEntity = EntityParseHelper.getInheritEntity((String)recordTypeName);
        if (inheritEntity != null) {
            return FeeShareRecordHelper.getWfTemplateTypeByEntity(inheritEntity.getName());
        }
        return null;
    }

    public static WriteoffTemplateTypeEnum getWfTemplateTypeByEntity(String entity) {
        if ("msmod_leftrighwfrecordtpl".equals(entity) || "msmod_leftrtamounttpl".equals(entity)) {
            return WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT;
        }
        if ("msmod_updownwfrecordtpl".equals(entity) || "msmod_updownamounttpl".equals(entity)) {
            return WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN;
        }
        if ("msmod_mainassisttpl".equals(entity)) {
            return WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST;
        }
        return null;
    }

    public static Collection<String> getAllWFRecordEntity() {
        String sql = "select   a.fnumber   from t_meta_formdesign  a  where a.finheritpath in (select  b.fid from t_meta_formdesign b where  b.fnumber in ('msmod_updownwfrecordtpl','msmod_leftrighwfrecordtpl','msmod_leftrtamounttpl','msmod_mainassisttpl','msmod_updownamounttpl'))";
        DataSet data = DB.queryDataSet((String)FeeShareRecordHelper.class.getName(), (DBRoute)DBRoute.meta, (String)sql);
        ArrayList<String> list = new ArrayList<String>(16);
        while (data.hasNext()) {
            String billType = data.next().getString("fnumber");
            list.add(billType);
        }
        return list;
    }

    public static DynamicObject cloneRecord(DynamicObject oldRecordInfo, String recordEntityNum) {
        DynamicObject newRecord = BusinessDataServiceHelper.newDynamicObject((String)recordEntityNum);
        DynamicObjectUtil.copy((DynamicObject)oldRecordInfo, (DynamicObject)newRecord);
        return newRecord;
    }

    public static Map<Long, List<DynamicObject>> loadWfRecord(FeeShareTypeConfig typeConfig, DynamicObject[] dataEntities) {
        List<Object> billIds = Stream.of(dataEntities).map(item -> item.get("id")).collect(Collectors.toList());
        if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == typeConfig.getWfRecordTemplateEnum()) {
            return FeeShareRecordHelper.loadLeftRightWfRecord(typeConfig, billIds);
        }
        if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == typeConfig.getWfRecordTemplateEnum()) {
            return FeeShareRecordHelper.loadUpDownWfRecord(typeConfig, billIds);
        }
        if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == typeConfig.getWfRecordTemplateEnum()) {
            return FeeShareRecordHelper.loadMainAssistWfRecord(typeConfig, billIds);
        }
        return Collections.emptyMap();
    }

    private static Map<Long, List<DynamicObject>> loadLeftRightWfRecord(FeeShareTypeConfig typeConfig, List<Object> billIds) {
        Long typeId = typeConfig.getId();
        String recordBillType = typeConfig.getRecordNum();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)recordBillType);
        QFilter qFilter = new QFilter("entry.billid", "in", billIds);
        qFilter.or("entry.assbillid", "in", billIds);
        qFilter.and("writeofftypeid", "=", (Object)typeId);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<DynamicObject>> dymMap = new HashMap<Long, List<DynamicObject>>(billIds.size());
        DynamicObject[] entities = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
        for (Object billId : billIds) {
            ArrayList<DynamicObject> dymList = new ArrayList<DynamicObject>(4);
            block1: for (DynamicObject entity : entities) {
                DynamicObjectCollection rows = entity.getDynamicObjectCollection("entry");
                for (DynamicObject row : rows) {
                    if (billId.equals(row.getLong("billid"))) {
                        dymList.add(entity);
                        continue block1;
                    }
                    if (!billId.equals(row.getLong("assbillid"))) continue;
                    dymList.add(entity);
                    continue block1;
                }
            }
            dymMap.put((Long)billId, dymList);
        }
        return dymMap;
    }

    private static Map<Long, List<DynamicObject>> loadUpDownWfRecord(FeeShareTypeConfig typeConfig, List<Object> billIds) {
        Long typeId = typeConfig.getId();
        String recordBillType = typeConfig.getRecordNum();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)recordBillType);
        QFilter qFilter = new QFilter("entry.billid", "in", billIds);
        qFilter.and("writeofftypeid", "=", (Object)typeId);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<DynamicObject>> dymMap = new HashMap<Long, List<DynamicObject>>(billIds.size());
        DynamicObject[] entities = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
        for (Object billId : billIds) {
            ArrayList<DynamicObject> dymList = new ArrayList<DynamicObject>(4);
            block1: for (DynamicObject entity : entities) {
                DynamicObjectCollection rows = entity.getDynamicObjectCollection("entry");
                for (DynamicObject row : rows) {
                    if (!billId.equals(row.getLong("billid"))) continue;
                    dymList.add(entity);
                    continue block1;
                }
            }
            dymMap.put((Long)billId, dymList);
        }
        return dymMap;
    }

    private static Map<Long, List<DynamicObject>> loadMainAssistWfRecord(FeeShareTypeConfig typeConfig, List<Object> billIds) {
        Long typeId = typeConfig.getId();
        String recordBillType = typeConfig.getRecordNum();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)recordBillType);
        ArrayList ids = new ArrayList(billIds.size());
        QFilter qFilter = new QFilter("billid", "in", billIds);
        QFilter qFilterType = new QFilter("writeofftypeid", "=", (Object)typeId);
        QFilter qFilterEntryId = new QFilter("entry.e_billid", "in", billIds);
        List idsById = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilter.and(qFilterType).toArray(), null, (int)-1);
        List idsByEntryId = QueryServiceHelper.queryPrimaryKeys((String)recordBillType, (QFilter[])qFilterEntryId.and(qFilterType).toArray(), null, (int)-1);
        ids.addAll(idsById);
        ids.addAll(idsByEntryId);
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<DynamicObject>> dymMap = new HashMap<Long, List<DynamicObject>>(billIds.size());
        DynamicObject[] entities = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
        for (Object billId : billIds) {
            ArrayList<DynamicObject> dymList = new ArrayList<DynamicObject>(4);
            block1: for (DynamicObject entity : entities) {
                Long headBillId = entity.getLong("billid");
                if (billId.equals(headBillId)) {
                    dymList.add(entity);
                    continue;
                }
                DynamicObjectCollection rows = entity.getDynamicObjectCollection("entry");
                for (DynamicObject row : rows) {
                    if (!billId.equals(row.getLong("e_billid"))) continue;
                    dymList.add(entity);
                    continue block1;
                }
            }
            dymMap.put((Long)billId, dymList);
        }
        return dymMap;
    }
}

