/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsLargeTextValue;
import kd.mpscmm.mscommon.feeshare.business.config.vo.FsMatchConditionConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FsDataTable;
import kd.mpscmm.mscommon.writeoff.business.engine.core.sort.CommonComparator;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;

public class MatcherUtil {
    public static final Log log = LogFactory.getLog(MatcherUtil.class);

    public static String specialFieldDeal(IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            String bdType;
            String name = property.getName();
            IDataEntityType complexType = ((BasedataProp)property).getComplexType();
            switch (bdType = complexType.getName()) {
                case "bd_materialinventoryinfo": 
                case "bd_materialpurchaseinfo": 
                case "bd_materialsalinfo": {
                    return name + ".masterid";
                }
                case "bd_material": {
                    return name;
                }
                case "bd_supplier": 
                case "bd_customer": {
                    return name + ".masterid";
                }
            }
            return null;
        }
        return null;
    }

    public static boolean isUseMasterid(IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            String bdType;
            IDataEntityType complexType = ((BasedataProp)property).getComplexType();
            switch (bdType = complexType.getName()) {
                case "bd_materialinventoryinfo": 
                case "bd_materialpurchaseinfo": 
                case "bd_materialsalinfo": 
                case "bd_supplier": 
                case "bd_customer": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static Long getDynamicOjbectId(DynamicObject obj) {
        String bdType;
        switch (bdType = obj.getDataEntityType().getName()) {
            case "bd_materialinventoryinfo": 
            case "bd_materialpurchaseinfo": 
            case "bd_materialsalinfo": 
            case "bd_supplier": 
            case "bd_customer": {
                return obj.getDynamicObject("masterid").getLong("id");
            }
        }
        return obj.getLong("id");
    }

    public static List<QFilter> buildQueryFilter(List<FsMatchConditionConfig> matchConditionConfigs, FsDataTable dataTable) {
        return MatcherUtil.buildQueryFilter(matchConditionConfigs, dataTable, null);
    }

    public static List<QFilter> buildQueryFilter(List<FsMatchConditionConfig> matchConditionConfigs, FsDataTable dataTable, String wfMainFieldId) {
        ArrayList<QFilter> demosBillFilters = new ArrayList<QFilter>(16);
        for (FsMatchConditionConfig matchColumnConfig : matchConditionConfigs) {
            String[] split;
            String srcBillFieldKey = matchColumnConfig.getSrcBillFieldKey();
            List<Object> dimValues = dataTable.getDimValues(srcBillFieldKey);
            String comparison = matchColumnConfig.getComparison();
            if (matchColumnConfig.getEmptyEqual().booleanValue() && matchColumnConfig.checkEmptyValues(dimValues)) {
                dimValues.addAll(matchColumnConfig.getEmptyValue());
            }
            if (!matchColumnConfig.getEmptyEqual().booleanValue() && matchColumnConfig.checkAllEmptyValues(dimValues)) {
                log.info("\u6838\u9500\u6279\u91cf\u83b7\u53d6\u5339\u914d\u6570\u636e\u65f6\u3010" + matchColumnConfig.getSrcBillFieldName() + "\u3011\u672a\u5f00\u542f\u7a7a\u503c\u5339\u914d\uff0c\u4e14\u503c\u5168\u90e8\u4e3a\u7a7a\u3002");
                return Collections.singletonList(CommonHelper.getEmptyFilter());
            }
            String targetBillFieldKey = matchColumnConfig.getTargetBillFieldKey();
            String specialField = MatcherUtil.specialFieldDeal(matchColumnConfig.getTgtPropType());
            if (specialField != null && (split = targetBillFieldKey.split("\\.")).length > 1) {
                targetBillFieldKey = split[0] + "." + specialField;
            }
            if (matchColumnConfig.isLargeText()) {
                QFilter largeTextHintQFilter = MatcherUtil.getLargeTextHintQFilter(dimValues, wfMainFieldId, matchColumnConfig.getTargetBillType());
                if (largeTextHintQFilter == null) continue;
                demosBillFilters.add(largeTextHintQFilter);
                continue;
            }
            switch (comparison) {
                case "=": {
                    demosBillFilters.add(new QFilter(targetBillFieldKey, "in", new HashSet<Object>(dimValues)));
                    break;
                }
                case "!=": {
                    if (dimValues.size() != 1) break;
                    demosBillFilters.add(new QFilter(targetBillFieldKey, "!=", dimValues.get(0)));
                    break;
                }
                case ">=": 
                case ">": {
                    dimValues.sort((Comparator<Object>)CommonComparator.getInstance());
                    demosBillFilters.add(new QFilter(targetBillFieldKey, comparison, dimValues.get(0)));
                    break;
                }
                case "<=": 
                case "<": {
                    dimValues.sort((Comparator<Object>)CommonComparator.getInstance());
                    demosBillFilters.add(new QFilter(targetBillFieldKey, comparison, dimValues.get(dimValues.size() - 1)));
                    break;
                }
            }
        }
        return demosBillFilters;
    }

    private static QFilter getLargeTextHintQFilter(List<Object> dimValues, String wfMainFieldId, String targetEntity) {
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        ArrayList<Long> entryIds = new ArrayList<Long>(16);
        for (Object dimValue : dimValues) {
            FsLargeTextValue largetText = (FsLargeTextValue)dimValue;
            if (largetText.getEntryIds().isEmpty()) {
                billIds.addAll(largetText.getIds());
                continue;
            }
            entryIds.addAll(largetText.getEntryIds());
        }
        if (!entryIds.isEmpty() && StringUtils.isEmpty((CharSequence)wfMainFieldId)) {
            return null;
        }
        String idKey = "id";
        String entryField = wfMainFieldId;
        if ("cal_costrecord_subentity".equals(targetEntity)) {
            entryField = "entry.bizbillentryid";
            idKey = "bizbillid";
        }
        ArrayList<QFilter> largeTextFilters = new ArrayList<QFilter>(16);
        if (!entryIds.isEmpty()) {
            largeTextFilters.add(new QFilter(entryField, "in", entryIds));
        }
        if (!billIds.isEmpty()) {
            largeTextFilters.add(new QFilter(idKey, "in", billIds));
        }
        QFilter largeTextFilter = null;
        for (QFilter ltFilter : largeTextFilters) {
            if (largeTextFilter == null) {
                largeTextFilter = ltFilter;
                continue;
            }
            largeTextFilter.or(ltFilter);
        }
        return largeTextFilter;
    }
}

