/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.ext.scmc.cal.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mpscmm.mscommon.feeshare.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class ActualShareMatchPlugin
implements IMatchPlugin {
    private static final Log logger = LogFactory.getLog(ActualShareMatchPlugin.class);
    private static final Long BILLTYPE_ADJUST = 535203350950479872L;
    private static final Long BILLTYPE_STDPURAP = 688848270033699840L;
    private static final Long BILLTYPE_PRODUCTOMAP = 1032360624543254528L;

    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet((Long[])new Long[]{WriteOffTypeIdConst.HXLB_ACTUALFEE_SHARE});
    }

    public Set<Long> getMachRuleIds() {
        return CommonUtils.getIdSet((Long[])new Long[]{WriteOffTypeIdConst.PPGZ_ACT_SHARE_PLUGIN_MATCH});
    }

    public Boolean matchCompare(MatchPluginResult response, Object srcValue) {
        return true;
    }

    public List<MatchPluginResult> matchCondition(WriteOffObjectArgs writeOffObjectArgs) {
        ArrayList<MatchPluginResult> results = new ArrayList<MatchPluginResult>(1);
        WriteOffObjectBase writeOffObject = writeOffObjectArgs.getWriteOffObjectBase();
        String entityKey = writeOffObject.getWFBillEntityName();
        if (!"ap_finapbill".equals(entityKey)) {
            logger.info("ActualShareMatchPlugin:\u6838\u9500\u5bf9\u8c61\u4e0d\u662f\u8d22\u52a1\u5e94\u4ed8");
            return results;
        }
        Object billId = writeOffObject.getWfBillPk();
        Object entryId = writeOffObject.getPkValue();
        String entryKey = writeOffObject.getMainFieldEntityType().getName();
        Long billTypeId = (Long)writeOffObject.getValue("billtypeid");
        Long expenseItemId = (Long)writeOffObject.getValue("detailentry.expenseitem");
        String e_sourcebillid = (String)writeOffObject.getValue("detailentry.e_sourcebillid");
        String e_sourcebillentryid = (String)writeOffObject.getValue("detailentry.e_sourcebillentryid");
        Boolean iswrittenoff = (Boolean)writeOffObject.getValue("iswrittenoff");
        MatchPluginResult response = new MatchPluginResult();
        StringBuilder matchInfoBuild = new StringBuilder();
        matchInfoBuild.append(entityKey);
        matchInfoBuild.append('#');
        matchInfoBuild.append(billTypeId);
        matchInfoBuild.append('#');
        matchInfoBuild.append(billId);
        matchInfoBuild.append('#');
        matchInfoBuild.append(entryKey);
        matchInfoBuild.append('#');
        matchInfoBuild.append(entryId);
        matchInfoBuild.append('#');
        matchInfoBuild.append(expenseItemId);
        matchInfoBuild.append('#');
        matchInfoBuild.append(e_sourcebillid);
        matchInfoBuild.append('#');
        matchInfoBuild.append(e_sourcebillentryid);
        matchInfoBuild.append('#');
        matchInfoBuild.append(iswrittenoff);
        response.setMatchValue(matchInfoBuild.toString());
        response.setMatchName("actualshare");
        response.setComparison("in");
        results.add(response);
        return results;
    }

    public QFilter getMatchFilter(Object value, String targetEntity, String targetEntry) {
        logger.info("ActualShareMatchPlugin:\u5f00\u59cb\u6784\u9020\u8fc7\u6ee4\u6761\u4ef6");
        if (!"cal_costrecord_subentity".equals(targetEntity)) {
            logger.info("ActualShareMatchPlugin:\u76ee\u6807\u5355\u4e0d\u662f\u6210\u672c\u8bb0\u5f55:" + targetEntity);
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        if (value == null) {
            logger.info("ActualShareMatchPlugin:\u65e0\u5339\u914d\u7ed3\u679c");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        String[] values = value.toString().split("#");
        String entityKey = values[0];
        Long billTypeId = Long.valueOf(values[1]);
        Long billId = Long.valueOf(values[2]);
        String entryKey = values[3];
        Long entryId = Long.valueOf(values[4]);
        Long expenseItemId = Long.valueOf(values[5]);
        String e_sourcebillid = values[6];
        String e_sourcebillentryid = values[7];
        Boolean iswrittenoff = Boolean.valueOf(values[8]);
        HashSet<Long> srcBillIds = new HashSet<Long>(8);
        HashSet<Long> srcBillEntryIds = new HashSet<Long>(8);
        if (Long.compare(billTypeId, BILLTYPE_ADJUST) == 0) {
            if (expenseItemId == 0L && !iswrittenoff.booleanValue()) {
                return this.getPurWriteOffFilter(e_sourcebillid, e_sourcebillentryid);
            }
            this.handleLinkUpNodes(entityKey, entryKey, billId, entryId, "ap_finapbill", srcBillIds, srcBillEntryIds);
        } else if (Long.compare(billTypeId, BILLTYPE_STDPURAP) == 0 && iswrittenoff.booleanValue()) {
            this.handleLinkUpNodes(entityKey, entryKey, billId, entryId, "ap_finapbill", srcBillIds, srcBillEntryIds);
        } else if (Long.compare(billTypeId, BILLTYPE_STDPURAP) == 0 || Long.compare(billTypeId, BILLTYPE_PRODUCTOMAP) == 0) {
            this.handleLinkUpNodes(entityKey, entryKey, billId, entryId, "ap_busbill", srcBillIds, srcBillEntryIds);
        }
        if (srcBillIds.isEmpty()) {
            logger.info("ActualShareMatchPlugin:\u672a\u627e\u5230\u4e0a\u6e38\u5e94\u4ed8\u5355");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        return this.getFeeShareCostRecordFilter(targetEntry, srcBillIds, srcBillEntryIds);
    }

    private QFilter getPurWriteOffFilter(String e_sourcebillid, String e_sourcebillentryid) {
        if (StringUtils.isEmpty((CharSequence)e_sourcebillid) || StringUtils.isEmpty((CharSequence)e_sourcebillentryid)) {
            logger.info("ActualShareMatchPlugin:\u91c7\u8d2d\u53d1\u7968\u7684\u501f\u8d37\u9879\u8c03\u6574\u5355\u672a\u8bb0\u5f55\u6e90\u5355\u4fe1\u606f");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        Long srcbillid = Long.valueOf(e_sourcebillid);
        Long srcbillentryid = Long.valueOf(e_sourcebillentryid);
        QFilter recordQ = new QFilter("entry.e_billid", "=", (Object)srcbillid);
        recordQ.and("entry.e_billentryid", "=", (Object)srcbillentryid);
        recordQ.and("verifyrelation", "in", (Object)new String[]{"appurin", "appurreturn", "apomin", "apominreturn"});
        HashSet<Long> ids = new HashSet<Long>(4);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purwfrecord", (String)"id", (QFilter[])recordQ.toArray(), null);){
            for (Row row : ds) {
                ids.add(row.getLong("id"));
            }
        }
        HashSet<Long> bizbillids = new HashSet<Long>(4);
        HashSet<Long> bizbillentryids = new HashSet<Long>(4);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purwfrecord", (String)"billid,billentryid", (QFilter[])new QFilter("id", "in", ids).toArray(), null);){
            for (Row row : ds) {
                bizbillids.add(row.getLong("billid"));
                bizbillentryids.add(row.getLong("billentryid"));
            }
        }
        QFilter targetFilter = new QFilter("bizbillid", "in", bizbillids);
        targetFilter.and("entry.bizbillentryid", "in", bizbillentryids);
        return targetFilter;
    }

    private QFilter getFeeShareCostRecordFilter(String targetEntry, Set<Long> srcBillIds, Set<Long> srcBillEntryIds) {
        QFilter recordQ = new QFilter("entry.billid", "in", srcBillIds);
        recordQ.and("entry.billentryid", "in", srcBillEntryIds);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"cal_feeshare_newrecord", (String)"entry.billid,entry.billentryid,entry.calentryid", (QFilter[])recordQ.toArray());
        HashSet<Long> costRecordIds = new HashSet<Long>(16);
        HashSet<Long> costRecordEntryIds = new HashSet<Long>(16);
        for (DynamicObject record : records) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long calentryid = entry.getLong("calentryid");
                if (Long.compare(calentryid, 0L) == 0) continue;
                costRecordIds.add(entry.getLong("billid"));
                costRecordEntryIds.add(entry.getLong("billentryid"));
            }
        }
        if (costRecordIds.isEmpty()) {
            logger.info("EstShareMatchPlugin:\u4ece\u8d39\u7528\u5206\u644a\u52fe\u7a3d\u8bb0\u5f55\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        QFilter targetFilter = new QFilter("id", "in", costRecordIds);
        targetFilter.and(targetEntry, "in", costRecordEntryIds);
        return targetFilter;
    }

    private void handleLinkUpNodes(String curEntity, String curEntryKey, Long curId, Long curEntryId, String targetEntity, Set<Long> ids, Set<Long> entryIds) {
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)curEntryKey, (Long[])new Long[]{curId}, (Long[])new Long[]{curEntryId}, null);
        TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)targetEntity);
        Long upTableId = tableDefine.getTableId();
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            List<BFRowLinkUpNode> sourceNodes = ActualShareMatchPlugin.findSourceNodes(linkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                ids.add(sourceNode.getRowId().getBillId());
                entryIds.add(sourceNode.getRowId().getEntryId());
            }
        }
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(ActualShareMatchPlugin.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }
}

