/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.feeshare.business.config.vo.sharerule.ShareRuleBillConfig;
import kd.mpscmm.mscommon.feeshare.business.engine.FeeShareExecuteContext;
import kd.mpscmm.mscommon.feeshare.business.engine.ReverseFeeShareEngine;
import kd.mpscmm.mscommon.feeshare.business.engine.action.AbstractFeeShareAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.FeeShareActionProcessor;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.BillSelectFieldLoadAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.FlowBillFsExecuteAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.FlowBillGroupAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.FlowFeeShareLoadAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.LoadMatchRuleAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.LoadShareRuleAction;
import kd.mpscmm.mscommon.feeshare.business.engine.action.impl.LoadWriteBackRuleAction;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareMatchGroup;
import kd.mpscmm.mscommon.feeshare.business.engine.core.src.bo.FeeShareObject;
import kd.mpscmm.mscommon.feeshare.form.AbstractFsFormPlugin;
import kd.mpscmm.mscommon.writeoff.common.log.WriteOffExeucteInfo;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;

public class FeeShareValidatePlugin
extends AbstractFsFormPlugin
implements ClickListener {
    private static final String ENTRY_BILL_LIST = "billlist";
    private static final String BILLNO = "billno";
    protected static final String BILL_TYPE = "billtype";
    private static final String SEARCH = "fsconfsearch";
    private static final String PRE_MATCH = "fsprematch";
    private static final String WFEXECUTE = "fsexecute";
    private static final String UN_WFEXECUTE = "fsunexecute";
    public static final String SEARCH_WRITEOFF_TYPE = "writeofftype";
    public static final String BILLNO_DISPLAY = "billno_display";

    @Override
    public void registerListener(EventObject e) {
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{BILL_TYPE});
        this.addClickListeners(new String[]{SEARCH, WFEXECUTE, "selectok", "showselectfield", "billquery", PRE_MATCH, "schemematch", UN_WFEXECUTE});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        Control control = (Control)event.getSource();
        if (BILL_TYPE.equals(control.getKey())) {
            this.beforeBillTypeSelect(event);
        }
    }

    private void beforeBillTypeSelect(BeforeF7SelectEvent event) {
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"msmod_writeofftype", (String)"id, writeoffbillentry.writeoffbilltype", (QFilter[])new QFilter(SEARCH_WRITEOFF_TYPE, "=", (Object)"B").and("enable", "=", (Object)Boolean.TRUE).toArray());
        HashSet<Object> billtypes = new HashSet<Object>(16);
        for (DynamicObject data : datas) {
            billtypes.add(data.get("writeoffbillentry.writeoffbilltype"));
        }
        event.addCustomQFilter(new QFilter("id", "in", billtypes));
    }

    public void click(EventObject e) {
        super.click(e);
        String key = FormUtils.getControlEventKey((EventObject)e);
        String billtype = this.getBillType();
        switch (key) {
            case "fsconfsearch": {
                this.clickMatch(billtype, this.getGroupActions());
                break;
            }
            case "fsexecute": {
                this.clickMatch(billtype, this.getExecuteActions());
                break;
            }
            case "fsprematch": {
                this.clickMatch(billtype, this.getPreExecuteActions());
                break;
            }
            case "fsunexecute": {
                this.unexecute(billtype);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "billtype": {
                this.billTypeChange(e);
                break;
            }
        }
    }

    private void billTypeChange(PropertyChangedArgs e) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newValue != null) {
            ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>(16);
            String formId = newValue.getString("number");
            List ops = EntityMetadataCache.getDataEntityOperate((String)formId);
            for (Map op : ops) {
                String opKey = (String)op.get("key");
                operationItems.add(new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), opKey));
            }
            ComboEdit woffEdit = (ComboEdit)this.getView().getControl("writeoffop");
            woffEdit.setComboItems(operationItems);
        }
    }

    private void unexecute(String billtype) {
        this.getModel().deleteEntryData("schemeset_entry");
        this.getModel().deleteEntryData("subentryentity");
        this.getModel().deleteEntryData("submatchentry");
        this.getModel().setValue("executeinfo", (Object)"");
        List<DynamicObject> selectedBills = this.getSelectedBill(billtype);
        if (selectedBills.isEmpty()) {
            return;
        }
        String op = (String)this.getValue("writeoffop");
        ReverseFeeShareEngine.execute(selectedBills.toArray(new DynamicObject[selectedBills.size()]), op, null);
    }

    private FeeShareExecuteContext clickMatch(String billtype, List<AbstractFeeShareAction> actions) {
        this.getModel().deleteEntryData("schemeset_entry");
        this.getModel().deleteEntryData("subentryentity");
        this.getModel().deleteEntryData("submatchentry");
        this.getModel().setValue("executeinfo", (Object)"");
        List<DynamicObject> selectedBills = this.getSelectedBill(billtype);
        if (selectedBills.isEmpty()) {
            return null;
        }
        ArrayList<Object> billId = new ArrayList<Object>(16);
        for (DynamicObject bill : selectedBills) {
            billId.add(bill.getPkValue());
        }
        String op = (String)this.getValue("writeoffop");
        long startTime = System.currentTimeMillis();
        FeeShareActionProcessor processor = FeeShareActionProcessor.build(actions);
        FeeShareExecuteContext context = FeeShareExecuteContext.createFlow(billtype, billId, op);
        try (TXHandle tx = TX.requiresNew();){
            processor.doProcess(context);
        }
        this.getView().showSuccessNotification("cost:" + (System.currentTimeMillis() - startTime) + "ms");
        this.parseResult(context);
        return context;
    }

    private void parseResult(FeeShareExecuteContext context) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<FeeShareMatchGroup> matchGroupMap = context.getMatchGroupMap();
        this.showExecuteInfo(context);
        this.getModel().beginInit();
        for (FeeShareMatchGroup group : matchGroupMap) {
            vs.addField("schemeset_name", new Object[]{group.getSchemeConfig().getId()});
            vs.addField("wftype", new Object[]{group.getTypeConfig().getId()});
            vs.addField("wfbilltype", new Object[]{group.getBillTypeConfig().getBillAlias()});
            vs.addField("matchkeyinfo", new Object[]{this.buildMatchKey(group.getMatchKeys())});
            vs.addField("sharerule", new Object[]{group.getShareRuleConfig().getObjId()});
            ShareRuleBillConfig shareRuleBillConfig = group.getShareRuleBillConfig();
            if (shareRuleBillConfig != null) {
                vs.addField("sharefield", new Object[]{shareRuleBillConfig.getNumerator().getWfFieldInfo().getWriteOffFieldKey()});
            }
            vs.addField("subentryentity", new Object[]{this.getGroupPageData(group)});
            vs.addField("submatchentry", new Object[]{this.getMatchPageData(group, context)});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("schemeset_entry", vs);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private DynamicObjectCollection getMatchPageData(FeeShareMatchGroup group, FeeShareExecuteContext context) {
        SubEntryType subEntryType = (SubEntryType)((SubEntryProp)this.getModel().getDataEntityType().findProperty("submatchentry")).getItemType();
        DynamicObjectCollection subEntry = new DynamicObjectCollection((DynamicObjectType)subEntryType, null);
        Long schemeId = group.getSchemeConfig().getId();
        Map<Long, Map<String, List<List<Map<String, Object>>>>> custParams = context.getTypeContext(group.getTypeConfig().getId()).getPreMatchMap();
        Map<String, List<List<Map<String, Object>>>> schemes = custParams.get(schemeId);
        if (MapUtils.isEmpty(schemes)) {
            return subEntry;
        }
        List<List<Map<String, Object>>> schemeQuery = schemes.get(group.getGroupKey());
        for (List<Map<String, Object>> list : schemeQuery) {
            for (Map<String, Object> matchData : list) {
                DynamicObject obj = subEntry.addNew();
                obj.set("matchbill", matchData.get("matchbill"));
                obj.set("matchobjbillno", matchData.get("matchobjbillno"));
                obj.set("matchobjtype", matchData.get("matchobjtype"));
                obj.set("matchobjbillid", matchData.get("matchobjbillid"));
                obj.set("curmatchnum", matchData.get("curmatchnum"));
                obj.set("matchnum", matchData.get("matchnum"));
            }
        }
        return subEntry;
    }

    private DynamicObjectCollection getGroupPageData(FeeShareMatchGroup group) {
        SubEntryType subEntryType = (SubEntryType)((SubEntryProp)this.getModel().getDataEntityType().findProperty("subentryentity")).getItemType();
        DynamicObjectCollection subEntry = new DynamicObjectCollection((DynamicObjectType)subEntryType, null);
        List<FeeShareObject> writeOffObjects = group.getFeeShareObjects();
        for (FeeShareObject wfObj : writeOffObjects) {
            DynamicObject obj = subEntry.addNew();
            obj.set("wfobjbillno", wfObj.getValue(BILLNO));
            if (wfObj.isBillObj()) {
                obj.set("wfobjtype", (Object)"0");
            } else {
                obj.set("wfobjtype", (Object)"1");
            }
            obj.set("wfobjbillid", wfObj.getPkValue());
            obj.set("curwfnum", (Object)wfObj.getFeeShareObjectBase().getCurWriteOffNumber());
            obj.set("wfnum", (Object)wfObj.getFeeShareObjectBase().getWriteOffNumber());
        }
        return subEntry;
    }

    private String buildMatchKey(List<Object> list) {
        StringBuilder buildKey = new StringBuilder();
        for (Object object : list) {
            if (object instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)object;
                buildKey.append(obj.getDataEntityType().getName());
                buildKey.append("[");
                buildKey.append(obj.getPkValue());
                buildKey.append("]");
            } else {
                buildKey.append(object);
            }
            buildKey.append(" ");
        }
        return buildKey.toString();
    }

    private void showExecuteInfo(FeeShareExecuteContext context) {
        WriteOffExeucteInfo executeInfo = context.getExecuteInfo();
        Map exeucteFailInfos = executeInfo.getExecuteFailInfos();
        StringBuilder str = new StringBuilder();
        str.append("billId - wftypeId - wfObjId - wfSchemeId\n");
        for (Map.Entry failInfoEntry : exeucteFailInfos.entrySet()) {
            str.append((String)failInfoEntry.getKey());
            str.append(" : ");
            str.append(String.valueOf(failInfoEntry.getValue()));
            str.append("\n");
        }
        this.getModel().setValue("executeinfo", (Object)str.toString());
    }

    public List<AbstractFeeShareAction> getGroupActions() {
        ArrayList<AbstractFeeShareAction> actions = new ArrayList<AbstractFeeShareAction>();
        actions.add(new FlowFeeShareLoadAction());
        actions.add(new LoadMatchRuleAction());
        actions.add(new LoadWriteBackRuleAction());
        actions.add(new LoadShareRuleAction());
        actions.add(new BillSelectFieldLoadAction());
        actions.add(new FlowBillGroupAction());
        return actions;
    }

    public List<AbstractFeeShareAction> getExecuteActions() {
        List<AbstractFeeShareAction> actions = this.getGroupActions();
        actions.add(new FlowBillFsExecuteAction());
        return actions;
    }

    public List<AbstractFeeShareAction> getPreExecuteActions() {
        List<AbstractFeeShareAction> actions = this.getGroupActions();
        return actions;
    }

    private List<DynamicObject> getSelectedBill(String billtype) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_BILL_LIST);
        int[] selectRowIdex = entryGrid.getSelectRows();
        return this.getBill(billtype, selectRowIdex);
    }

    private List<DynamicObject> getBill(String billtype, int ... indexs) {
        IDataModel model = this.getModel();
        ArrayList<String> billNos = new ArrayList<String>(indexs.length);
        for (int i : indexs) {
            billNos.add((String)model.getValue(BILLNO, i));
        }
        if (billNos.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        QFilter filter = new QFilter(BILLNO, "in", billNos);
        DynamicObject[] querybills = BusinessDataServiceHelper.load((String)billtype, (String)"id,billno", (QFilter[])filter.toArray());
        if (querybills == null || querybills.length == 0) {
            throw new KDBizException(FormLang.billNotExist());
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(querybills.length);
        for (DynamicObject bill : querybills) {
            bills.add(bill);
        }
        return bills;
    }

    private String getBillType() {
        DynamicObject billType = (DynamicObject)this.getValue(BILL_TYPE);
        return billType != null ? billType.getString("number") : null;
    }
}

