/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.feeshare.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.cols.ExcludeFieldStrategy;
import kd.mpscmm.mscommon.writeoff.common.cols.IColsSelectStrategy;
import kd.mpscmm.mscommon.writeoff.common.cols.TypeSelectStategy;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfTypeBaseDataPlugin;
import kd.mpscmm.mscommon.writeoff.form.entity.FormConditionFilter;
import kd.mpscmm.mscommon.writeoff.form.entity.FormSelectFieldKey;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;

public class ShareRuleEditPlugin
extends AbstractWfTypeBaseDataPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(new String[]{"wfbillalias", "sharewfbillalias", "srcwfbillalias", "tgtwfbillalias"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] datas;
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        block16: for (ChangeData data : datas = e.getChangeSet()) {
            int rowIndex = data.getRowIndex();
            switch (fieldName) {
                case "sharewfbillalias": {
                    this.changeShareBill(data, rowIndex);
                    continue block16;
                }
                case "shareweight": {
                    this.changeShareWeight(rowIndex);
                    continue block16;
                }
                case "valuemethod": {
                    this.changeValueMethod(data);
                    continue block16;
                }
                case "sharedembillmatchtype": {
                    if (!"1".equals(e.getChangeSet()[0].getNewValue())) continue block16;
                    this.getModel().deleteEntryData("matchconditionentity");
                    continue block16;
                }
                case "srcwfbillalias": {
                    this.changeSrcBillAlias(data, rowIndex);
                }
                case "tgtwfbillalias": {
                    this.changeTgtBillAlias(data, rowIndex);
                }
            }
        }
    }

    private void changeSrcBillAlias(ChangeData data, int rowIndex) {
        this.getModel().setValue("srcbillfieldkey", null, rowIndex);
        this.getModel().setValue("srcbillfieldname", null, rowIndex);
        this.getModel().setValue("tgtwfbillalias", null, rowIndex);
    }

    private void changeTgtBillAlias(ChangeData data, int rowIndex) {
        this.getModel().setValue("targetbillfieldkey", null, rowIndex);
        this.getModel().setValue("targetbillfieldname", null, rowIndex);
    }

    private void changeShareBill(ChangeData data, int rowIndex) {
        this.getModel().setValue("standfiltercondition", null, rowIndex);
        this.getModel().setValue("standfilterconditiondesc", null, rowIndex);
        this.getModel().setValue("standfilterconditiondesc_tag", null, rowIndex);
        this.getModel().setValue("sharebillfieldkey", null, rowIndex);
        this.getModel().setValue("sharebillfieldname", null, rowIndex);
        this.getModel().setValue("wffieldplugin", null, rowIndex);
        this.getModel().setValue("plugindescription", null, rowIndex);
        String shareWeight = (String)this.getModel().getValue("shareweight", rowIndex);
        DynamicObjectCollection entries = this.getModel().getEntryEntity("matchconditionentity");
        switch (shareWeight) {
            case "0": {
                for (int i = 0; i < entries.size(); ++i) {
                    this.getModel().setValue("srcbillfieldkey", null, i);
                    this.getModel().setValue("srcwfbillalias", null, i);
                    this.getModel().setValue("srcbillfieldname", null, i);
                }
                break;
            }
            case "1": {
                for (int i = 0; i < entries.size(); ++i) {
                    this.getModel().setValue("tgtwfbillalias", null, i);
                    this.getModel().setValue("targetbillfieldkey", null, i);
                    this.getModel().setValue("targetbillfieldname", null, i);
                }
                break;
            }
        }
    }

    private void changeShareWeight(int rowIndex) {
        this.getModel().setValue("sharedembillmatchtype", null, rowIndex);
        this.getModel().setValue("sharewfbillalias", null, rowIndex);
    }

    private void changeValueMethod(ChangeData data) {
        this.getModel().setValue("sharebillfieldkey", null, data.getRowIndex());
        this.getModel().setValue("sharebillfieldname", null, data.getRowIndex());
        this.getModel().setValue("wffieldplugin", null, data.getRowIndex());
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        switch (e.getEntryProp().getName()) {
            case "subentryentity": {
                this.getModel().deleteEntryData("matchconditionentity");
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        switch (e.getEntryProp().getName()) {
            case "entryentity": {
                this.afterAddEntryRow(e);
                break;
            }
            case "matchconditionentity": {
                this.afterAddMatchEntryRow(e);
                break;
            }
        }
    }

    private void afterAddMatchEntryRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        DynamicObjectCollection shareStandEntries = this.getModel().getEntryEntity("subentryentity");
        DynamicObject numBill = null;
        DynamicObject demBill = null;
        for (DynamicObject shareStandEntry : shareStandEntries) {
            if ("0".equals(shareStandEntry.getString("shareweight"))) {
                numBill = shareStandEntry.getDynamicObject("sharewfbillalias");
                continue;
            }
            if (!"1".equals(shareStandEntry.getString("shareweight"))) continue;
            demBill = shareStandEntry.getDynamicObject("sharewfbillalias");
        }
        for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
            this.getModel().setValue("srcwfbillalias", (Object)numBill, rowDataEntity.getRowIndex());
            this.getModel().setValue("tgtwfbillalias", (Object)demBill, rowDataEntity.getRowIndex());
        }
    }

    private void afterAddEntryRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        Object mainShareBill = this.getShareBillInfo().keySet().iterator().next();
        for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
            this.getModel().setItemValueByID("wfbillalias", mainShareBill, rowDataEntity.getRowIndex());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "newmatchentry": {
                this.beforeNewMatchEntry(args);
                break;
            }
            case "newstandentry": {
                this.beforeNewStandardEntry(args);
                break;
            }
        }
    }

    private void beforeNewStandardEntry(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subentryentity");
        if (entryEntity == null) {
            return;
        }
        if (entryEntity.size() >= 2) {
            throw new KDBizException(FormLang.olnyOneDenomAndNumer());
        }
    }

    private void beforeNewMatchEntry(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entires = this.getModel().getEntryEntity("subentryentity");
        if (entires == null) {
            return;
        }
        boolean isConfigDenominator = false;
        for (DynamicObject entry : entires) {
            String shareWeight = entry.getString("shareweight");
            if (!"1".equals(shareWeight)) continue;
            isConfigDenominator = true;
            break;
        }
        if (!isConfigDenominator) {
            throw new KDBizException(FormLang.plsInsertShareBillDenominator());
        }
    }

    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent event) {
        switch (key) {
            case "wfbillalias": {
                return this.getWFBillAliasFilter();
            }
            case "sharewfbillalias": {
                return this.getShareWFBillAliasFilter(event.getRow());
            }
            case "srcwfbillalias": {
                return this.getSrcWfBillFilter(event.getRow());
            }
            case "tgtwfbillalias": {
                return this.getTgtWfBillFilter(event.getRow());
            }
        }
        return super.buildF7SelectFilter(key, event);
    }

    private QFilter getSrcWfBillFilter(int row) {
        DynamicObjectCollection shareStandEntries = this.getModel().getEntryEntity("subentryentity");
        HashSet<Object> billIds = new HashSet<Object>(16);
        for (DynamicObject shareStandEntry : shareStandEntries) {
            DynamicObject shareWfBillAlias;
            if (!"0".equals(shareStandEntry.getString("shareweight")) || (shareWfBillAlias = shareStandEntry.getDynamicObject("sharewfbillalias")) == null) continue;
            billIds.add(shareWfBillAlias.getPkValue());
        }
        if (billIds.isEmpty()) {
            return CommonHelper.getEmptyFilter();
        }
        return new QFilter("id", "in", billIds);
    }

    private QFilter getTgtWfBillFilter(int row) {
        DynamicObjectCollection shareStandEntries = this.getModel().getEntryEntity("subentryentity");
        HashSet<Object> billIds = new HashSet<Object>(16);
        for (DynamicObject shareStandEntry : shareStandEntries) {
            DynamicObject shareWfBillAlias;
            if (!"1".equals(shareStandEntry.getString("shareweight")) || (shareWfBillAlias = shareStandEntry.getDynamicObject("sharewfbillalias")) == null) continue;
            billIds.add(shareWfBillAlias.getPkValue());
        }
        if (billIds.isEmpty()) {
            return CommonHelper.getEmptyFilter();
        }
        return new QFilter("id", "in", billIds);
    }

    private QFilter getWFBillAliasFilter() {
        Object mainShareBillId = this.getShareBillInfo().keySet().iterator().next();
        return new QFilter("id", "=", mainShareBillId);
    }

    private QFilter getShareWFBillAliasFilter(int i) {
        String shareWeight = (String)this.getValue("shareweight", i);
        if ("0".equals(shareWeight)) {
            List<DynamicObject> billAlias = this.getShareBillInfo().values().iterator().next();
            return new QFilter("id", "in", billAlias.stream().map(v -> v.get("wfbill.id")).collect(Collectors.toSet()));
        }
        return CommonHelper.getAllFilter();
    }

    protected void changeWriteOffType(DynamicObject newValue) {
        if (newValue != null) {
            this.initWriteOffTypeInfo();
        }
    }

    protected void clearWriteOffType() {
        IDataModel model = this.getModel();
        model.setValue("description", (Object)"");
        model.deleteEntryData("entryentity");
        model.deleteEntryData("subentryentity");
        model.deleteEntryData("matchconditionentity");
        DynamicObject wftypeObj = (DynamicObject)this.getModel().getValue("writeofftype");
        if (wftypeObj != null) {
            this.initWriteOffTypeInfo();
        }
    }

    private void initWriteOffTypeInfo() {
        IDataModel model = this.getModel();
        Map<Object, List<DynamicObject>> shareBillInfo = this.getShareBillInfo();
        Object mainAlias = shareBillInfo.keySet().iterator().next();
        model.createNewEntryRow("entryentity");
        model.setItemValueByID("wfbillalias", mainAlias, 0);
        DynamicObject assistAlias = shareBillInfo.values().iterator().next().get(0);
        model.createNewEntryRow("subentryentity");
        model.setValue("shareweight", (Object)"0", 0);
        model.setItemValueByID("sharewfbillalias", assistAlias.get("wfbill.id"), 0);
    }

    protected List<FormConditionFilter> getFormConditions() {
        ArrayList<FormConditionFilter> list = new ArrayList<FormConditionFilter>(16);
        list.add(FormConditionFilter.build((String)"wfbillalias", (String)"entryentity", (String)"filtercondition", (String)"filterconditiondesc", (boolean)false));
        list.add(FormConditionFilter.build((String)"sharewfbillalias", (String)"subentryentity", (String)"standfiltercondition", (String)"standfilterconditiondesc", (boolean)false));
        return list;
    }

    protected IColsSelectStrategy getSelectStrategy(FormSelectFieldKey fieldKey) {
        if ("targetbillfieldname".equals(fieldKey.getFieldName())) {
            int index = this.getModel().getEntryCurrentRowIndex(fieldKey.getEntryKey());
            String srcFieldKey = this.getStrValue("srcbillfieldkey", index);
            DynamicObject srcWFBillAlias = (DynamicObject)this.getValue("srcwfbillalias", index);
            MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)srcWFBillAlias.getString("number"));
            String[] srcFieldKeys = srcFieldKey.split("\\.");
            if (srcFieldKeys.length > 0) {
                srcFieldKey = srcFieldKeys[srcFieldKeys.length - 1];
            }
            IDataEntityProperty property = billEntityType.findProperty(srcFieldKey);
            return new TypeSelectStategy(property);
        }
        if ("srcbillfieldname".equals(fieldKey.getFieldName())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("matchconditionentity");
            HashSet<String> configedField = new HashSet<String>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                String srcField = entry.getString("srcbillfieldkey");
                if (!StringUtils.isNotEmpty((CharSequence)srcField)) continue;
                configedField.add(srcField);
            }
            String billentity = ((DynamicObject)this.getValue("srcwfbillalias")).getString("number");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentity);
            for (IDataEntityProperty prop : dataEntityType.getAllFields().values()) {
                if (!(prop instanceof MuliLangTextProp)) continue;
                IDataEntityType parent = prop.getParent();
                if (billentity.equals(parent.getName())) {
                    configedField.add(prop.getName());
                    continue;
                }
                configedField.add(parent.getName() + "." + prop.getName());
            }
            return new ExcludeFieldStrategy(configedField);
        }
        return super.getSelectStrategy(fieldKey);
    }

    protected List<FormSelectFieldKey> getSelectFieldKey() {
        ArrayList<FormSelectFieldKey> list = new ArrayList<FormSelectFieldKey>(16);
        list.add(FormSelectFieldKey.buildQuantity((String)"sharewfbillalias", (String)"subentryentity", (String)"sharebillfieldname", (String)"sharebillfieldkey"));
        list.add(FormSelectFieldKey.build((String)"srcwfbillalias", (String)"matchconditionentity", (String)"srcbillfieldname", (String)"srcbillfieldkey").showId());
        list.add(FormSelectFieldKey.build((String)"tgtwfbillalias", (String)"matchconditionentity", (String)"targetbillfieldname", (String)"targetbillfieldkey").showId());
        return list;
    }

    private Map<Object, List<DynamicObject>> getShareBillInfo() {
        DynamicObject writeOffType = (DynamicObject)this.getValue(this.writeOffTypeKey());
        QFilter qFilter = new QFilter("id", "=", writeOffType.getPkValue());
        DynamicObject wfTypeEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_writeofftype", (String)"writeoffbillentry.wfbillalias,writeoffbillentry.ismainshare, writeoffbillentry.isautogenerate", (QFilter[])qFilter.toArray());
        DynamicObjectCollection wfBills = wfTypeEntity.getDynamicObjectCollection("writeoffbillentry");
        Object mainShareId = null;
        ArrayList<DynamicObject> shareIds = new ArrayList<DynamicObject>(16);
        for (DynamicObject wfBill : wfBills) {
            if (wfBill.getBoolean("isautogenerate")) continue;
            DynamicObject alias = wfBill.getDynamicObject("wfbillalias");
            boolean isMainShare = wfBill.getBoolean("ismainshare");
            if (isMainShare) {
                mainShareId = alias.get("id");
                continue;
            }
            shareIds.add(alias);
        }
        if (mainShareId == null) {
            throw new KDBizException(FormLang.writeOffTypeNotConfigMainShare());
        }
        if (shareIds.isEmpty()) {
            throw new KDBizException(FormLang.witeOffTypeNotConfigShareBill());
        }
        return Collections.singletonMap(mainShareId, shareIds);
    }
}

