/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.assigncfg.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.assigncfg.common.consts.CommonConst;
import kd.mpscmm.mscommon.assigncfg.common.consts.PropertyDataType;
import kd.mpscmm.mscommon.assigncfg.common.helper.DataModelHelper;
import kd.mpscmm.mscommon.assigncfg.common.helper.FieldLangFormTranslator;
import kd.mpscmm.mscommon.assigncfg.common.helper.FormShowHelper;
import kd.mpscmm.mscommon.business.strategy.SimpleStrategy;
import kd.mpscmm.mscommon.business.strategy.TypeSelectStategy;
import kd.mpscmm.mscommon.common.utils.FormUtil;
import org.apache.commons.lang3.ObjectUtils;

public class AssignCfgEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(AssignCfgEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcfiltercondition", "tgtfiltercondition", "tgttriggeraction", "tgtmatchfield", "srcmatchfield", "tgtassignfield", "srcassignfield"});
        FormUtil.addF7Listener(this, "matchgroup");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (fieldKey) {
            case "matchgroup": {
                this.beforeF7WithMatchGroup(evt, showParameter);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.translate();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translate();
    }

    private void translate() {
        try {
            IDataModel model = this.getModel();
            Object sourceBill = model.getValue("srcentity");
            Object targetObj = model.getValue("tgtentity");
            String sourceBillNumber = sourceBill instanceof DynamicObject ? ((DynamicObject)sourceBill).getString("number") : "";
            String targetObjNumber = targetObj instanceof DynamicObject ? ((DynamicObject)targetObj).getString("number") : "";
            FieldLangFormTranslator fieldLangFormTranslator = FieldLangFormTranslator.create(this.getModel());
            fieldLangFormTranslator.filterTranslate(sourceBillNumber, "srcfilterjson_tag", "srcfiltercondition");
            fieldLangFormTranslator.filterTranslate(targetObjNumber, "tgtfilterjson_tag", "tgtfiltercondition");
            if ("A".equals(model.getValue("triggertype"))) {
                fieldLangFormTranslator.headFieldTranslate(targetObjNumber, "tgttriggeractionkey", "tgttriggeraction");
            }
            fieldLangFormTranslator.entryFieldTranslate("matchentry", sourceBillNumber, "srcmatchfieldkey", "srcmatchfield");
            fieldLangFormTranslator.entryFieldTranslate("matchentry", targetObjNumber, "tgtmatchfieldkey", "tgtmatchfield");
            fieldLangFormTranslator.entryFieldTranslate("assignentry", sourceBillNumber, "srcassignfieldkey", "srcassignfield");
            fieldLangFormTranslator.entryFieldTranslate("assignentry", targetObjNumber, "tgtassignfieldkey", "tgtassignfield");
            model.setDataChanged(false);
        }
        catch (Exception e) {
            log.error("\u591a\u8bed\u8a00\u7ffb\u8bd1\u5931\u8d25", (Throwable)e);
        }
    }

    private void beforeF7WithMatchGroup(BeforeF7SelectEvent evt, ListShowParameter showParameter) {
        ArrayList filterList = new ArrayList(1);
        int rowIdx = this.getModel().getEntryCurrentRowIndex("matchentry");
        String matchType = (String)this.getModel().getValue("matchtype", rowIdx);
        if ("A".equals(matchType)) {
            evt.setCancel(true);
            return;
        }
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "applyorg": {
                this.showFormByOrg(this.getModel().getValue("id"));
                break;
            }
        }
    }

    private void showFormByOrg(Object billId) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u53d6\u503c\u914d\u7f6e\u3002", (String)"AssignCfgEditPlugin_0", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("fid", billId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msmod_assigncfg_org");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "tgtfiltercondition": {
                this.clickTgtFilterCondition(model);
                break;
            }
            case "srcfiltercondition": {
                this.clickSrcFilterCondition(model);
                break;
            }
            case "tgttriggeraction": {
                this.clickTgtTriggerAction(model);
                break;
            }
            case "tgtmatchfield": {
                this.clickTgtMatchField(model, control);
                break;
            }
            case "srcmatchfield": {
                this.clickSrcMatchField(model, control);
                break;
            }
            case "tgtassignfield": {
                this.clickTgtAssignField(model, control);
                break;
            }
            case "srcassignfield": {
                this.clickSrcAssignField(model, control);
                break;
            }
        }
    }

    private void clickTgtTriggerAction(IDataModel model) {
        DynamicObject targetBill = model.getDataEntity().getDynamicObject("tgtentity");
        if (targetBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5b9e\u4f53\u3002", (String)"AssignCfgEditPlugin_2", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        String triggerType = this.getModel().getDataEntity().getString("triggertype");
        String entityNumber = targetBill.getString("number");
        if ("A".equals(triggerType)) {
            ArrayList<String> filterFields = new ArrayList<String>(16);
            String field = this.getModel().getDataEntity().getString("tgttriggeractionkey");
            filterFields.add(field);
            FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, entityNumber, new SimpleStrategy(), filterFields, Boolean.FALSE, "tgttriggerfieldCB", new PropertyDataType[0]);
        } else {
            FormShowHelper.showOperationForm((AbstractFormPlugin)this, entityNumber, "tgttriggeropCB");
        }
    }

    private void clickSrcAssignField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("assignentry");
        DynamicObject entity = model.getDataEntity().getDynamicObject("srcentity");
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5b9e\u4f53\u3002", (String)"AssignCfgEditPlugin_1", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        DynamicObject tgtEntity = (DynamicObject)this.getModel().getValue("tgtentity");
        MainEntityType tgtEntityType = MetadataServiceHelper.getDataEntityType((String)tgtEntity.getString("number"));
        String tgtAssignFieldKey = (String)this.getModel().getValue("tgtassignfieldkey", currentRowIndex);
        DynamicProperty tgtProp = RowDataModel.findProperty((MainEntityType)tgtEntityType, (String)tgtAssignFieldKey);
        String entityNumber = entity.getString("number");
        FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, entityNumber, currentRowIndex, new TypeSelectStategy((IDataEntityProperty)tgtProp), null, Boolean.FALSE, "srcassignfieldCB", new PropertyDataType[0]);
    }

    private void clickTgtAssignField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("assignentry");
        DynamicObject entity = model.getDataEntity().getDynamicObject("tgtentity");
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5b9e\u4f53\u3002", (String)"AssignCfgEditPlugin_2", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        String entityNumber = entity.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("assignentry");
        for (DynamicObject entry : entries) {
            String field = entry.getString("tgtassignfieldkey");
            filterFields.add(field);
        }
        FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, entityNumber, currentRowIndex, new SimpleStrategy(), filterFields, Boolean.FALSE, "tgtassignfieldCB", new PropertyDataType[0]);
    }

    private void clickTgtMatchField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("matchentry");
        DynamicObject entity = model.getDataEntity().getDynamicObject("tgtentity");
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5b9e\u4f53\u3002", (String)"AssignCfgEditPlugin_2", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        String entityNumber = entity.getString("number");
        DynamicObject row = model.getEntryRowEntity("matchentry", currentRowIndex);
        String matchType = row.getString("matchtype");
        if ("A".equals(matchType)) {
            FormShowHelper.showEntryRefColsTreeForm((AbstractFormPlugin)this, entityNumber, currentRowIndex, Boolean.FALSE, "tgtmatchfieldCB", new PropertyDataType[0]);
        } else if ("B".equals(matchType)) {
            DynamicObject matchGroup = row.getDynamicObject("matchgroup");
            if (null == matchGroup) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5206\u7ec4\u3002", (String)"AssignCfgEditPlugin_5", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataobj = matchGroup.getDynamicObject("dataobj");
            String type = dataobj.getString("number");
            MaterielProp basedataProp = "bd_material".equals(type) ? new MaterielProp() : new BasedataProp();
            basedataProp.setBaseEntityId(type);
            FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, entityNumber, currentRowIndex, new TypeSelectStategy((IDataEntityProperty)basedataProp, false), null, Boolean.FALSE, "tgtmatchfieldCB", new PropertyDataType[0]);
        }
    }

    private void clickSrcMatchField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("matchentry");
        DynamicObject entity = model.getDataEntity().getDynamicObject("srcentity");
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5b9e\u4f53\u3002", (String)"AssignCfgEditPlugin_1", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        String entityNumber = entity.getString("number");
        DynamicObject row = model.getEntryRowEntity("matchentry", currentRowIndex);
        String matchType = row.getString("matchtype");
        if ("A".equals(matchType)) {
            FormShowHelper.showEntryRefColsTreeForm((AbstractFormPlugin)this, entityNumber, currentRowIndex, Boolean.FALSE, "srcmatchfieldCB", new PropertyDataType[0]);
        } else if ("B".equals(matchType)) {
            DynamicObject matchGroup = row.getDynamicObject("matchgroup");
            if (null == matchGroup) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5206\u7ec4\u3002", (String)"AssignCfgEditPlugin_5", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
                return;
            }
            DynamicObject groupobj = matchGroup.getDynamicObject("groupobj");
            BasedataProp basedataProp = new BasedataProp();
            basedataProp.setBaseEntityId(groupobj.getString("number"));
            FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, entityNumber, currentRowIndex, new TypeSelectStategy((IDataEntityProperty)basedataProp, false), null, Boolean.FALSE, "srcmatchfieldCB", new PropertyDataType[0]);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "tgtfilterconditionCB": {
                FormShowHelper.closeCallSetFilter(dataModel, pageCache, returnData, "tgtfiltercondition", "tgtfilterjson_tag", "tgtfilterformula_tag");
                break;
            }
            case "srcfilterconditionCB": {
                FormShowHelper.closeCallSetFilter(dataModel, pageCache, returnData, "srcfiltercondition", "srcfilterjson_tag", "srcfilterformula_tag");
                break;
            }
            case "tgttriggerfieldCB": {
                FormShowHelper.closeCallSetField(dataModel, returnData, "tgttriggeraction", "tgttriggeractionkey");
                break;
            }
            case "tgttriggeropCB": {
                FormShowHelper.closeCallSetOperation(dataModel, returnData, "tgttriggeraction", "tgttriggeractionkey");
                break;
            }
            case "tgtmatchfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "tgtmatchfield", "tgtmatchfieldkey");
                break;
            }
            case "srcmatchfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "srcmatchfield", "srcmatchfieldkey");
                break;
            }
            case "tgtassignfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "tgtassignfield", "tgtassignfieldkey");
                break;
            }
            case "srcassignfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "srcassignfield", "srcassignfieldkey");
                break;
            }
        }
    }

    private void clickTgtFilterCondition(IDataModel model) {
        DynamicObject srcBill = model.getDataEntity().getDynamicObject("tgtentity");
        if (srcBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5b9e\u4f53\u3002", (String)"AssignCfgEditPlugin_2", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        String entityNumber = srcBill.getString("number");
        FormShowHelper.showFilterForm((AbstractFormPlugin)this, model, entityNumber, "tgtfilterjson_tag", "tgtfilterconditionCB");
    }

    private void clickSrcFilterCondition(IDataModel model) {
        DynamicObject srcBill = model.getDataEntity().getDynamicObject("srcentity");
        if (srcBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5b9e\u4f53\u3002", (String)"AssignCfgEditPlugin_1", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            return;
        }
        String entityNumber = srcBill.getString("number");
        FormShowHelper.showFilterForm((AbstractFormPlugin)this, model, entityNumber, "srcfilterjson_tag", "srcfilterconditionCB");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIdx = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "srcentity": {
                this.srcEntityChange(newValue, oldValue);
                break;
            }
            case "srcfiltercondition": {
                this.srcConditionChange(newValue);
                break;
            }
            case "tgtentity": {
                this.tgtEntityChange(newValue, oldValue);
                break;
            }
            case "tgtfiltercondition": {
                this.tgtConditionChange(newValue);
                break;
            }
            case "triggertype": {
                this.triggerTypeChange(newValue);
                break;
            }
            case "tgttriggeraction": {
                this.triggerActionChange(newValue);
                break;
            }
            case "matchtype": {
                this.matchTypeChange(newValue, rowIdx);
                break;
            }
            case "matchgroup": {
                this.matchGroupChange(newValue, rowIdx);
                break;
            }
            case "tgtmatchfield": {
                this.tgtMatchFieldChange(newValue, rowIdx);
                break;
            }
            case "srcmatchfield": {
                this.srcMatchFieldChange(newValue, rowIdx);
                break;
            }
            case "tgtassignfield": {
                this.tgtAssignFieldChange(newValue, rowIdx);
                break;
            }
            case "srcassignfield": {
                this.srcAssignFieldChange(newValue, rowIdx);
                break;
            }
        }
        this.getView().updateView();
    }

    private void srcAssignFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "srcassignfieldkey");
        }
    }

    private void srcMatchFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "srcmatchfieldkey");
        }
    }

    private void tgtAssignFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "tgtassignfieldkey");
        }
        DataModelHelper.clearEntryField(this.getModel(), rowIdx, "srcassignfield", "srcassignfieldkey");
    }

    private void tgtMatchFieldChange(Object newValue, int rowIdx) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "tgtmatchfieldkey");
        }
        DataModelHelper.clearEntryField(this.getModel(), rowIdx, "srcmatchfield", "srcmatchfieldkey");
    }

    private void matchGroupChange(Object newValue, int rowIdx) {
        String matchType = (String)this.getModel().getValue("matchtype", rowIdx);
        if ("A".equals(matchType)) {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "matchgroup");
        } else {
            DataModelHelper.clearEntryField(this.getModel(), rowIdx, "tgtmatchfield", "tgtmatchfieldkey", "srcmatchfield", "srcmatchfieldkey");
        }
    }

    private void tgtConditionChange(Object newValue) {
        DataModelHelper.clearField(StringUtils.isBlank((Object)newValue), this.getModel(), "tgtfiltercondition", "tgtfilterjson_tag", "tgtfilterformula_tag");
    }

    private void srcConditionChange(Object newValue) {
        DataModelHelper.clearField(StringUtils.isBlank((Object)newValue), this.getModel(), "srcfiltercondition", "srcfilterjson_tag", "srcfilterformula_tag");
    }

    private void triggerActionChange(Object newValue) {
        DataModelHelper.clearField(StringUtils.isBlank((Object)newValue), this.getModel(), "tgttriggeractionkey");
    }

    private void matchTypeChange(Object newValue, int rowIdx) {
        DataModelHelper.clearEntryField(this.getModel(), rowIdx, "matchgroup", "tgtmatchfield", "tgtmatchfieldkey", "srcmatchfield", "srcmatchfieldkey");
    }

    private void triggerTypeChange(Object newValue) {
        DataModelHelper.clearField(this.getModel(), "tgttriggeraction", "tgttriggeractionkey");
    }

    private void tgtEntityChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldValDym = (DynamicObject)oldValue;
            DynamicObject newValDym = (DynamicObject)newValue;
            HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(16);
            confirmInfo.put(CommonConst.OLD_VALUE, oldValDym.getPkValue());
            if (newValDym != null) {
                confirmInfo.put(CommonConst.NEW_VALUE, newValDym.getPkValue());
            }
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u76ee\u6807\u5b9e\u4f53\u5c06\u6e05\u9664\u9875\u9762\u7684\u76ee\u6807\u5b9e\u4f53\u8fc7\u6ee4\u6761\u4ef6\u3001\u53d6\u503c\u6761\u4ef6\u3001\u8d4b\u503c\u5b57\u6bb5\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"AssignCfgEditPlugin_3", (String)"mpscmm-mscommon-common", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("tgtentityCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        }
    }

    private void srcEntityChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldValDym = (DynamicObject)oldValue;
            DynamicObject newValDym = (DynamicObject)newValue;
            HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(16);
            confirmInfo.put(CommonConst.OLD_VALUE, oldValDym.getPkValue());
            if (newValDym != null) {
                confirmInfo.put(CommonConst.NEW_VALUE, newValDym.getPkValue());
            }
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u6765\u6e90\u5b9e\u4f53\u5c06\u6e05\u9664\u9875\u9762\u7684\u6765\u6e90\u5b9e\u4f53\u8fc7\u6ee4\u6761\u4ef6\u3001\u53d6\u503c\u6761\u4ef6\u3001\u8d4b\u503c\u5b57\u6bb5\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"AssignCfgEditPlugin_4", (String)"mpscmm-mscommon-common", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("srcentityCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.getModel().setValue("srcentity", newValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        MessageBoxResult result = closedEvent.getResult();
        String customValue = closedEvent.getCustomVaule();
        switch (callBackId) {
            case "srcentityCB": {
                this.srcEntityConfirmCB(result, customValue);
                break;
            }
            case "tgtentityCB": {
                this.tgtEntityConfirmCB(result, customValue);
                break;
            }
        }
    }

    private void tgtEntityConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Object newValue = confirmInfo.get(CommonConst.NEW_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("tgtentity", newValue);
            DataModelHelper.clearField(this.getModel(), "tgtfiltercondition", "tgtfilterjson_tag", "tgtfilterformula_tag");
            DataModelHelper.clearField(this.getModel(), "tgttriggeraction", "tgttriggeractionkey");
            this.getModel().deleteEntryData("matchentry");
            this.getModel().createNewEntryRow("matchentry");
            this.getModel().deleteEntryData("assignentry");
            this.getModel().createNewEntryRow("assignentry");
            this.getModel().endInit();
            this.getView().updateView();
        } else {
            Object oldValue = confirmInfo.get(CommonConst.OLD_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("tgtentity", oldValue);
            this.getModel().endInit();
            this.getView().updateView("tgtentity");
        }
    }

    private void srcEntityConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Object newValue = confirmInfo.get(CommonConst.NEW_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("srcentity", newValue);
            DataModelHelper.clearField(this.getModel(), "srcfiltercondition", "srcfilterjson_tag", "srcfilterformula_tag");
            this.getModel().deleteEntryData("matchentry");
            this.getModel().createNewEntryRow("matchentry");
            this.getModel().deleteEntryData("assignentry");
            this.getModel().createNewEntryRow("assignentry");
            this.getModel().endInit();
            this.getView().updateView();
        } else {
            Object oldValue = confirmInfo.get(CommonConst.OLD_VALUE);
            this.getModel().beginInit();
            this.getModel().setValue("srcentity", oldValue);
            this.getModel().endInit();
            this.getView().updateView("srcentity");
        }
    }
}

