/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.assigncfg.form.base;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;

public class OperationSelectEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String entityNumber = (String)params.get("entitynumber");
        List<Map<String, Object>> ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if ((ops = this.filter(ops)) != null && ops.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow("entryentity", ops.size());
            for (int idx = 0; idx < ops.size(); ++idx) {
                Map<String, Object> op = ops.get(idx);
                model.setValue("type", op.get("type"), idx);
                model.setValue("key", op.get("key"), idx);
                Map opName = (Map)op.get("name");
                model.setValue("name", (Object)LocaleString.fromMap((Map)opName).getLocaleValue(), idx);
            }
        }
    }

    private List<Map<String, Object>> filter(List<Map<String, Object>> ops) {
        HashSet<String> opTypeLimits = new HashSet<String>(Arrays.asList("save", "submit", "donothing"));
        if (CollectionUtils.isNotEmpty(ops)) {
            return ops.stream().filter((? super T op) -> opTypeLimits.contains(op.get("type"))).collect(Collectors.toList());
        }
        return ops;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                Map<String, Object> opMap = this.getSelectOpMap();
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(opMap));
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    private Map<String, Object> getSelectOpMap() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("key", this.getModel().getValue("key", rowIdx));
        param.put("name", this.getModel().getValue("name", rowIdx));
        param.put("type", this.getModel().getValue("type", rowIdx));
        return param;
    }
}

