/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.assigncfg.op.validator;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AssignCfgSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkMatchEntry(dataEntity);
        }
    }

    private void checkMatchEntry(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("matchentry");
        if (!this.checkBracketMatch(dynamicObjectCollection)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AssignCfgSaveValidator_1", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
        }
        this.checkMatchGroup(dataEntity, dynamicObjectCollection);
        this.checkSubEntity(dataEntity);
    }

    private void checkSubEntity(ExtendedDataEntity dataEntity) {
        DynamicObject assignCfg = dataEntity.getDataEntity();
        String tgtEntityKey = assignCfg.getString("tgtentity.number");
        this.checkEntryNumber(dataEntity, tgtEntityKey, assignCfg, true);
        String srcEntityKey = assignCfg.getString("srcentity.number");
        this.checkEntryNumber(dataEntity, srcEntityKey, assignCfg, false);
    }

    public void checkEntryNumber(ExtendedDataEntity dataEntity, String entityNumber, DynamicObject assignCfg, boolean isCheckTgtEntry) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        String cfgName = assignCfg.getString("name");
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        HashSet<String> entrySet = new HashSet<String>(4);
        if (isCheckTgtEntry) {
            entrySet.addAll(this.getEntryName(dataEntity, mainEntityType, cfgName, assignCfg.getDynamicObjectCollection("matchentry"), "tgtmatchfieldkey", "tgtmatchfield"));
            entrySet.addAll(this.getEntryName(dataEntity, mainEntityType, cfgName, assignCfg.getDynamicObjectCollection("assignentry"), "tgtassignfieldkey", "tgtassignfield"));
        } else {
            entrySet.addAll(this.getEntryName(dataEntity, mainEntityType, cfgName, assignCfg.getDynamicObjectCollection("matchentry"), "srcmatchfieldkey", "srcmatchfield"));
            entrySet.addAll(this.getEntryName(dataEntity, mainEntityType, cfgName, assignCfg.getDynamicObjectCollection("assignentry"), "srcassignfieldkey", "srcassignfield"));
        }
        if (entrySet.isEmpty()) {
            return;
        }
        if (1 == entrySet.size()) {
            return;
        }
        Map entityTypeMap = mainEntityType.getAllEntities();
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (!entrySet.contains(entry.getKey()) || !(entityType instanceof SubEntryType)) continue;
            IDataEntityType parent = entityType.getParent();
            entrySet.remove(parent.getName());
        }
        if (1 < entrySet.size()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53d6\u503c\u6761\u4ef6\u4e0e\u8d4b\u503c\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5728\u4e0d\u540c\u5e73\u7ea7\u5206\u5f55\u3002", (String)"DymUtils_1", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
        }
    }

    private Set<String> getEntryName(ExtendedDataEntity dataEntity, MainEntityType mainEntityType, String cfgName, DynamicObjectCollection entryRows, String keyField, String nameField) {
        HashSet<String> entrySet = new HashSet<String>(4);
        for (DynamicObject entryRow : entryRows) {
            String propKey = entryRow.getString(keyField);
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)propKey);
            if (null == property) {
                String fieldName = entryRow.getString(nameField);
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u81ea\u52a8\u53d6\u503c\u914d\u7f6e\u201c{0}\u201d\u4e2d\u8d4b\u503c\u914d\u7f6e\u201c{1}\u201d\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"DymUtils_0", (String)"mpscmm-mscommon-common", (Object[])new Object[]{cfgName, fieldName}));
                continue;
            }
            IDataEntityType parent = property.getParent();
            if (parent instanceof SubEntryType) {
                entrySet.add(parent.getName());
                continue;
            }
            if (!(parent instanceof EntryType)) continue;
            entrySet.add(parent.getName());
        }
        return entrySet;
    }

    private void checkMatchGroup(ExtendedDataEntity dataEntity, DynamicObjectCollection entries) {
        DynamicObject bill = dataEntity.getDataEntity();
        if (ObjectUtils.isEmpty((Object)entries)) {
            Long tplid = bill.getLong("tplid");
            if (0L == tplid) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d6\u503c\u6761\u4ef6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssignCfgSaveValidator_2", (String)"mpscmm-mscommon-common", (Object[])new Object[0]));
            }
            return;
        }
        for (int rowIdx = 0; rowIdx < entries.size(); ++rowIdx) {
            Object matchGroup;
            DynamicObject entry = (DynamicObject)entries.get(rowIdx);
            String matchType = entry.getString("matchtype");
            if (!"B".equals(matchType) || null != (matchGroup = entry.get("matchgroup"))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\uff1a\u201c\u5206\u7ec4\u5173\u7cfb\u201d\u4e3a\u7a7a\u3002", (String)"AssignCfgSaveValidator_0", (String)"mpscmm-mscommon-common", (Object[])new Object[0]), rowIdx + 1));
        }
    }

    private boolean checkBracketMatch(DynamicObjectCollection dynamicObjectCollection) {
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            return true;
        }
        ArrayDeque<String> stack = new ArrayDeque<String>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String[] rightBrackets;
            String rightBracketStr;
            String leftBracket = dynamicObject.getString("leftbracket");
            if (StringUtils.isNotBlank((CharSequence)leftBracket)) {
                stack.addAll(Arrays.asList(leftBracket.split("")));
            }
            if (!StringUtils.isNotBlank((CharSequence)(rightBracketStr = dynamicObject.getString("rightbracket")))) continue;
            for (String rightBracket : rightBrackets = rightBracketStr.split("")) {
                if ("(".equals(stack.peekLast())) {
                    stack.pollLast();
                    continue;
                }
                stack.push(rightBracket);
            }
        }
        return stack.isEmpty();
    }
}

