/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.billfieldmap.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.plugin.args.LoadFuncTypesEventArgs;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.business.helper.PageShowHelper;
import kd.mpscmm.mscommon.business.strategy.FilterStrategy;
import kd.mpscmm.mscommon.business.strategy.IColsSelectStrategy;
import kd.mpscmm.mscommon.business.strategy.TypeSelectStategy;
import kd.mpscmm.mscommon.common.utils.ColsTreeUtil;
import kd.mpscmm.mscommon.common.utils.MultiLangUtils;
import kd.mpscmm.mscommon.template.form.AbstractMSCBillPlugin;

public class BillFieldMappingEdit
extends AbstractMSCBillPlugin {
    private static final Log log = LogFactory.getLog(BillFieldMappingEdit.class);
    private static final String TARGET_OBJ_COL_CB = "targetObjColCB";
    private static final String SOURCE_BILL_COL_CB = "sourceBillColCB";
    private static final String FORMULA_CB = "formulaCB";
    private static final String CONDITION_CB = "conditionCB";

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        Object sourceBill = model.getValue("sourcebill");
        Object targetObj = model.getValue("targetobj");
        String langName = RequestContext.get().getLang().name();
        String sourceBillNumber = sourceBill instanceof DynamicObject ? ((DynamicObject)sourceBill).getString("number") : "";
        String targetObjNumber = targetObj instanceof DynamicObject ? ((DynamicObject)targetObj).getString("number") : "";
        MainEntityType sourceBillDt = "".equals(sourceBillNumber) ? null : EntityMetadataCache.getDataEntityType((String)sourceBillNumber);
        MainEntityType targetObjDt = "".equals(targetObjNumber) ? null : EntityMetadataCache.getDataEntityType((String)targetObjNumber);
        int count = model.getEntryRowCount("colsmap");
        for (int i = 0; i < count; ++i) {
            this.bindColNames(i, langName, sourceBillDt, targetObjDt);
        }
        model.setDataChanged(false);
    }

    private void bindColNames(int index, String langName, MainEntityType sourceBillDt, MainEntityType targetObjDt) {
        String formulaExpr;
        IDataModel model = this.getModel();
        String sourceValue = String.valueOf(model.getValue("sourcebillcol", index));
        if (sourceBillDt != null && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            String sourceColName = MultiLangUtils.getEntityKeyWithLang(langName, sourceBillDt, sourceValue);
            model.setValue("sourcebillcolno", (Object)sourceColName, index);
        }
        String targetValue = String.valueOf(model.getValue("targetobjcol", index));
        if (targetObjDt != null && StringUtils.isNotBlank((CharSequence)targetValue)) {
            String targetColName = MultiLangUtils.getEntityKeyWithLang(langName, targetObjDt, targetValue);
            model.setValue("targetobjcolno", (Object)targetColName, index);
        }
        if ((formulaExpr = (String)model.getValue("formula_tag", index)) != null && StringUtils.isNotBlank((CharSequence)formulaExpr)) {
            try {
                CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)formulaExpr, CRCondition.class);
                String transFormulaExpr = (String)formula.getLocaleExprTran().get((Object)langName);
                if (transFormulaExpr == null || StringUtils.isBlank((CharSequence)transFormulaExpr)) {
                    String expression = formula.getExpression();
                    if (StringUtils.isBlank((CharSequence)expression)) {
                        LocaleString description = formula.getDescription();
                        if (description != null) {
                            model.setValue("formuladesc", (Object)description.getLocaleValue(), index);
                        }
                    } else {
                        model.setValue("formuladesc", (Object)expression, index);
                    }
                } else {
                    model.setValue("formuladesc", (Object)transFormulaExpr, index);
                }
            }
            catch (Exception e) {
                log.error("\u8ba1\u7b97\u516c\u5f0f\u7ffb\u8bd1\u9519\u8bef\uff1a" + formulaExpr, (Throwable)e);
                this.getView().showErrorNotification("Translate fail:" + formulaExpr);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"targetobjcolno", "sourcebillcolno", "formuladesc"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "targetobjcolno": {
                this.clickTargetObjCol(evt);
                break;
            }
            case "sourcebillcolno": {
                this.clickSourceBillCol(evt);
                break;
            }
            case "formuladesc": {
                this.clickFormula();
                break;
            }
        }
    }

    private void clickSourceBillCol(EventObject evt) {
        IDataModel model = this.getModel();
        DynamicObject sourceBill = (DynamicObject)model.getValue("sourcebill");
        if (sourceBill == null) {
            String message = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"PlsSelectSourceBill", (String)"mpscmm-mscommon-common", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String sourcebilltype = sourceBill.getString("number");
        DynamicObject targetObj = (DynamicObject)model.getValue("targetobj");
        String targetObjtype = targetObj.getString("number");
        int index = model.getEntryCurrentRowIndex("colsmap");
        String prop = (String)model.getValue("targetobjcol", index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u3002", (String)"PlsCheckTargetObjCol", (String)"mpscmm-mscommon-common", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetObjtype);
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u7684\u6620\u5c04\u5b57\u6bb5\u3002", (String)"plsselectmapfield", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]), property.getDisplayName().getLocaleValue());
        this.showColsTreePage(sourcebilltype, new TypeSelectStategy(property), SOURCE_BILL_COL_CB, caption);
    }

    private void clickTargetObjCol(EventObject evt) {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue("targetobj");
        if (targetObj == null) {
            return;
        }
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u5b57\u6bb5\u3002", (String)"plsselectfield", (String)"scmc-sbs-form", (Object[])new Object[0]), targetObj.getString("name"));
        this.showColsTreePage(targetObj.getString("number"), this.buildTargetObjSelectStrategy(), TARGET_OBJ_COL_CB, caption);
    }

    protected IColsSelectStrategy buildTargetObjSelectStrategy() {
        ArrayList<String> existCols = new ArrayList<String>(16);
        DynamicObjectCollection colsMap = this.getModel().getEntryEntity("colsmap");
        for (DynamicObject colMap : colsMap) {
            String targetObjCol = colMap.getString("targetobjcol");
            if (!StringUtils.isNotEmpty((CharSequence)targetObjCol)) continue;
            String[] splitKey = targetObjCol.split("\\.");
            if (splitKey.length > 1) {
                targetObjCol = splitKey[splitKey.length - 1];
            }
            existCols.add(targetObjCol);
        }
        return new FilterStrategy(existCols);
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String closeCallBackKey, String caption) {
        PageShowHelper.showColsTreePage(this.getView(), entityNumber, strategy, new CloseCallBack((IFormPlugin)this, closeCallBackKey), caption);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "targetObjColCB": {
                this.targetObjColCloseCallBack(e);
                break;
            }
            case "sourceBillColCB": {
                this.sourceBillColCloseCallBack(e);
                break;
            }
            case "formulaCB": {
                this.callBackFormula(e);
                break;
            }
            case "conditionCB": {
                this.callBackConditon(e);
                break;
            }
        }
    }

    private void sourceBillColCloseCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        model.beginInit();
        JSONObject info = data.getJSONObject(0);
        model.setValue("sourcebillcol", (Object)info.getString("id"), index);
        model.setValue("sourcebillcolno", (Object)info.getString("text"), index);
        model.endInit();
        this.getView().updateView("colsmap");
    }

    private void targetObjColCloseCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        model.beginInit();
        JSONObject info = data.getJSONObject(0);
        model.setValue("targetobjcol", (Object)info.getString("id"), index);
        model.setValue("targetobjcolno", (Object)info.getString("text"), index);
        model.setValue("sourcebillcol", null, index);
        model.setValue("sourcebillcolno", null, index);
        model.endInit();
        this.getView().updateView("colsmap");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String type;
        super.beforeDoOperation(args);
        switch (type = ((FormOperate)args.getSource()).getType()) {
            case "newentry": {
                this.beforeDoNewEntry(args);
                break;
            }
        }
    }

    private void beforeDoNewEntry(BeforeDoOperationEventArgs args) {
        Object targetObj = this.getModel().getValue("targetobj");
        if (targetObj == null) {
            args.setCancel(true);
            String cancelMessage = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201d\u3002", (String)"targetObjIsNullCanNotAddMapping", (String)"mpscmm-mscommon-common", (Object[])new Object[0]);
            args.setCancelMessage(cancelMessage);
            this.getView().showErrorNotification(cancelMessage);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                long currUserId = RequestContext.get().getCurrUserId();
                this.getModel().setValue("modifier", (Object)currUserId);
                this.getView().updateView("modifier");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "sourcebill": {
                this.changeSourceBill(e);
                break;
            }
            case "targetobj": {
                this.changeTargetObj(e);
                break;
            }
            case "targetobjcolno": {
                this.changeTargetObjColNo(e);
                break;
            }
            case "sourcebillcolno": {
                this.changeSourceBillColNo(e);
                break;
            }
            case "selectvalue": {
                this.selectValueChanged(e);
                break;
            }
        }
    }

    private void changeTargetObjColNo(PropertyChangedArgs e) {
        ChangeData[] datas;
        this.getModel().endInit();
        for (ChangeData changeData : datas = e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            this.getModel().setValue("sourcebillcol", null, rowIndex);
            this.getModel().setValue("sourcebillcolno", null, rowIndex);
            this.getModel().setValue("targetobjcol", null, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void changeSourceBillColNo(PropertyChangedArgs e) {
        ChangeData[] datas;
        this.getModel().endInit();
        for (ChangeData changeData : datas = e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            this.getModel().setValue("sourcebillcol", null, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void changeTargetObj(PropertyChangedArgs e) {
        ChangeData[] datas;
        IDataModel model = this.getModel();
        model.deleteEntryData("colsmap");
        Object bizappObj = model.getValue("bizapp");
        for (ChangeData changeData : datas = e.getChangeSet()) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (bizappObj != null || newValue == null) continue;
            model.setValue("bizapp", (Object)newValue.getDynamicObject("bizappid"));
        }
    }

    private void changeSourceBill(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection closMap = model.getEntryEntity("colsmap");
        if (closMap.isEmpty()) {
            return;
        }
        model.beginInit();
        for (int i = 0; i < closMap.size(); ++i) {
            model.setValue("sourcebillcol", null, i);
            model.setValue("sourcebillcolno", null, i);
        }
        model.endInit();
        this.getView().updateView();
    }

    private void selectValueChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            this.getModel().setValue("sourcebillcolno", null, rowIndex);
            this.getModel().setValue("sourcebillcol", null, rowIndex);
            this.getModel().setValue("formuladesc", null, rowIndex);
            this.getModel().setValue("formula", null, rowIndex);
        }
    }

    private void clickFormula() {
        int row = this.getModel().getEntryCurrentRowIndex("colsmap");
        String selectValue = (String)this.getModel().getValue("selectvalue");
        DynamicObject sourceDyc = (DynamicObject)this.getModel().getValue("sourcebill");
        DynamicObject tagDyc = (DynamicObject)this.getModel().getValue("targetobj");
        if (sourceDyc == null) {
            String message = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"BillFieldMappingEdit_0", (String)"mpscmm-mscommon-common", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String formulaJson = (String)this.getModel().getValue("formula_tag", row);
        String entityName = sourceDyc.getString("number");
        String tagEntityName = tagDyc.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        MainEntityType tagBillType = EntityMetadataCache.getDataEntityType((String)tagEntityName);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        parameter.setIncludePKField(true);
        TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        String targetPropName = (String)this.getModel().getValue("targetobjcol", row);
        IDataEntityProperty targetProperty = tagBillType.findProperty(targetPropName);
        if ("2".equals(selectValue)) {
            this.showValByConditionForm(formulaJson, fldNodes, CONDITION_CB, targetProperty, entityName);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", dataEntityType.getName());
        showParameter.getCustomParams().put("treenodes", fldNodes);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("invp".equals(appId)) {
            String funcXML = this.getPurFuncsXML();
            showParameter.getCustomParams().put("functiontypes", funcXML);
        } else if ("sbs".equals(appId)) {
            String funcXML = this.getSupplyOrgFuncXML();
            showParameter.getCustomParams().put("functiontypes", funcXML);
        }
        showParameter.setFormId("botp_formula");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORMULA_CB));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showValByConditionForm(String json, String fieldNodes, String sourceCtrlKey, IDataEntityProperty targetProperty, String srcMainType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_valbycondition");
        showParameter.getCustomParams().put("crvalbyconditions", json);
        showParameter.getCustomParams().put("entitynumber", srcMainType);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        if (targetProperty instanceof BasedataProp) {
            showParameter.getCustomParams().put("baseentityid", ((BasedataProp)targetProperty).getBaseEntityId());
        }
        String funcsXML = this.getFuncsXML();
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public String getFuncsXML() {
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
            functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
            LoadFuncTypesEventArgs args = new LoadFuncTypesEventArgs(functionTypes);
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)args.getFuncTypes());
            this.getPageCache().put("functiontypes", funcsXML);
        }
        return funcsXML;
    }

    private void callBackFormula(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)returnData.toString(), CRCondition.class);
        int row = this.getModel().getEntryCurrentRowIndex("colsmap");
        if (formula != null) {
            this.getModel().setValue("formula_tag", (Object)returnData.toString());
            this.getModel().setValue("formuladesc", (Object)formula.getExprDesc(), row);
        }
    }

    private void callBackConditon(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        CRValByConditions formula = (CRValByConditions)SerializationUtils.fromJsonString((String)returnData.toString(), CRValByConditions.class);
        int row = this.getModel().getEntryCurrentRowIndex("colsmap");
        if (formula != null) {
            this.getModel().setValue("formula_tag", (Object)returnData.toString());
            this.getModel().setValue("formuladesc", (Object)formula.getDescription(), row);
        }
    }

    public String getPurFuncsXML() {
        FunctionTypes functionTypes = FunctionTypes.get();
        BillFieldMappingEdit.addRelationOrgCustomMethod(functionTypes);
        String funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
        return funcsXML;
    }

    public static void addRelationOrgCustomMethod(FunctionTypes functionTypes) {
        FunctionType customType = new FunctionType();
        customType.setDef("GetRelationOrg(ownerid, entryrecorgid, entryreqorgid)");
        customType.setId("GetRelationOrg");
        customType.setGroupId("SCMC");
        StringBuilder desc = new StringBuilder();
        desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u83b7\u53d6\u53d7\u6e90\u7ec4\u7ec7\u59d4\u6258\u7684\u76ee\u6807\u7ec4\u7ec7\uff1b", (String)"BillFieldMappingEdit_1", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aGetRelationOrg(ownerid, entryrecorgid, entryreqorgid)\uff1b", (String)"BillFieldMappingEdit_2", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aownerid, \u8d27\u4e3b; entryrecorgid, \u6536\u8d27\u7ec4\u7ec7; entryreqorgid\uff0c \u9700\u6c42\u7ec4\u7ec7\uff1b", (String)"BillFieldMappingEdit_3", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        desc.append(ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1aGetRelationOrg(0,  billentry.entryrecorg ,  billentry.entryreqorg ), 0\u4ee3\u8868\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u5176\u4ed6\u5219\u662f\u5b57\u6bb5\u6807\u8bc6\uff1b", (String)"BillFieldMappingEdit_4", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        customType.setDesc(new LocaleString(desc.toString()));
        customType.setReturnType("long");
        customType.setName(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u59d4\u6258\u7684\u6536\u8d27\u7ec4\u7ec7", (String)"BillFieldMappingEdit_5", (String)"mpscmm-mscommon-common", (Object[])new Object[0])));
        functionTypes.getFunctionTypes().add(customType);
    }

    public String getSupplyOrgFuncXML() {
        FunctionTypes functionTypes = FunctionTypes.get();
        functionTypes.getFunctionTypes().add(this.addSupplyOrgFun());
        String funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
        return funcsXML;
    }

    private FunctionType addSupplyOrgFun() {
        FunctionType functionType = new FunctionType();
        functionType.setDef("GetSupplyOrg(entityNumber,owner,org,reqOrg)");
        functionType.setId("GetSupplyOrg");
        functionType.setGroupId("SCMC");
        StringBuilder desc = new StringBuilder();
        desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u5e73\u8861\u5229\u5e93\u4f9b\u5e94\u5355\u636e\u83b7\u53d6\u4f9b\u5e94\u7ec4\u7ec7", (String)"BillFieldMappingEdit_6", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aGetSupplyOrg(entityNumber,owner,org,reqOrg)", (String)"BillFieldMappingEdit_7", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aentityNumber\uff1a\u5b9e\u4f53\u6807\u8bc6\uff0cowner\uff1a\u8d27\u4e3b\uff0corg\uff1a\u5e93\u5b58\u7ec4\u7ec7\uff0creqOrg\uff1a\u9700\u6c42\u7ec4\u7ec7", (String)"BillFieldMappingEdit_8", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        desc.append(ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1a\u7565", (String)"BillFieldMappingEdit_9", (String)"mpscmm-mscommon-common", (Object[])new Object[0])).append("\\n");
        functionType.setDesc(new LocaleString(desc.toString()));
        functionType.setReturnType("long");
        functionType.setName(new LocaleString(ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93\u4f9b\u5e94\u5355\u636e\u83b7\u53d6\u4f9b\u5e94\u7ec4\u7ec7", (String)"BillFieldMappingEdit_10", (String)"mpscmm-mscommon-common", (Object[])new Object[0])));
        return functionType;
    }
}

