/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.business.group.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.business.group.IGroupRelation;
import kd.mpscmm.mscommon.common.utils.CommonUtils;
import kd.mpscmm.mscommon.common.utils.DynamicObjectUtil;

public abstract class AbstractGroupRelation
implements IGroupRelation {
    private DynamicObject relationObj;
    private String groupEntityType;
    private String dataEntityType;
    private String longNumberKey;
    private String longNumberDLM = "";

    public AbstractGroupRelation(DynamicObject relationObj) {
        this.relationObj = relationObj;
    }

    protected void init() {
        this.dataEntityType = this.relationObj.getDynamicObject("dataobj").getString("number");
        this.groupEntityType = this.relationObj.getDynamicObject("groupobj").getString("number");
        BasedataEntityType groupEntity = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)this.groupEntityType);
        String longNumberKey = this.relationObj.getString("longnumberkey");
        if (StringUtils.isEmpty((CharSequence)longNumberKey)) {
            longNumberKey = groupEntity.getNumberProperty();
        }
        for (IDataEntityProperty prop : groupEntity.getProperties()) {
            if (!(prop instanceof ParentBasedataProp)) continue;
            this.longNumberDLM = ((ParentBasedataProp)prop).getLongNumberDLM();
            break;
        }
        this.longNumberKey = longNumberKey;
    }

    protected Map<Long, List<Long>> queryDataGroupInfo(String tableEntity, String dataKey, String groupKey, Collection<Long> dataIds, QFilter groupFilter) {
        HashMap<Long, List<Long>> groups = new HashMap<Long, List<Long>>(dataIds.size());
        QFilter filter = new QFilter(dataKey, "in", dataIds);
        if (groupFilter != null) {
            filter.and(groupFilter);
        }
        Map queryObjs = BusinessDataServiceHelper.loadFromCache((String)tableEntity, (String)(dataKey + "," + groupKey), (QFilter[])filter.toArray());
        for (DynamicObject obj : queryObjs.values()) {
            Long id = this.getObjId(obj.get(dataKey));
            Long groupId = this.getObjId(obj.get(groupKey));
            CommonUtils.mapGetListValue(groups, id).add(groupId);
        }
        return groups;
    }

    @Override
    public Map<Long, String> getGroupLongNumber(Collection<Long> groupIds) {
        HashMap<Long, String> groups = new HashMap<Long, String>(groupIds.size());
        if (StringUtils.isEmpty((CharSequence)this.longNumberKey)) {
            return groups;
        }
        Map queryObjs = BusinessDataServiceHelper.loadFromCache((String)this.groupEntityType, (String)("id," + this.longNumberKey), (QFilter[])new QFilter("id", "in", groupIds).toArray());
        for (DynamicObject obj : queryObjs.values()) {
            long groupid = obj.getLong("id");
            groups.put(groupid, obj.getString(this.longNumberKey));
        }
        return groups;
    }

    private Long getObjId(Object dataId) {
        Long id = null;
        if (dataId instanceof DynamicObject) {
            id = DynamicObjectUtil.getPkValue((DynamicObject)dataId);
        } else if (dataId instanceof Long) {
            id = (Long)dataId;
        } else if (dataId == null) {
            id = 0L;
        } else {
            Long.parseLong(dataId.toString());
        }
        return id;
    }

    protected DynamicObject getRelationObj() {
        return this.relationObj;
    }

    @Override
    public String getDataEntityType() {
        return this.dataEntityType;
    }

    @Override
    public String getGroupEntityType() {
        return this.groupEntityType;
    }

    @Override
    public Long getId() {
        return DynamicObjectUtil.getPkValue(this.relationObj);
    }

    @Override
    public String getLongNumberDLM() {
        return this.longNumberDLM;
    }
}

