/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.business.helper.datactrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.msbd.datacontrol.business.helper.DataCtrlServiceHelper;
import kd.mpscmm.mscommon.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.mpscmm.mscommon.business.helper.datactrl.MaterielIsolateResultHandle;
import kd.mpscmm.mscommon.business.helper.datactrl.WarehouseIsolateResultHandle;

public class InvBizDataCtrlHelper {
    private static final Log log = LogFactory.getLog(InvBizDataCtrlHelper.class);
    private final Map<String, List<DataCtrlSchemeResultHandle>> filterMap = new HashMap<String, List<DataCtrlSchemeResultHandle>>(4);
    private Set<String> checkNumList = new HashSet<String>(4);

    private InvBizDataCtrlHelper() {
    }

    public static InvBizDataCtrlHelper buildF7Helper() {
        InvBizDataCtrlHelper helper = new InvBizDataCtrlHelper();
        helper.addFilter(new WarehouseIsolateResultHandle());
        helper.addFilter(new MaterielIsolateResultHandle());
        return helper;
    }

    private static Set<Long> getCtrlDataByScheme(Map<String, Object> paramMap, String dataCtrlSchemeNum, DataCtrlSchemeResultHandle filter) {
        try {
            Map resultMap = DataCtrlServiceHelper.getCtrlDataByScheme(Collections.singletonMap(dataCtrlSchemeNum, paramMap), (String)dataCtrlSchemeNum);
            if (null == resultMap) {
                return Collections.emptySet();
            }
            Set<Long> dataSet = (Set<Long>)resultMap.get("ALLOW_DATA");
            if (null != filter) {
                dataSet = filter.dealResult(dataSet);
                return dataSet;
            }
            if (CollectionUtils.isEmpty((Collection)dataSet)) {
                log.info("\u6570\u636e\u63a7\u5236\u65b9\u6848[{}]\u5339\u914d\u4e3a\u7a7a,\u53c2\u6570:{}", (Object)dataCtrlSchemeNum, paramMap);
                return Collections.singleton(-1L);
            }
            return dataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> getDataByDataCtrl(Map<String, Map<String, Object>> paramsMap, DynamicObject strategyDym) {
        try {
            if (null == paramsMap || null == strategyDym) {
                return Collections.emptySet();
            }
            DynamicObjectCollection collection = strategyDym.getDynamicObjectCollection("entryentity");
            List dataCtrlSchemeNumList = collection.stream().map(item -> item.getString("datactrlscheme.number")).collect(Collectors.toList());
            Set<Long> allDataSet = new HashSet<Long>(4);
            for (String dataCtrlSchemeNum : dataCtrlSchemeNumList) {
                if (!this.checkNumList.isEmpty() && !this.checkNumList.contains(dataCtrlSchemeNum)) continue;
                List<DataCtrlSchemeResultHandle> filterList = this.filterMap.get(dataCtrlSchemeNum);
                if (CollectionUtils.isEmpty(filterList)) {
                    Map<String, Object> params = paramsMap.get(dataCtrlSchemeNum);
                    if (null == params) continue;
                    Set<Long> dataSet = InvBizDataCtrlHelper.getCtrlDataByScheme(params, dataCtrlSchemeNum, null);
                    if (null != dataSet && dataSet.contains(-1L)) {
                        return this.noData();
                    }
                    allDataSet = this.retainAll(allDataSet, dataSet);
                }
                for (DataCtrlSchemeResultHandle filter : filterList) {
                    Map<String, Object> params = paramsMap.get(dataCtrlSchemeNum);
                    if (null == params || !filter.filter(params)) continue;
                    Set<Long> dataSet = InvBizDataCtrlHelper.getCtrlDataByScheme(params, dataCtrlSchemeNum, filter);
                    if (null != dataSet && dataSet.contains(-1L)) {
                        return this.noData();
                    }
                    allDataSet = this.retainAll(allDataSet, dataSet);
                }
            }
            return allDataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> noData() {
        return Collections.singleton(-1L);
    }

    private Set<Long> retainAll(Set<Long> allDataSet, Set<Long> dataSet) {
        if (null == dataSet || dataSet.isEmpty()) {
            return allDataSet;
        }
        if (allDataSet.isEmpty()) {
            return new HashSet<Long>(dataSet);
        }
        if (dataSet.contains(-1L)) {
            return dataSet;
        }
        if (allDataSet.contains(-1L)) {
            return allDataSet;
        }
        allDataSet.retainAll(dataSet);
        if (allDataSet.isEmpty()) {
            return Collections.singleton(-1L);
        }
        return allDataSet;
    }

    private DynamicObject loadDataCtrlStrategy(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_datactrlstrategy", (String)"bizbill,ctrlField,entryentity.leftbracket,entryentity.datactrlscheme,entryentity.rightbracket,entryentity.logic", (QFilter[])qFilter.toArray());
    }

    public InvBizDataCtrlHelper addFilter(DataCtrlSchemeResultHandle resultHandle) {
        if (null == resultHandle || CollectionUtils.isEmpty(resultHandle.supportDataCtrlNum())) {
            return this;
        }
        for (String dataCtrlNum : resultHandle.supportDataCtrlNum()) {
            List<DataCtrlSchemeResultHandle> filterList = this.filterMap.get(dataCtrlNum);
            if (filterList == null) {
                filterList = new ArrayList<DataCtrlSchemeResultHandle>(4);
                this.filterMap.put(dataCtrlNum, filterList);
            }
            filterList.add(resultHandle);
        }
        return this;
    }

    public Set<Long> getDataByUser(List<Long> orgIds, Long strategyId) {
        try {
            Long userId = UserServiceHelper.getCurrentUserId();
            List<Long> operatorGrp = this.getOperatorGroupByOrg(orgIds);
            Set<Long> operatorIds = this.getOperatorIds(orgIds, userId, operatorGrp);
            if (operatorIds.isEmpty()) {
                return Collections.emptySet();
            }
            HashMap<String, Collection<Long>> param = new HashMap<String, Collection<Long>>(4);
            param.put("org", orgIds);
            param.put("operator", operatorIds);
            param.put("operatorgroup", operatorGrp);
            param.put("dept", UserServiceHelper.getAllDepartmentByUserId((long)userId));
            HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>(4);
            DynamicObject strategyDym = this.loadDataCtrlStrategy(strategyId);
            if (null == strategyDym) {
                return Collections.emptySet();
            }
            DynamicObjectCollection entryRows = strategyDym.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryRows) {
                paramMap.put(entryRow.getString("datactrlscheme.number"), param);
            }
            return this.getDataByDataCtrl(paramMap, strategyDym);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> getOperatorIds(List<Long> orgIds, Long userId, List<Long> operatorGrp) {
        DynamicObjectCollection operators;
        QFilter qFilter = new QFilter("operatorid", "=", (Object)userId);
        qFilter.and(new QFilter("opergrptype", "=", (Object)"KCZ"));
        if (CollectionUtils.isNotEmpty(operatorGrp)) {
            qFilter.and(new QFilter("operatorgrpid", "in", operatorGrp));
        }
        if ((operators = QueryServiceHelper.query((String)"bd_operator", (String)"id", (QFilter[])qFilter.toArray())).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> operatorIds = new HashSet<Long>(operators.size());
        for (DynamicObject operator : operators) {
            operatorIds.add(operator.getLong("id"));
        }
        return operatorIds;
    }

    private List<Long> getOperatorGroupByOrg(List<Long> orgIdList) {
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIdList, (boolean)true);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)"KCZ");
        qFilter2.and("enable", "=", (Object)"1");
        QFilter operatorFilter = new QFilter("entryentity.operator.enable", "=", (Object)"1");
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2, operatorFilter});
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(map.values());
        ArrayList<Long> operatorGroupList = new ArrayList<Long>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
        }
        return operatorGroupList;
    }
}

