/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.grouprelation.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.mpscmm.mscommon.business.helper.PageShowHelper;
import kd.mpscmm.mscommon.business.strategy.BaseDataStrategy;
import kd.mpscmm.mscommon.business.strategy.TypeSelectStategy;
import kd.mpscmm.mscommon.common.utils.ColsTreeUtil;
import kd.mpscmm.mscommon.common.utils.FormUtil;
import kd.mpscmm.mscommon.template.form.AbstractMSCBillPlugin;

public class DataGroupRelationEdit
extends AbstractMSCBillPlugin
implements BeforeF7SelectListener {
    private static final String LONGNUMBERKEY_CB = "longNumberKeyClickCB";
    private static final String GROUPKEY_CB = "groupKeyClickCB";
    private static final String DATAKEY_CB = "dataKeyClickCB";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"datakey", "groupkey", "longnumberkey"});
        FormUtil.addF7Listener(this, "dataobj", "groupobj", "relationobj");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisbleByRelation((String)this.getModel().getValue("relationtype"));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "datakey": {
                this.dataKeyClick();
                break;
            }
            case "groupkey": {
                this.groupKeyClick();
                break;
            }
            case "longnumberkey": {
                this.longNumberKeyClick();
                break;
            }
        }
    }

    private void longNumberKeyClick() {
        String number = ((DynamicObject)this.getValue("groupobj")).getString("number");
        IDataEntityProperty property = this.getModel().getDataEntityType().findProperty("longnumberkey");
        PageShowHelper.showColsTreePage(this.getView(), number, new TypeSelectStategy(property), new CloseCallBack((IFormPlugin)this, LONGNUMBERKEY_CB), null);
    }

    private void dataKeyClick() {
        String relationType = ((DynamicObject)this.getValue("relationobj")).getString("number");
        String dataObjType = ((DynamicObject)this.getValue("dataobj")).getString("number");
        PageShowHelper.showColsTreePage(this.getView(), relationType, new BaseDataStrategy(dataObjType), new CloseCallBack((IFormPlugin)this, DATAKEY_CB), null);
    }

    private void groupKeyClick() {
        String groupObjType = ((DynamicObject)this.getValue("groupobj")).getString("number");
        String objType = null;
        String relationType = (String)this.getValue("relationtype");
        if ("in".equals(relationType)) {
            objType = ((DynamicObject)this.getValue("dataobj")).getString("number");
        } else if ("out".equals(relationType)) {
            objType = ((DynamicObject)this.getValue("relationobj")).getString("number");
        } else {
            return;
        }
        PageShowHelper.showColsTreePage(this.getView(), objType, new BaseDataStrategy(groupObjType), new CloseCallBack((IFormPlugin)this, GROUPKEY_CB), null);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "dataKeyClickCB": {
                this.colsFieldCallBack(e, "datakey");
                break;
            }
            case "groupKeyClickCB": {
                this.colsFieldCallBack(e, "groupkey");
                break;
            }
            case "longNumberKeyClickCB": {
                this.colsFieldCallBack(e, "longnumberkey");
                break;
            }
        }
    }

    private void colsFieldCallBack(ClosedCallBackEvent e, String fillKey) {
        IDataModel model = this.getModel();
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            model.setValue(fillKey, null);
            return;
        }
        JSONObject info = data.getJSONObject(0);
        model.setValue(fillKey, (Object)info.getString("id"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (key) {
            case "relationtype": {
                this.changRelationType(changeSet);
                break;
            }
        }
    }

    private void changRelationType(ChangeData[] changeSet) {
        for (ChangeData data : changeSet) {
            String newValue = (String)data.getNewValue();
            this.getModel().setValue("relationobj", null);
            this.getModel().setValue("datakey", null);
            this.getModel().setValue("groupkey", null);
            this.setVisbleByRelation(newValue);
        }
    }

    private void setVisbleByRelation(String newValue) {
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupkey", "datakey", "relationobj"});
        } else if ("out".equals(newValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"groupkey", "datakey", "relationobj"});
        } else if ("in".equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datakey", "relationobj"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"groupkey"});
        }
    }
}

