/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.common;

import java.io.Serializable;
import java.util.WeakHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReportGlobalParam
implements Serializable {
    private static final long serialVersionUID = -8038788924792875640L;
    private static final WeakHashMap<String, ReportGlobalParam> CFG_CACHE = new WeakHashMap();
    private int exportLimit = 1000000;
    private int queryLimit = 100000;
    private int requestLimit = 100;
    private boolean enableLog;
    private long verion;
    private static final String ENTITY = "scmc_rpt_param";
    private static final String CACHE_KEY = "scmc_rpt_param";
    private static final Log LOG = LogFactory.getLog(ReportGlobalParam.class);

    static ReportGlobalParam loadParam() {
        ReportGlobalParam param = new ReportGlobalParam();
        DynamicObject info = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"scmc_rpt_param");
        if (info != null) {
            ReportGlobalParam.setVal(info, param);
        }
        return param;
    }

    private static void setVal(DynamicObject info, ReportGlobalParam param) {
        boolean boolVal;
        int val = info.getInt("exportlimit");
        if (val > 0) {
            param.exportLimit = val;
        }
        if ((val = info.getInt("querylimit")) > 0) {
            param.queryLimit = val;
        }
        if ((val = info.getInt("requestlimit")) > 0) {
            param.requestLimit = val;
        }
        param.enableLog = boolVal = info.getBoolean("enablelog");
    }

    public static ReportGlobalParam getParam() {
        try {
            String accId = CacheKeyUtil.getAcctId();
            ReportGlobalParam param = CFG_CACHE.get(accId);
            IAppCache cache = AppCache.get((String)"mscommon");
            Long ver = (Long)cache.get("scmc_rpt_param", Long.class);
            if (ver == null) {
                param = ReportGlobalParam.loadParam();
                CFG_CACHE.put(accId, param);
                param.verion = DB.genGlobalLongId();
                cache.put("scmc_rpt_param", (Object)param.verion);
            } else if (param == null || param.verion != ver) {
                param = ReportGlobalParam.loadParam();
                CFG_CACHE.put(accId, param);
                param.verion = ver;
            }
            return param;
        }
        catch (Throwable e) {
            LOG.error(e);
            return new ReportGlobalParam();
        }
    }

    private ReportGlobalParam() {
    }

    public int getExportLimit() {
        return this.exportLimit;
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public int getRequestLimit() {
        return this.requestLimit;
    }

    public boolean isEnableLog() {
        return this.enableLog;
    }
}

