/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.conf.form;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ColMapUtil {
    public static MainEntityType getMainEntityType(IDataModel model, String fieldName) {
        DynamicObject entity = model.getDataEntity().getDynamicObject(fieldName);
        if (entity == null) {
            IDataEntityProperty pro = model.getDataEntityType().findProperty(fieldName);
            String proName = ColMapUtil.getProName(pro);
            throw new KDBizException(ResManager.loadKDString((String)"\u5148\u9009\u62e9\u201c{0}\u201d\u3002", (String)"ColMapUtil_0", (String)"mpscmm-mscommon-report", (Object[])new Object[]{proName}));
        }
        String number = entity.getString("id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)number);
        if (type == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u201c{0}\u201d\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"ColMapUtil_1", (String)"mpscmm-mscommon-report", (Object[])new Object[]{fieldName}));
        }
        return type;
    }

    private static void throwColNotExist(MainEntityType entity, String col) {
        String type = entity.getName();
        throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u201c{0}\u201d\uff0c\u627e\u4e0d\u5230\u5b57\u6bb5\u201c{1}\u201d\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u662f\u5426\u5b58\u5728\u6216\u5f15\u7528\u5c5e\u6027\u662f\u5426\u6b63\u786e\u3002", (String)"ColMapUtil_2", (String)"mpscmm-mscommon-report", (Object[])new Object[]{type, col}));
    }

    public static void checkExist(MainEntityType entity, String col) {
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        if (pro == null) {
            ColMapUtil.throwColNotExist(entity, col);
        }
        if (proCols.length > 1) {
            BasedataProp basePro = null;
            for (int i = 1; i < proCols.length; ++i) {
                if (pro instanceof BasedataProp) {
                    basePro = (BasedataProp)pro;
                    MainEntityType type = MetadataServiceHelper.getDataEntityType((String)basePro.getBaseEntityId());
                    if ((pro = type.findProperty(proCols[i])) != null) continue;
                    ColMapUtil.throwColNotExist(entity, col);
                    continue;
                }
                if (!(pro instanceof EntryProp)) break;
                pro = entity.findProperty(proCols[i]);
                if (pro != null) continue;
                ColMapUtil.throwColNotExist(entity, col);
            }
        }
    }

    public static String getColFullName(MainEntityType entity, String col) {
        if (StringUtils.isBlank((CharSequence)col)) {
            return null;
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        if (pro == null) {
            return ColMapUtil.notExistCol(col);
        }
        StringBuilder name = new StringBuilder(ColMapUtil.getFullName(pro.getParent(), ColMapUtil.getProName(pro)));
        if (proCols.length > 1) {
            BasedataProp basePro = null;
            for (int i = 1; i < proCols.length; ++i) {
                if (pro instanceof BasedataProp) {
                    basePro = (BasedataProp)pro;
                    MainEntityType type = MetadataServiceHelper.getDataEntityType((String)basePro.getBaseEntityId());
                    if ((pro = type.findProperty(proCols[i])) == null) {
                        return ColMapUtil.notExistCol(col);
                    }
                    name.append('.').append(ColMapUtil.getProName(pro));
                    continue;
                }
                if (!(pro instanceof EntryProp)) break;
                pro = entity.findProperty(proCols[i]);
                if (pro == null) {
                    return ColMapUtil.notExistCol(col);
                }
                name.append('.').append(ColMapUtil.getProName(pro));
            }
        }
        return name.toString();
    }

    private static String getProName(IDataEntityProperty pro) {
        return "id".equals(pro.getName()) ? ResManager.loadKDString((String)"ID", (String)"ColMapUtil_3", (String)"mpscmm-mscommon-report", (Object[])new Object[0]) : pro.getDisplayName().getLocaleValue();
    }

    private static String getFullName(IDataEntityType parent, String colName) {
        if (parent instanceof MainEntityType) {
            return colName;
        }
        return ColMapUtil.getFullName(parent.getParent(), parent.getDisplayName().getLocaleValue() + "." + colName);
    }

    public static String notExistCol(String col) {
        return ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u3002", (String)"ColMapUtil_4", (String)"mpscmm-mscommon-report", (Object[])new Object[]{col});
    }

    public static String getFullCol(MainEntityType srcEntity, String col) {
        block3: {
            IDataEntityProperty pro;
            String simpleName = col;
            int index = col.indexOf(".");
            if (index > 0) {
                simpleName = col.substring(0, index);
            }
            if ((pro = srcEntity.findProperty(simpleName)) == null) {
                return ColMapUtil.notExistCol(col);
            }
            IDataEntityType parent = null;
            int count = 0;
            do {
                IDataEntityType iDataEntityType = parent = parent == null ? pro.getParent() : parent.getParent();
                if (parent instanceof MainEntityType) break block3;
                col = parent.getName() + "." + col;
                simpleName = parent.getName() + "." + simpleName;
            } while (++count <= 4);
            throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u5faa\u73af\u89e3\u6790\u8d85\u8fc74\u5c42\uff0c\u4e0d\u80fd\u518d\u89e3\u6790\u3002", (String)"ColMapUtil_5", (String)"mpscmm-mscommon-report", (Object[])new Object[]{col}));
        }
        return col;
    }
}

