/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.conf.form;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class RptColFsEdit
extends AbstractFormPlugin {
    private static final String GRID_AP = "fsset";
    private static final String P_ENTITY = "entity";
    private static final String P_CONDITION = "condition";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "sure"});
    }

    public void afterBindData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String entityName = (String)param.getCustomParam(P_ENTITY);
        this.initGrid(entityName, GRID_AP, this.getCondition(param));
    }

    private FilterCondition getCondition(FormShowParameter param) {
        String conditionStr = (String)param.getCustomParam(P_CONDITION);
        if (StringUtils.isNotBlank((CharSequence)conditionStr)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionStr, CRCondition.class);
            return condition.getFilterCondition();
        }
        return null;
    }

    private void initGrid(String entityName, String gridName, FilterCondition condition) {
        condition = condition == null ? new FilterCondition() : condition;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(gridName);
        filterGrid.SetValue(condition);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            GetFilterFieldsParameter param = new GetFilterFieldsParameter((IDataEntityType)entityType);
            param.setNeedFieldCompareType(false);
            param.setNeedAliasEmptyFieldProp(false);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)param));
        }
        this.getView().updateView(gridName);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cancel": {
                this.cancel();
                break;
            }
            case "sure": {
                this.sure();
                break;
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void sure() {
        MainEntityType mainType;
        FilterBuilder filterBuilder;
        String[] scripts;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(GRID_AP);
        FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
        CRCondition crCondition = new CRCondition();
        crCondition.setFilterCondition(condition);
        FormShowParameter param = this.getView().getFormShowParameter();
        String entityName = (String)param.getCustomParam(P_ENTITY);
        if (StringUtils.isNotBlank((CharSequence)entityName) && (scripts = (filterBuilder = new FilterBuilder(mainType = MetadataServiceHelper.getDataEntityType((String)entityName), condition)).buildFilterScript()) != null && scripts.length >= 2 && scripts[1] != null) {
            crCondition.setExprTran(scripts[1]);
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)crCondition));
        this.getView().close();
    }
}

