/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SingleOrgContextHelper;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;

public class FilterHandle
extends EntityTypeUtil {
    private static Log logger = LogFactory.getLog(FilterHandle.class);

    public List<FilterField> getFilterFields(boolean bCompatibleProductMode, IDataEntityType dataEntityType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        MainEntityType mainType = (MainEntityType)dataEntityType;
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            IDataEntityType parentType;
            if (!(fieldProp instanceof IFieldHandle) || null != (parentType = fieldProp.getParent()) && parentType instanceof LinkEntryType || bCompatibleProductMode && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)fieldProp)) continue;
            List list = ((IFieldHandle)fieldProp).createFilterFields(mainType);
            if (bCompatibleProductMode) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    FilterField ff = (FilterField)it.next();
                    IDataEntityProperty ref1 = ff.getRefProp1();
                    IDataEntityProperty ref2 = ff.getRefProp2();
                    if ((ref1 == null || !SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref1)) && (ref2 == null || !SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref2))) continue;
                    it.remove();
                }
            }
            filterFields.addAll(list);
        }
        return filterFields;
    }

    public List<FilterField> getFilterFields(boolean bCompatibleProductMode, IDataEntityType dataEntityType, boolean isOnlyMainEntityField) {
        logger.info("\u8fdb\u5165FilterHandle.getFilterFields(boolean, IDataEntityType, boolean)\uff0centity={}", (Object)dataEntityType.getName());
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        MainEntityType mainType = (MainEntityType)dataEntityType;
        ArrayList blackFields = new ArrayList();
        if (bCompatibleProductMode) {
            ProductSettingService pService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
            blackFields.addAll(pService.getFormDisVisitField(dataEntityType.getName()));
        }
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            if (!(fieldProp instanceof IFieldHandle)) continue;
            boolean isFilterField = true;
            IDataEntityType parentType = fieldProp.getParent();
            if (null != parentType && parentType instanceof LinkEntryType || bCompatibleProductMode && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)fieldProp)) continue;
            if (isOnlyMainEntityField && !(parentType instanceof MainEntityType)) {
                isFilterField = false;
            }
            if (!isFilterField) continue;
            List list = ((IFieldHandle)fieldProp).createFilterFields(mainType);
            if (bCompatibleProductMode) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    FilterField ff = (FilterField)it.next();
                    IDataEntityProperty ref1 = ff.getRefProp1();
                    IDataEntityProperty ref2 = ff.getRefProp2();
                    if (ref1 != null && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref1) || ref2 != null && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref2)) {
                        it.remove();
                    }
                    if (blackFields.isEmpty() || ff.getSrcFieldProp() == null || !blackFields.contains(String.valueOf(ff.getSrcFieldProp().getName()))) continue;
                    it.remove();
                }
            }
            filterFields.addAll(list);
        }
        return filterFields;
    }
}

