/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bplat.scmc.report.common.QueryType;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;

class QueryApply
implements AutoCloseable {
    private Object applyId;
    private static final String ENTITY = "scmc_rpt_request";
    private static final String ID = "id";

    QueryApply() {
    }

    public int apply(ReportDataCtx ctx) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(new Date());
        Date now = cd.getTime();
        DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
        info.set(ID, (Object)DB.genGlobalLongId());
        info.set("createdate", (Object)now);
        info.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
        info.set("type", (Object)(ctx.getQueryType() == null ? "" : ctx.getQueryType().getType()));
        ReportConf conf = ctx.getReportConf();
        info.set("repconf", conf.getId());
        cd.add(12, conf.getTimeOut());
        info.set("timeout", (Object)cd.getTime());
        QFilter fs = new QFilter("timeout", ">", (Object)now);
        int requestLimit = ctx.getGlobalParam().getRequestLimit();
        DataSet data = QueryServiceHelper.queryDataSet((String)"QueryApply.apply", (String)ENTITY, (String)"id,repconf,creater", (QFilter[])fs.toArray(), null, (int)requestLimit);
        int userReqCount = 0;
        int rptReqCount = 0;
        int sumReqCount = 0;
        for (Row row : data) {
            ++sumReqCount;
            if (RequestContext.getOrCreate().getCurrUserId() == row.getLong("creater").longValue() && conf.getId().equals(row.get("repconf"))) {
                ++userReqCount;
            }
            if (!conf.getId().equals(row.get("repconf"))) continue;
            ++rptReqCount;
        }
        if (QueryType.CODE_API != ctx.getQueryType() && userReqCount >= this.getParallelCount()) {
            return 1;
        }
        if (conf.getReqLimit() > 0 && rptReqCount >= conf.getReqLimit()) {
            return 2;
        }
        if (sumReqCount >= requestLimit || rptReqCount >= requestLimit) {
            return 3;
        }
        try (TXHandle tx = TX.requiresNew((String)"QueryApply.apply");){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            this.applyId = info.getPkValue();
        }
        return 0;
    }

    private int getParallelCount() {
        DBRoute route = new DBRoute("scm");
        try (DataSet paramSet = DB.queryDataSet((String)"getParallelCount", (DBRoute)route, (String)"select fvalue from t_im_invdbparam where fkey = 'rptUserReqCount'");){
            Iterator iterator = paramSet.iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                int n = Integer.parseInt(row.getString("fvalue"));
                return n;
            }
            int n = 1;
            return n;
        }
    }

    @Override
    public void close() {
        if (this.applyId != null) {
            try (TXHandle tx = TX.requiresNew((String)"QueryApply.close");){
                DeleteServiceHelper.delete((String)ENTITY, (QFilter[])new QFilter(ID, "=", this.applyId).toArray());
            }
        }
    }
}

