/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DataSetDataType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterEvaluator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bplat.scmc.report.common.QueryType;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.JoinBlockConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.RptBlockConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ColAlias;
import kd.bplat.scmc.report.core.EntityInfo;
import kd.bplat.scmc.report.core.FsSplitListener;
import kd.bplat.scmc.report.core.QFilterEval;
import kd.bplat.scmc.report.core.QueryApply;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.RptSqlParser;
import kd.bplat.scmc.report.core.tpl.DataSetOutputHandle;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IOutputHandle;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.Bool2StrTransform;
import kd.bplat.scmc.report.core.transform.GroupTransform;
import kd.bplat.scmc.report.core.transform.RowSumTransform;
import kd.bplat.scmc.report.core.transform.func.AsNameFunc;
import kd.bplat.scmc.report.core.transform.func.LimitDataCount;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.bplat.scmc.report.core.transform.plan.RowSumPlan;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.bplat.scmc.report.util.TransformUtil;
import org.apache.commons.lang3.StringUtils;

public class ReportDataHandle {
    private static final Log LOG = LogFactory.getLog(ReportDataHandle.class);

    public static ReportConf loadReportConf(String reportEntity) {
        DynamicObject model = ReportDataHandle.loadConfModel(reportEntity);
        return ReportDataHandle.loadReportConf(model);
    }

    public static ReportConf loadReportConf(DynamicObject model) {
        ReportConf conf = new ReportConf();
        conf.setId(model.getPkValue());
        conf.setReportEntity(model.getDynamicObject("report").getString("id"));
        conf.setRepoEntity(model.getDynamicObject("repo").getString("id"));
        conf.setTimeOut(model.getInt("timeout"));
        conf.setReqLimit(model.getInt("reqlimit"));
        conf.setBigTableColConf(ReportDataHandle.parseBigTableColConf(model));
        ReportDataHandle.handleRefNames(conf);
        conf.setPlugins(ReportDataHandle.parsePlugins(model));
        ReportDataHandle.parseBigTableColType(conf);
        conf.setSrcBlockConf(ReportDataHandle.parseSrcBlockConf(model));
        conf.setJoinBlockConf(ReportDataHandle.parseJoinBlockConf(model));
        ReportDataHandle.parseDefVals(conf);
        return conf;
    }

    private static void handleRefNames(ReportConf conf) {
        String repoEntity = conf.getRepoEntity();
        MainEntityType repoType = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        List<BigTableColConf> colConfs = conf.getBigTableColConf();
        List<String> showRefProps = null;
        TreeNode treeNode = null;
        List<String> refProps = null;
        TreeNode node = null;
        HashMap<String, String> names = null;
        for (BigTableColConf colConf : colConfs) {
            showRefProps = colConf.getShowRefProps();
            if (showRefProps == null || showRefProps.isEmpty()) continue;
            treeNode = ReportUtil.buildRefColTree(repoType, colConf.getCol());
            if (treeNode == null) {
                colConf.setShowRefProps(null);
                colConf.setRefPropNames(null);
                continue;
            }
            refProps = colConf.getShowRefProps();
            names = new HashMap<String, String>(refProps.size());
            for (String refProp : refProps) {
                node = treeNode.getTreeNode(refProp, 10);
                if (node == null) continue;
                names.put(refProp, node.getText());
            }
            colConf.setRefPropNames(names);
        }
    }

    private static List<IReportDataHandle> parsePlugins(DynamicObject model) {
        DynamicObjectCollection pluginInfos = model.getDynamicObjectCollection("pluginentry");
        ArrayList<IReportDataHandle> plugins = new ArrayList<IReportDataHandle>(pluginInfos.size());
        String className = null;
        try {
            for (DynamicObject pluginInfo : pluginInfos) {
                if (!pluginInfo.getBoolean("pluginstatus")) continue;
                className = pluginInfo.getString("pluginclass");
                Class<?> pluginClass = Class.forName(className);
                plugins.add((IReportDataHandle)pluginClass.newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u201c{0}\u201d\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u63d2\u4ef6\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3\u201c{1}\u201d\uff0c\u8bf7\u68c0\u67e5\u62a5\u8868\u914d\u7f6e\u3002", (String)"ReportDataHandle_0", (String)"mpscmm-mscommon-report", (Object[])new Object[]{className, IReportDataHandle.class.getName()}));
        }
        return plugins;
    }

    private static void parseDefVals(ReportConf conf) {
        Map<String, DataType> dataTypes = conf.getDataTypeMap();
        List<SrcBlockConf> blocks = conf.getSrcBlockConf();
        Map<String, Object> defVals = null;
        String valStr = null;
        String key = null;
        for (SrcBlockConf block : blocks) {
            defVals = block.getDefVals();
            for (Map.Entry<String, Object> entry : defVals.entrySet()) {
                key = entry.getKey();
                valStr = (String)entry.getValue();
                if ("null".equalsIgnoreCase(valStr)) {
                    entry.setValue(null);
                    continue;
                }
                entry.setValue(TransformUtil.getDefVal(dataTypes.get(key), valStr));
            }
        }
    }

    private static void parseBigTableColType(ReportConf conf) {
        String repoEntity = conf.getRepoEntity();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        List<BigTableColConf> colConfs = conf.getBigTableColConf();
        String col = null;
        IDataEntityProperty pro = null;
        HashMap<String, DataType> dataTypes = new HashMap<String, DataType>(32);
        for (BigTableColConf colConf : colConfs) {
            col = colConf.getCol();
            pro = mainEntityType.findProperty(col);
            if (pro instanceof IComplexProperty) {
                pro = ((IComplexProperty)pro).getComplexType().getPrimaryKey();
            }
            colConf.setDataType(DataSetDataType.getDataType((Class)pro.getPropertyType()));
            dataTypes.put(col, colConf.getDataType());
        }
        conf.setDataTypeMap(dataTypes);
    }

    public static DynamicObject loadConfModel(String reportEntity) {
        QFilter fs = new QFilter("report", "=", (Object)reportEntity).and("status", "=", (Object)"1");
        Map confInfo = BusinessDataReader.loadFromCache((String)"scmc_report_conf", (QFilter[])fs.toArray());
        if (!confInfo.isEmpty()) {
            DynamicObject[] cfs = confInfo.values().toArray(new DynamicObject[0]);
            return cfs[0];
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bfb\u53d6\u5230\u542f\u7528\u7684\u62a5\u8868\u914d\u7f6e\u3002", (String)"ReportDataHandle_1", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
    }

    private static List<BigTableColConf> parseBigTableColConf(DynamicObject model) {
        String repoEntity = model.getDynamicObject("repo").getString("id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        DynamicObjectCollection colConfRows = model.getDynamicObjectCollection("colsentry");
        ArrayList<BigTableColConf> colConfs = new ArrayList<BigTableColConf>(colConfRows.size());
        String repoCol = null;
        for (DynamicObject colConfInfo : colConfRows) {
            repoCol = colConfInfo.getString("repo_col");
            if (type.findProperty(repoCol) == null) continue;
            colConfs.add(new BigTableColConf(colConfInfo));
        }
        return colConfs;
    }

    private static List<JoinBlockConf> parseJoinBlockConf(DynamicObject model) {
        DynamicObjectCollection queryConfRows = model.getDynamicObjectCollection("joinentry");
        ArrayList<JoinBlockConf> queryConfs = new ArrayList<JoinBlockConf>(queryConfRows.size());
        Map<Object, QFilter> fsMap = ReportDataHandle.parseQueryFs(model.getString("repo.id"), queryConfRows);
        Map<Object, DynamicObject> joinEntityInfos = ReportDataHandle.parseJoinEntityInfo(queryConfRows);
        JoinBlockConf blockConf = null;
        Object blockId = null;
        List<ColMapInfo> colInfos = null;
        HashMap<String, String> repoColSrcColMap = null;
        HashMap<String, Object> defValMap = null;
        int size = 0;
        RptSqlParser parser = new RptSqlParser();
        Set<String> allSelectCols = null;
        DynamicObject joinInfo = null;
        for (DynamicObject queryConfInfo : queryConfRows) {
            if (!queryConfInfo.getBoolean("joinblockstatus")) continue;
            blockConf = new JoinBlockConf();
            blockConf.setDataFs(fsMap.get(queryConfInfo.getPkValue()));
            blockId = queryConfInfo.getDynamicObject("joinentity").getPkValue();
            joinInfo = joinEntityInfos.get(blockId);
            colInfos = ReportDataHandle.parseJoinColMap(joinInfo);
            String entitySql = joinInfo.getString("sqlinfo_tag");
            parser.parseSqlInfo(entitySql);
            allSelectCols = parser.getAllSelectCols();
            size = colInfos.size();
            repoColSrcColMap = new HashMap<String, String>(size);
            defValMap = new HashMap<String, Object>(size);
            for (ColMapInfo info : colInfos) {
                if (StringUtils.isNotBlank((CharSequence)info.col)) {
                    if (!allSelectCols.contains(info.col)) continue;
                    repoColSrcColMap.put(info.repoCol, info.col);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)((String)info.defVal))) continue;
                defValMap.put(info.repoCol, info.defVal);
            }
            blockConf.setRepoColSrcColMap(repoColSrcColMap);
            blockConf.setRepoColFullSrcColMap(parser.buildRepoColFullSrcColMap(repoColSrcColMap));
            blockConf.setColEntityMap(parser.buildColEntityMap(repoColSrcColMap));
            blockConf.setDefVals(defValMap);
            blockConf.setEntityInfos(parser.getEntityInfos());
            blockConf.setEntitySql(parser.getReBuildSql());
            blockConf.setLoadType(joinInfo.getString("loadtype"));
            queryConfs.add(blockConf);
        }
        return queryConfs;
    }

    private static Map<Object, DynamicObject> parseJoinEntityInfo(DynamicObjectCollection queryConfRows) {
        HashSet<Object> colMapId = new HashSet<Object>(queryConfRows.size());
        for (DynamicObject queryConfRow : queryConfRows) {
            colMapId.add(queryConfRow.getDynamicObject("joinentity").getPkValue());
        }
        return BusinessDataReader.loadFromCache((String)"scmc_rpt_joinentity", (QFilter[])new QFilter("id", "in", colMapId).toArray());
    }

    private static Map<Object, QFilter> parseQueryFs(String repoEntity, DynamicObjectCollection queryConfRows) {
        if (StringUtils.isBlank((CharSequence)repoEntity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7f3a\u5c11\u5b57\u6bb5\u5e93", (String)"ReportDataHandle_2", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        }
        HashMap<Object, QFilter> fsMap = new HashMap<Object, QFilter>(queryConfRows.size());
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        String fsStr = null;
        CRCondition crCondition = null;
        FilterBuilder filterBuilder = null;
        for (DynamicObject queryConfRow : queryConfRows) {
            fsStr = queryConfRow.getString("joindatafs_tag");
            if (!StringUtils.isNotBlank((CharSequence)fsStr)) continue;
            crCondition = (CRCondition)SerializationUtils.fromJsonString((String)fsStr, CRCondition.class);
            filterBuilder = new FilterBuilder(type, crCondition.getFilterCondition());
            filterBuilder.buildFilter();
            fsMap.put(queryConfRow.getPkValue(), filterBuilder.getQFilter());
        }
        return fsMap;
    }

    private static List<SrcBlockConf> parseSrcBlockConf(DynamicObject model) {
        String repoEntity = model.getDynamicObject("repo").getString("id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        DynamicObjectCollection srcConfRows = model.getDynamicObjectCollection("srcentry");
        ArrayList<SrcBlockConf> srcConfs = new ArrayList<SrcBlockConf>(srcConfRows.size());
        Map<Object, QFilter> fsMap = ReportDataHandle.parseSrcFs(srcConfRows);
        Map<Object, List<ColMapInfo>> colMaps = ReportDataHandle.parseColMap(srcConfRows);
        SrcBlockConf blockConf = null;
        Object blockId = null;
        List<ColMapInfo> colInfos = null;
        HashMap<String, String> srcColMap = null;
        HashMap<String, String> fullSrcColMap = null;
        HashMap<String, Object> defValMap = null;
        int size = 0;
        for (DynamicObject srcConfInfo : srcConfRows) {
            if (!srcConfInfo.getBoolean("blockstatus")) continue;
            blockConf = new SrcBlockConf();
            blockConf.setType(srcConfInfo.getString("srctype"));
            blockConf.setSrcEntity(srcConfInfo.getDynamicObject("srcentity").getString("id"));
            blockConf.setDataFs(fsMap.get(srcConfInfo.getPkValue()));
            blockId = srcConfInfo.getDynamicObject("colmap").getPkValue();
            colInfos = colMaps.get(blockId);
            size = colInfos.size();
            srcColMap = new HashMap<String, String>(size);
            fullSrcColMap = new HashMap<String, String>(size);
            defValMap = new HashMap<String, Object>(size);
            for (ColMapInfo info : colInfos) {
                if (type.findProperty(info.repoCol) == null) continue;
                if (StringUtils.isNotBlank((CharSequence)info.col)) {
                    srcColMap.put(info.repoCol, info.col);
                    fullSrcColMap.put(info.repoCol, info.fullCol);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)((String)info.defVal))) continue;
                defValMap.put(info.repoCol, info.defVal);
            }
            blockConf.setRepoColSrcColMap(srcColMap);
            blockConf.setRepoColFullSrcColMap(fullSrcColMap);
            blockConf.setDefVals(defValMap);
            srcConfs.add(blockConf);
        }
        return srcConfs;
    }

    private static Map<Object, List<ColMapInfo>> parseColMap(DynamicObjectCollection srcConfRows) {
        HashSet<Object> colMapId = new HashSet<Object>(srcConfRows.size());
        for (DynamicObject srcConfRow : srcConfRows) {
            colMapId.add(srcConfRow.getDynamicObject("colmap").getPkValue());
        }
        Map infos = BusinessDataReader.loadFromCache((String)"scmc_report_colmap", (QFilter[])new QFilter("id", "in", colMapId).toArray());
        HashMap<Object, List<ColMapInfo>> result = new HashMap<Object, List<ColMapInfo>>(infos.size());
        for (Map.Entry info : infos.entrySet()) {
            result.put(info.getKey(), ReportDataHandle.parseColMap((DynamicObject)info.getValue()));
        }
        return result;
    }

    private static List<ColMapInfo> parseJoinColMap(DynamicObject colMapSet) {
        String jsonStr = colMapSet.getString("mapinfo_tag");
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return Collections.emptyList();
        }
        JSONObject colInfo = JSONObject.parseObject((String)jsonStr);
        JSONArray repoCols = colInfo.getJSONArray("repocol");
        JSONArray srcCols = colInfo.getJSONArray("srccol");
        JSONArray defVals = colInfo.getJSONArray("defval");
        ArrayList<ColMapInfo> infos = new ArrayList<ColMapInfo>(repoCols.size());
        int len = repoCols.size();
        for (int i = 0; i < len; ++i) {
            infos.add(new ColMapInfo(repoCols.getString(i), srcCols.getString(i), null, defVals.getString(i)));
        }
        return infos;
    }

    private static List<ColMapInfo> parseColMap(DynamicObject colMapSet) {
        String jsonStr = colMapSet.getString("mapinfo_tag");
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return Collections.emptyList();
        }
        JSONObject colInfo = JSONObject.parseObject((String)jsonStr);
        JSONArray repoCols = colInfo.getJSONArray("repocol");
        JSONArray srcCols = colInfo.getJSONArray("srccol");
        JSONArray fullSrcCols = colInfo.getJSONArray("fullsrccol");
        JSONArray defVals = colInfo.getJSONArray("defval");
        ArrayList<ColMapInfo> infos = new ArrayList<ColMapInfo>(repoCols.size());
        int len = repoCols.size();
        for (int i = 0; i < len; ++i) {
            infos.add(new ColMapInfo(repoCols.getString(i), srcCols.getString(i), fullSrcCols.getString(i), defVals.getString(i)));
        }
        return infos;
    }

    private static Map<Object, QFilter> parseSrcFs(DynamicObjectCollection srcConfRows) {
        HashMap<Object, QFilter> fsMap = new HashMap<Object, QFilter>(srcConfRows.size());
        HashMap<String, MainEntityType> types = new HashMap<String, MainEntityType>(srcConfRows.size());
        String entity = null;
        MainEntityType type = null;
        String fsStr = null;
        CRCondition crCondition = null;
        FilterBuilder filterBuilder = null;
        for (DynamicObject srcConfRow : srcConfRows) {
            fsStr = srcConfRow.getString("datafs_tag");
            if (!StringUtils.isNotBlank((CharSequence)fsStr)) continue;
            entity = srcConfRow.getDynamicObject("srcentity").getString("id");
            type = (MainEntityType)types.get(entity);
            if (type == null) {
                type = MetadataServiceHelper.getDataEntityType((String)entity);
                types.put(entity, type);
            }
            crCondition = (CRCondition)SerializationUtils.fromJsonString((String)fsStr, CRCondition.class);
            filterBuilder = new FilterBuilder(type, crCondition.getFilterCondition());
            filterBuilder.buildFilter();
            fsMap.put(srcConfRow.getPkValue(), filterBuilder.getQFilter());
        }
        return fsMap;
    }

    private static QFilter buildUserFilter(ReportDataCtx ctx, RptBlockConf block) {
        List<QFilter> permFs;
        QFilter userFs;
        List<QFilter> fixedFilter;
        List<QFilter> pageFilters;
        QFilter result = null;
        ArrayList<QFilter> allFs = new ArrayList<QFilter>();
        QFilter commFilter = ctx.getCommonFs();
        if (commFilter != null) {
            allFs.add(commFilter);
        }
        if ((pageFilters = ctx.getPageFs()) != null) {
            allFs.addAll(pageFilters);
        }
        if ((fixedFilter = ctx.getFixedFs()) != null) {
            allFs.addAll(fixedFilter);
        }
        if ((userFs = block.getUserFs()) != null) {
            allFs.add(userFs);
        }
        if ((permFs = ctx.getPermFs()) != null) {
            allFs.addAll(permFs);
        }
        for (QFilter fs : allFs) {
            result = result == null ? fs.copy() : result.and(fs);
        }
        return result;
    }

    private static Input[] parseInput(Set<String> bigtableFilterCols, SrcBlockConf block, ReportDataCtx ctx) {
        QFilter dataFs;
        ctx.logInfo("==============blockInfo==============");
        ctx.logInfo(block);
        QFilter fs = null;
        QFilter userFilter = ReportDataHandle.buildUserFilter(ctx, block);
        ctx.logInfo("==============userFilter==============");
        ctx.logInfo(userFilter);
        if (userFilter != null) {
            fs = ReportDataHandle.transFs(userFilter.copy(), block);
            ctx.logInfo("==============userFilterAfterTrans==============");
            ctx.logInfo(fs);
            if (fs == null) {
                return null;
            }
        }
        if ((dataFs = block.getDataFs()) != null) {
            fs = fs == null ? dataFs : fs.and(dataFs);
        }
        String selectCols = ReportDataHandle.buildSelectCols(bigtableFilterCols, block, ctx);
        List<QFilter> fsList = ReportDataHandle.segmentQfilter(block.getSplitListen(), fs);
        ctx.logInfo("==============finalFilter==============");
        ctx.logInfo(fsList);
        Input[] inputs = new Input[fsList.size()];
        int len = inputs.length;
        for (int i = 0; i < len; ++i) {
            inputs[i] = new OrmInput("parseInput", block.getSrcEntity(), selectCols, fsList.get(i) == null ? null : fsList.get(i).toArray());
        }
        return inputs;
    }

    private static Set<String> filterBlockSelectCols(Set<String> bigtableFilterCols, RptBlockConf block, ReportDataCtx ctx) {
        HashSet<String> filterCols = new HashSet<String>(bigtableFilterCols);
        ctx.logInfo("==============bigtableFilterCols==============");
        ctx.logInfo(filterCols);
        ReportConf reportConf = ctx.getReportConf();
        if (block instanceof SrcBlockConf) {
            for (IReportDataHandle plugin : reportConf.getPlugins()) {
                plugin.handleBlockDataSelectCols(filterCols, (SrcBlockConf)block, ctx);
            }
        } else if (block instanceof JoinBlockConf) {
            for (IReportDataHandle plugin : reportConf.getPlugins()) {
                plugin.handleBlockDataSelectCols(filterCols, (JoinBlockConf)block, ctx);
            }
        }
        ctx.logInfo("==============bigtableFilterColsAfterPlugin==============");
        ctx.logInfo(filterCols);
        return filterCols;
    }

    private static String buildSelectCols(Set<String> filterCols, SrcBlockConf block, ReportDataCtx ctx) {
        filterCols = ReportDataHandle.filterBlockSelectCols(filterCols, block, ctx);
        Map<String, String> repoColSrcColMap = block.getRepoColFullSrcColMap();
        StringBuilder selectCols = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : repoColSrcColMap.entrySet()) {
            if (!filterCols.contains(entry.getKey())) continue;
            if (i++ != 0) {
                selectCols.append(',');
            }
            selectCols.append(entry.getValue()).append(' ').append(entry.getKey());
        }
        return selectCols.toString();
    }

    private static List<QFilter> segmentQfilter(FsSplitListener listener, QFilter fs) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (listener == null || fs == null) {
            filterList.add(fs);
            return filterList;
        }
        QFilter notSplitFs = null;
        List<QFilter> splitFs = new ArrayList<QFilter>(1);
        QFilter[] recombineFs = fs.recombine();
        for (QFilter singleFs : recombineFs) {
            if (singleFs.getNests(true).size() == 0 && singleFs.getProperty().equals(listener.getSplitKey())) {
                splitFs.add(singleFs);
                continue;
            }
            notSplitFs = notSplitFs == null ? singleFs : notSplitFs.and(singleFs);
        }
        if ((splitFs = ReportDataHandle.handleSplitFs(splitFs, listener)) == null) {
            filterList.add(fs);
        } else {
            for (QFilter newFs : splitFs) {
                newFs.and(notSplitFs);
                filterList.add(newFs);
            }
        }
        return filterList;
    }

    private static List<QFilter> handleSplitFs(List<QFilter> splitFs, FsSplitListener listener) {
        ArrayList<QFilter> fs;
        block13: {
            int size;
            block12: {
                size = splitFs.size();
                fs = null;
                if (size != 1) break block12;
                HashSet<Object> valSet = new HashSet<Object>();
                Object vals = splitFs.get(0).getValue();
                String cp = splitFs.get(0).getCP();
                if (!"in".equals(cp)) break block13;
                if (vals.getClass().isArray()) {
                    Object arr;
                    for (Object obj : arr = (Object[])vals) {
                        valSet.add(obj);
                    }
                } else if (vals instanceof Iterable) {
                    for (Object obj : (Iterable)vals) {
                        valSet.add(obj);
                    }
                }
                if (valSet.isEmpty()) {
                    return null;
                }
                List<Set<Object>> splitResult = listener.splitIdVal(valSet);
                fs = new ArrayList<QFilter>(splitResult.size());
                for (Set set : splitResult) {
                    fs.add(new QFilter(listener.getSplitKey(), cp, (Object)set));
                }
                break block13;
            }
            if (size == 2) {
                String[] cps = new String[2];
                Date[] dates = new Date[2];
                ReportDataHandle.getFromTo(splitFs.get(0), cps, dates);
                ReportDataHandle.getFromTo(splitFs.get(1), cps, dates);
                if (cps[0] == null || cps[1] == null || dates[0] == null || dates[1] == null) {
                    return null;
                }
                dates = listener.splitDateFromTo(dates[0], dates[1]);
                int len = dates.length;
                fs = new ArrayList(len);
                for (int i = 0; i < len - 1; ++i) {
                    if (i == 0) {
                        fs.add(new QFilter(listener.getSplitKey(), cps[0], (Object)dates[i]).and(listener.getSplitKey(), "<=", (Object)dates[i + 1]));
                        continue;
                    }
                    if (i == len - 2) {
                        fs.add(new QFilter(listener.getSplitKey(), ">", (Object)dates[i]).and(listener.getSplitKey(), cps[1], (Object)dates[i + 1]));
                        continue;
                    }
                    fs.add(new QFilter(listener.getSplitKey(), ">", (Object)dates[i]).and(listener.getSplitKey(), "<=", (Object)dates[i + 1]));
                }
            }
        }
        return fs;
    }

    private static void getFromTo(QFilter fs, String[] cps, Date[] dates) {
        String cp = fs.getCP();
        Object val = fs.getValue();
        if (val instanceof Date) {
            if (">".equals(cp) || ">=".equals(cp)) {
                cps[0] = cp;
                dates[0] = (Date)val;
            } else if ("<".equals(cp) || "<=".equals(cp)) {
                cps[1] = cp;
                dates[1] = (Date)val;
            }
        }
    }

    private static QFilter transFs(QFilter fs, RptBlockConf block) {
        QfilterFunction func = new QfilterFunction(block);
        QFilter finalFs = fs.trans((Function)func);
        return !block.isAllowNotMatch() && func.notMatchCol ? null : finalFs;
    }

    public static void doAlgoXJob(ReportDataCtx ctx, IOutputHandle outHandle) {
        if (outHandle == null) {
            throw new KDBizException("ReportDataHandle.doAlgoXJob : IOutputHandle can not be null");
        }
        QueryType type = ctx.getQueryType();
        if (QueryType.RPT_EXPORT == type) {
            ctx.setDataLimit(ctx.getGlobalParam().getExportLimit());
        } else if (QueryType.RPT_QUERY == type) {
            ctx.setDataLimit(ctx.getGlobalParam().getQueryLimit());
        }
        try (QueryApply query = new QueryApply();){
            int apply = query.apply(ctx);
            if (apply == 0) {
                ReportDataHandle.doAlgoXJobAfterApply(ctx, outHandle, type);
            } else {
                if (apply == 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportDataHandle_7", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
                }
                if (apply == 2) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u540c\u4e00\u65f6\u523b\u6240\u6709\u7528\u6237\u67e5\u8be2\u9891\u6b21\u8d85\u8fc7\u5e76\u53d1\u4e0a\u9650\u503c{0}\uff0c\u4e3a\u4fdd\u969c\u7cfb\u7edf\u7a33\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportDataHandle_8", (String)"mpscmm-mscommon-report", (Object[])new Object[]{ctx.getReportConf().getReqLimit()}));
                }
                if (apply == 3) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u65f6\u523b\u6240\u6709\u7528\u6237\u67e5\u8be2\u9891\u6b21\u8d85\u8fc7\u5e76\u53d1\u4e0a\u9650\u503c{0}\uff0c\u4e3a\u4fdd\u969c\u7cfb\u7edf\u7a33\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportDataHandle_5", (String)"mpscmm-mscommon-report", (Object[])new Object[]{ctx.getGlobalParam().getRequestLimit()}));
                }
            }
        }
    }

    private static List<Field> getAlinedCols(ReportDataCtx ctx, Set<String> filterCols) {
        ReportConf conf = ctx.getReportConf();
        List<BigTableColConf> colConfs = conf.getBigTableColConf();
        int size = colConfs.size();
        ArrayList<Field> fields = new ArrayList<Field>(size);
        if (ctx.isShowBlockEntity() || filterCols.contains("block_entity")) {
            fields.add(new Field("block_entity", (DataType)DataType.StringType));
        }
        for (BigTableColConf colConf : colConfs) {
            if (!filterCols.contains(colConf.getCol())) continue;
            fields.add(new Field(colConf.getCol(), colConf.getDataType()));
        }
        return fields;
    }

    private static Set<String> buildAlineColFilter(ReportDataCtx ctx) {
        HashSet<String> filterCols = new HashSet<String>(32);
        filterCols.addAll(ctx.getShowKeyCols());
        filterCols.addAll(ctx.getShowQtyCols());
        ctx.logInfo("==============bigtableCols==============");
        ctx.logInfo(filterCols);
        ReportConf reportConf = ctx.getReportConf();
        for (IReportDataHandle plugin : reportConf.getPlugins()) {
            plugin.handleBigtableCols(filterCols, ctx);
        }
        ctx.logInfo("==============bigtableColsAfterPlugin==============");
        ctx.logInfo(filterCols);
        return filterCols;
    }

    private static Input getEmptyInput(List<Field> fields) {
        return new CollectionInput(new RowMeta(fields.toArray(new Field[0])), Collections.emptyList());
    }

    private static DataSetX alineCols(DataSetX blockData, String asSrcEntity, List<Field> alinedCols) {
        RowMeta rowMeta = blockData.getRowMeta();
        Set<String> dataCols = ReportUtil.getDataCols(rowMeta);
        ArrayList<String> tbCols = new ArrayList<String>(alinedCols.size());
        ArrayList<Field> addFields = new ArrayList<Field>();
        ArrayList<Object> addVals = new ArrayList<Object>();
        String name = null;
        for (Field field : alinedCols) {
            name = field.getName();
            if (dataCols.contains(name)) {
                rowMeta.getField(name).setDataType(field.getDataType());
            } else {
                addFields.add(field);
                addVals.add("block_entity".equals(name) ? asSrcEntity : TransformUtil.getDefVal(field.getDataType()));
            }
            tbCols.add(name);
        }
        if (!addFields.isEmpty()) {
            blockData = blockData.addFields(addFields.toArray(new Field[0]), addVals.toArray());
        }
        return blockData.select(tbCols.toArray(new String[0]));
    }

    public static DataSet queryDataSet(ReportDataCtx ctx) {
        DynamicObject queryLog = ReportDataHandle.initLog(ctx);
        try {
            DataSetOutputHandle handle = new DataSetOutputHandle();
            ReportDataHandle.doAlgoXJob(ctx, handle);
            DataSet result = ctx.getCurrentJob().readDataSet(handle.getOutId());
            result = ReportDataHandle.transformResult(result, ctx);
            ReportDataHandle.buildLog(queryLog, ctx);
            DataSet dataSet = result;
            return dataSet;
        }
        catch (Throwable e) {
            if (queryLog != null) {
                queryLog.set("result", (Object)"0");
            }
            throw e;
        }
        finally {
            ReportDataHandle.saveLog(queryLog);
        }
    }

    private static void throwCanParse(QFilter singleFs) {
        throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6761\u4ef6\u201c{0}\u201d\u65e0\u6cd5\u8f6c\u8bd1\u4e3a\u6570\u636e\u6e90\u6761\u4ef6\uff0c\u8bf7\u5c1d\u8bd5\u8f93\u5165\u5176\u4ed6\u6761\u4ef6\u3002", (String)"ReportDataHandle_4", (String)"mpscmm-mscommon-report", (Object[])new Object[]{singleFs}));
    }

    private static DynamicObject initLog(ReportDataCtx ctx) {
        try {
            DynamicObject queryLog = BusinessDataServiceHelper.newDynamicObject((String)"scmc_rpt_query_log");
            queryLog.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
            queryLog.set("start", (Object)new Date());
            queryLog.set("traceid", (Object)TraceIdUtil.getCurrentTraceIdString());
            queryLog.set("rpt", (Object)ctx.getReportEntity());
            queryLog.set("rptconf", ctx.getReportConf().getId());
            return queryLog;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    private static void buildLog(DynamicObject queryLog, ReportDataCtx ctx) {
        try {
            IAppCache cache;
            Integer val;
            queryLog.set("result", (Object)"1");
            int count = -1;
            String jobMsgKey = ctx.getJobMsgKey();
            if (StringUtils.isNotBlank((CharSequence)jobMsgKey) && (val = (Integer)(cache = AppCache.get((String)"bos")).get(jobMsgKey + "_count", Integer.class)) != null) {
                count = val;
            }
            queryLog.set("rowcount", (Object)count);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private static void saveLog(DynamicObject queryLog) {
        block14: {
            try {
                if (queryLog == null) break block14;
                Date start = queryLog.getDate("start");
                queryLog.set("usetime", (Object)(System.currentTimeMillis() - start.getTime()));
                try (TXHandle tx = TX.requiresNew((String)"ReportDataHandle.saveLog");){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{queryLog});
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private static void doAlgoXJobAfterApply(ReportDataCtx ctx, IOutputHandle outHandle, QueryType type) {
        String jobName = "report_" + ctx.getReportEntity();
        JobSession job = AlgoX.createSession((String)jobName);
        ctx.setCurrentJob(job);
        ReportDataHandle.setupCtx(ctx);
        ctx.logInfo("==============setupCtx==============");
        ctx.logInfo(ctx);
        ReportConf reportConf = ctx.getReportConf();
        List<SrcBlockConf> blockConfs = reportConf.getSrcBlockConf();
        blockConfs = blockConfs == null ? Collections.emptyList() : blockConfs;
        DataSetX allData = null;
        DataSetX blockData = null;
        Input[] inputs = null;
        Set<String> bigtableFilterCols = ReportDataHandle.buildAlineColFilter(ctx);
        List<Field> alinedCols = ReportDataHandle.getAlinedCols(ctx, bigtableFilterCols);
        Map<String, Field> tbColsMap = ReportDataHandle.getFieldMap(alinedCols);
        ctx.logInfo("==============alinedCols==============");
        ctx.logInfo(alinedCols);
        boolean autoBool2Str = ctx.isAutoBool2Str();
        ctx.logInfo("==============for SrcBlockConf ==============");
        for (SrcBlockConf srcBlockConf : blockConfs) {
            if (!srcBlockConf.isEnbale() || (inputs = ReportDataHandle.parseInput(bigtableFilterCols, srcBlockConf, ctx)) == null) continue;
            blockData = job.fromInput(inputs);
            if (autoBool2Str) {
                ReportDataHandle.handleBool2Str(blockData.getRowMeta(), srcBlockConf, tbColsMap);
            }
            blockData = ReportDataHandle.transFormBlockData(blockData, srcBlockConf, ctx);
            blockData = ReportDataHandle.alineCols(blockData, srcBlockConf.getSrcEntity(), alinedCols);
            allData = allData == null ? blockData : allData.union(blockData);
        }
        ReportDataHandle.reBuildQueryBlockCols(ctx, bigtableFilterCols);
        List<JoinBlockConf> queryBlocks = reportConf.getJoinBlockConf();
        ctx.logInfo("==============for JoinBlockConf ==============");
        for (JoinBlockConf queryBlock : queryBlocks) {
            if (!queryBlock.isEnbale() || (blockData = ReportDataHandle.buildDataSetX(queryBlock, ctx)) == null) continue;
            if (autoBool2Str) {
                ReportDataHandle.handleBool2Str(blockData.getRowMeta(), queryBlock, tbColsMap);
            }
            blockData = ReportDataHandle.transFormBlockData(blockData, queryBlock, ctx);
            blockData = ReportDataHandle.alineCols(blockData, queryBlock.getSrcEntity(), alinedCols);
            allData = allData == null ? blockData : allData.union(blockData);
        }
        if (allData == null) {
            allData = job.fromInput(ReportDataHandle.getEmptyInput(alinedCols));
        }
        allData = ReportDataHandle.transformDataX(allData, ctx);
        RowMeta rowMeta = allData.getRowMeta();
        int dataLimit = ctx.getDataLimit();
        if (dataLimit > 0) {
            String msgKey = jobName + DB.genGlobalLongId();
            ctx.setJobMsgKey(msgKey);
            allData = allData.reduceGroup((GroupReduceFunction)new LimitDataCount(rowMeta, dataLimit, msgKey));
        }
        Output output = outHandle.handle(allData);
        allData.output(output);
        job.commit(reportConf.getTimeOut(), TimeUnit.MINUTES);
    }

    private static void reBuildQueryBlockCols(ReportDataCtx ctx, Set<String> bigtableFilterCols) {
        List<JoinBlockConf> queryBlocks = ctx.getReportConf().getJoinBlockConf();
        Set<String> filterCols = null;
        for (JoinBlockConf queryBlock : queryBlocks) {
            filterCols = ReportDataHandle.filterBlockSelectCols(bigtableFilterCols, queryBlock, ctx);
            ReportDataHandle.reBuildQueryBlockCols(queryBlock, filterCols);
        }
    }

    private static void reBuildQueryBlockCols(JoinBlockConf queryBlock, Set<String> filterCols) {
        Map<String, String> repoColSrcColMap = queryBlock.getRepoColSrcColMap();
        HashMap<String, String> srcColRepoColMap = new HashMap<String, String>(repoColSrcColMap.size());
        for (String repoCol : filterCols) {
            srcColRepoColMap.put(repoColSrcColMap.get(repoCol), repoCol);
        }
        List<EntityInfo> entityInfos = queryBlock.getEntityInfos();
        List<ColAlias> colAliasList = null;
        ArrayList<ColAlias> newColAliasList = null;
        String repoCol = null;
        for (EntityInfo entityInfo : entityInfos) {
            colAliasList = entityInfo.getSelectCols();
            newColAliasList = new ArrayList<ColAlias>(colAliasList.size());
            for (ColAlias colAlias : colAliasList) {
                repoCol = (String)srcColRepoColMap.get(colAlias.getFinalCol());
                if (repoCol == null) continue;
                colAlias.setRepoCol(repoCol);
                newColAliasList.add(colAlias);
            }
            entityInfo.setSelectCols(newColAliasList);
        }
    }

    private static Map<String, QFilter> buildEntityFs(JoinBlockConf queryBlock, ReportDataCtx ctx) {
        QFilter userFilter = ReportDataHandle.buildUserFilter(ctx, queryBlock);
        QFilter dataFs = queryBlock.getDataFs();
        if (dataFs != null) {
            userFilter = userFilter == null ? dataFs : userFilter.and(dataFs);
        }
        Map<String, String> colEntityMap = queryBlock.getColEntityMap();
        HashMap<String, List<QFilter>> entityFilters = new HashMap<String, List<QFilter>>();
        if (userFilter != null) {
            QFilter[] fss = userFilter.recombine();
            ReportDataHandle.groupFsEntity(fss, entityFilters, colEntityMap);
        }
        HashMap<String, QFilter> resultFs = new HashMap<String, QFilter>(entityFilters.size());
        String key = null;
        for (Map.Entry entry : entityFilters.entrySet()) {
            key = (String)entry.getKey();
            QFilter tempFs = null;
            for (QFilter fsItem : (List)entry.getValue()) {
                tempFs = tempFs == null ? fsItem.copy() : tempFs.and(fsItem);
            }
            resultFs.put(key, tempFs);
        }
        return resultFs;
    }

    private static void groupFsEntity(QFilter[] fss, Map<String, List<QFilter>> entityFilters, Map<String, String> colEntityMap) {
        if (fss == null) {
            return;
        }
        String entity = null;
        List<QFilter> groupFs = null;
        for (QFilter fs : fss) {
            entity = ReportDataHandle.parseFsEntity(fs, colEntityMap);
            groupFs = entityFilters.get(entity);
            if (groupFs == null) {
                groupFs = new ArrayList<QFilter>(8);
                entityFilters.put(entity, groupFs);
            }
            groupFs.add(fs);
        }
    }

    private static void throwNotSameEntity(QFilter singleFs) {
        throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u8de8\u5b9e\u4f53\uff0c\u8bf7\u6838\u5bf9\u8fc7\u6ee4\u6761\u4ef6\u6b63\u786e\u6027fs={0}", (String)"ReportDataHandle_6", (String)"mpscmm-mscommon-report", (Object[])new Object[]{singleFs}));
    }

    private static String parseFsEntity(QFilter fs, Map<String, String> colEntityMap) {
        String entity = ReportDataHandle.parseSingleFsEntity(fs, colEntityMap);
        List nests = fs.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            String op = nest.getOp();
            if (!"or".equalsIgnoreCase(op) || entity.equals(ReportDataHandle.parseSingleFsEntity(nest.getFilter(), colEntityMap))) continue;
            ReportDataHandle.throwNotSameEntity(fs);
        }
        return entity;
    }

    private static String parseSingleFsEntity(QFilter singleFs, Map<String, String> colEntityMap) {
        String repoCol = singleFs.getProperty();
        String col = repoCol.split("\\.")[0];
        String entity = colEntityMap.get(col);
        if (entity == null) {
            entity = "t1";
        }
        if (singleFs.isExpressValue()) {
            Object val = singleFs.getValue();
            if (val instanceof String) {
                String valCol = ((String)val).split("\\.")[0];
                String valEntity = colEntityMap.get(valCol);
                if (valEntity == null) {
                    valEntity = "t1";
                } else if (!entity.equals(valEntity)) {
                    ReportDataHandle.throwNotSameEntity(singleFs);
                }
            } else {
                ReportDataHandle.throwCanParse(singleFs);
            }
        }
        return entity;
    }

    private static DataSetX buildDataSetX(JoinBlockConf queryBlock, ReportDataCtx ctx) {
        String loadType = queryBlock.getLoadType();
        if (JoinBlockConf.LOAD_NO_FS.equals(loadType)) {
            return ReportDataHandle.buildDataSetXByNoFs(queryBlock, ctx);
        }
        if (JoinBlockConf.LOAD_SUP_QUERY.equals(loadType)) {
            return ReportDataHandle.buildDataSetXBySupQuery(queryBlock, ctx);
        }
        return ReportDataHandle.buildDataSetXByUseFs(queryBlock, ctx);
    }

    private static DataSetX buildDataSetXByUseFs(JoinBlockConf queryBlock, ReportDataCtx ctx) {
        List<EntityInfo> entityInfos = queryBlock.getEntityInfos();
        if (entityInfos.isEmpty()) {
            return null;
        }
        Map<String, QFilter> entityFs = ReportDataHandle.buildEntityFs(queryBlock, ctx);
        for (EntityInfo entityInfo : entityInfos) {
            QFilter fs = entityFs.get(entityInfo.getAlias());
            if (fs != null && (fs = ReportDataHandle.transFs(fs, queryBlock)) == null) {
                return null;
            }
            if (!entityInfo.isMainEntity()) {
                QFilter onFs = entityInfo.buildOnFilter();
                if (fs == null) {
                    fs = onFs;
                } else if (onFs != null) {
                    fs = fs.and(onFs);
                }
            }
            entityInfo.buildDataSet(fs);
            entityInfo.buildPushVals();
        }
        DataSet mainData = null;
        JoinDataSet joinData = null;
        EntityInfo entityInfo = null;
        int len = entityInfos.size();
        for (int i = 0; i < len; ++i) {
            entityInfo = entityInfos.get(i);
            if (i == 0) {
                mainData = entityInfo.getData();
                continue;
            }
            joinData = mainData.join(entityInfo.getData(), entityInfo.buildJoinType());
            int jLen = entityInfo.getEntityOnCols().size();
            for (int j = 0; j < jLen; ++j) {
                joinData = joinData.on(entityInfo.getJoinEntity().getColAs().get(entityInfo.getOtherEntityOnCols().get(j)), entityInfo.getColAs().get(entityInfo.getEntityOnCols().get(j)));
            }
            String[] leftCols = mainData.getRowMeta().getFieldNames();
            String[] rightCols = entityInfo.getData().getRowMeta().getFieldNames();
            mainData = joinData.select(leftCols, rightCols).finish();
        }
        if (mainData != null) {
            String[] finalSelectCols = ReportDataHandle.buildfinalSelectCols(queryBlock);
            mainData = mainData.select(finalSelectCols);
        }
        JobSession job = ctx.getCurrentJob();
        return job.fromInput((Input)new DataSetInput(mainData));
    }

    private static DataSetX buildDataSetXBySupQuery(JoinBlockConf queryBlock, ReportDataCtx ctx) {
        return ReportDataHandle.buildDataSetXByUseFs(queryBlock, ctx);
    }

    private static DataSetX buildDataSetXByNoFs(JoinBlockConf queryBlock, ReportDataCtx ctx) {
        List<EntityInfo> entityInfos = queryBlock.getEntityInfos();
        if (entityInfos.isEmpty()) {
            return null;
        }
        Map<String, QFilter> entityFs = ReportDataHandle.buildEntityFs(queryBlock, ctx);
        JobSession job = ctx.getCurrentJob();
        DataSetX mainDataX = null;
        DataSetX rightDataX = null;
        JoinDataSetX joinDataX = null;
        EntityInfo entityInfo = null;
        int len = entityInfos.size();
        for (int i = 0; i < len; ++i) {
            entityInfo = entityInfos.get(i);
            QFilter fs = entityFs.get(entityInfo.getAlias());
            if (fs != null && (fs = ReportDataHandle.transFs(fs, queryBlock)) == null) {
                return null;
            }
            if (i == 0) {
                mainDataX = job.fromInput(entityInfo.buildInput(fs));
                continue;
            }
            rightDataX = job.fromInput(entityInfo.buildInput(fs));
            JoinType type = entityInfo.buildJoinType();
            joinDataX = type == JoinType.LEFT ? mainDataX.leftJoin(rightDataX) : (type == JoinType.FULL ? mainDataX.fullJoin(rightDataX) : mainDataX.join(rightDataX));
            int jLen = entityInfo.getEntityOnCols().size();
            for (int j = 0; j < jLen; ++j) {
                joinDataX = joinDataX.on(entityInfo.getJoinEntity().getColAs().get(entityInfo.getOtherEntityOnCols().get(j)), entityInfo.getColAs().get(entityInfo.getEntityOnCols().get(j)));
            }
            String[] leftCols = mainDataX.getRowMeta().getFieldNames();
            String[] rightCols = rightDataX.getRowMeta().getFieldNames();
            mainDataX = joinDataX.select(leftCols, rightCols);
        }
        if (mainDataX != null) {
            mainDataX = mainDataX.map((MapFunction)new AsNameFunc(mainDataX.getRowMeta(), ReportDataHandle.rebuildAsName(queryBlock)));
        }
        return mainDataX;
    }

    private static Map<String, String> rebuildAsName(JoinBlockConf queryBlock) {
        List<EntityInfo> entityInfos = queryBlock.getEntityInfos();
        HashMap<String, String> result = new HashMap<String, String>(entityInfos.size() * 20);
        for (EntityInfo entityInfo : entityInfos) {
            for (ColAlias col : entityInfo.getSelectCols()) {
                result.put(entityInfo.getColAs().get(col.getCol()), col.getRepoCol());
            }
        }
        return result;
    }

    private static String[] buildfinalSelectCols(JoinBlockConf queryBlock) {
        List<EntityInfo> entityInfos = queryBlock.getEntityInfos();
        ArrayList<String> result = new ArrayList<String>(entityInfos.size() * 20);
        for (EntityInfo entityInfo : entityInfos) {
            for (ColAlias col : entityInfo.getSelectCols()) {
                result.add(entityInfo.getColAs().get(col.getCol()) + " " + col.getRepoCol());
            }
        }
        return result.toArray(new String[0]);
    }

    private static void handleBool2Str(RowMeta rowMeta, RptBlockConf blockConf, Map<String, Field> fieldMap) {
        Field[] fields = rowMeta.getFields();
        HashSet<String> bool2StrCol = new HashSet<String>(8);
        String name = null;
        Field tbCol = null;
        for (Field field : fields) {
            name = field.getName();
            tbCol = fieldMap.get(name);
            if (tbCol == null || !DataType.StringType.equals((Object)tbCol.getDataType()) || !DataType.BooleanType.equals((Object)field.getDataType())) continue;
            bool2StrCol.add(name);
        }
        if (!bool2StrCol.isEmpty()) {
            blockConf.getDataTransform().add(new Bool2StrTransform(bool2StrCol));
        }
    }

    private static final Map<String, Field> getFieldMap(List<Field> fs) {
        HashMap<String, Field> fMap = new HashMap<String, Field>(32);
        for (Field f : fs) {
            fMap.put(f.getName(), f);
        }
        return fMap;
    }

    private static DataSet transformResult(DataSet result, ReportDataCtx ctx) {
        List<IReportDataHandle> plugins = ctx.getReportConf().getPlugins();
        ArrayList<IDataTransform> transCollector = new ArrayList<IDataTransform>(3);
        for (IReportDataHandle plugin : plugins) {
            plugin.transformResult(transCollector, ctx);
        }
        ctx.logInfo("==============transformResult==============");
        ctx.logInfo(transCollector);
        for (IDataTransform transform : transCollector) {
            result = transform.doTransform(result);
        }
        return result;
    }

    private static void setupCtx(ReportDataCtx ctx) {
        ReportConf reportConf = ctx.getReportConf();
        for (IReportDataHandle plugin : reportConf.getPlugins()) {
            plugin.setupCtx(ctx);
        }
        List<SrcBlockConf> srcBlockConfs = reportConf.getSrcBlockConf();
        List<JoinBlockConf> joinBlockConfs = reportConf.getJoinBlockConf();
        srcBlockConfs = ReportDataHandle.filterBlock(srcBlockConfs);
        for (IReportDataHandle plugin : reportConf.getPlugins()) {
            plugin.modifyBlocks(srcBlockConfs, ctx);
            plugin.modifyJoinBlocks(joinBlockConfs, ctx);
        }
    }

    private static void buildDefSumPlans(ReportDataCtx ctx) {
        if (ctx.isUseDefSum()) {
            ArrayList<RowSumPlan> plans = new ArrayList<RowSumPlan>(2);
            Set<String> sumKeyCols4Count = ctx.getSumKeyCols4Count();
            if (sumKeyCols4Count != null && sumKeyCols4Count.size() > 0) {
                plans.add(new RowSumPlan("1", sumKeyCols4Count, ctx.getSumQtyCols4Count()));
            }
            if (ctx.isShowTotalQty()) {
                RowSumPlan rowSumPlan = new RowSumPlan("2", null, ctx.getSumQtyCols4Count());
                rowSumPlan.setAsynQueryKey((String)ctx.getParam("asynQueryKey"));
                plans.add(rowSumPlan);
            }
            ctx.setSumPlans(plans);
        }
    }

    private static DataSetX transformDataX(DataSetX allData, ReportDataCtx ctx) {
        List<IReportDataHandle> plugins = ctx.getReportConf().getPlugins();
        ArrayList<IDataXTransform> transCollector = new ArrayList<IDataXTransform>(3);
        for (IReportDataHandle iReportDataHandle : plugins) {
            iReportDataHandle.transFormAfterUnion(transCollector, ctx);
        }
        ctx.logInfo("==============transFormAfterUnion===============");
        ctx.logInfo(transCollector);
        allData = ReportDataHandle.doMR(allData, transCollector);
        ReportDataHandle.buildDefGroupPlan(ctx);
        for (IReportDataHandle iReportDataHandle : plugins) {
            iReportDataHandle.beforeGroupData(ctx);
        }
        transCollector.clear();
        GroupPlan groupPlan = ctx.getGroupPlan();
        if (groupPlan != null) {
            transCollector.add(new GroupTransform(groupPlan));
        }
        for (IReportDataHandle plugin : plugins) {
            plugin.transFormAfterGroup(transCollector, ctx);
        }
        ctx.logInfo("==============transFormAfterGroup==============");
        ctx.logInfo(transCollector);
        allData = ReportDataHandle.doMR(allData, transCollector);
        ReportDataHandle.buildDefSumPlans(ctx);
        for (IReportDataHandle plugin : plugins) {
            plugin.beforeAddSumRow(ctx);
        }
        transCollector.clear();
        List<RowSumPlan> list = ctx.getSumPlans();
        if (list != null && list.size() > 0) {
            transCollector.add(new RowSumTransform(list));
        }
        for (IReportDataHandle plugin : plugins) {
            plugin.transFormAfterAddSumRow(transCollector, ctx);
        }
        ctx.logInfo("==============transFormAfterAddSumRow==============");
        ctx.logInfo(transCollector);
        allData = ReportDataHandle.doMR(allData, transCollector);
        return allData;
    }

    private static void buildDefGroupPlan(ReportDataCtx ctx) {
        if (ctx.isUseDefGroup()) {
            ArrayList<String> showKeyCols = new ArrayList<String>(ctx.getShowKeyCols());
            if (ctx.isShowBlockEntity()) {
                showKeyCols.add("block_entity");
            }
            ArrayList<String> qtyCols = new ArrayList<String>(ctx.getSumQtyCols4Count());
            ctx.setGroupPlans(new GroupPlan(showKeyCols, qtyCols));
        }
    }

    private static List<SrcBlockConf> filterBlock(List<SrcBlockConf> blockConfs) {
        return blockConfs;
    }

    private static DataSetX transFormBlockData(DataSetX blockData, RptBlockConf blockConf, ReportDataCtx ctx) {
        blockData = ReportDataHandle.addDefVal4BlockData(blockData, blockConf, ctx);
        List<IDataXTransform> transforms = blockConf.getDataTransform();
        return ReportDataHandle.doMR(blockData, transforms);
    }

    private static DataSetX addDefVal4BlockData(DataSetX blockData, RptBlockConf blockConf, ReportDataCtx ctx) {
        Map<String, Object> defVals = blockConf.getDefVals();
        if (defVals == null || defVals.isEmpty()) {
            return blockData;
        }
        Field[] fields = new Field[defVals.size()];
        Object[] vals = new Object[defVals.size()];
        List<BigTableColConf> bigTableColConfs = ctx.getReportConf().getBigTableColConf();
        int i = 0;
        String col = null;
        DataType type = null;
        for (BigTableColConf bigTableColConf : bigTableColConfs) {
            col = bigTableColConf.getCol();
            if (!defVals.containsKey(col)) continue;
            type = bigTableColConf.getDataType();
            fields[i] = new Field(col, type);
            vals[i] = defVals.get(col);
            ++i;
        }
        return blockData.addFields(fields, vals);
    }

    private static DataSetX doMR(DataSetX data, List<IDataXTransform> transforms) {
        if (transforms != null) {
            for (IDataXTransform transform : transforms) {
                data = transform.doTransform(data);
            }
        }
        return data;
    }

    private static class QfilterFunction
    implements Function<QFilter, QFilter> {
        Map<String, String> colMap = null;
        Map<String, Object> defValMap = null;
        boolean notMatchCol = false;
        private QFilterEval evalor;

        public QfilterFunction(RptBlockConf conf) {
            this.colMap = conf.getRepoColFullSrcColMap();
            this.defValMap = conf.getDefVals();
            this.evalor = new QFilterEval(this.defValMap);
        }

        @Override
        public QFilter apply(QFilter f) {
            String repoCol = f.getProperty();
            CharSequence[] splitCols = repoCol.split("\\.");
            String srcCol = this.colMap.get(splitCols[0]);
            if (srcCol == null) {
                if (this.defValMap.containsKey(splitCols[0])) {
                    boolean defMatch = new QFilter(f.getProperty(), f.getCP(), f.getValue()).eval((QFilterEvaluator)this.evalor);
                    return new QFilter("1", "=", (Object)(defMatch ? 1 : 2));
                }
                this.notMatchCol = true;
                return new QFilter("1", "=", (Object)1);
            }
            splitCols[0] = srcCol;
            if (f.isExpressValue()) {
                Object val = f.getValue();
                if (val instanceof String) {
                    CharSequence[] splitValCols = ((String)val).split("\\.");
                    String valCol = this.colMap.get(splitValCols[0]);
                    if (valCol == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6761\u4ef6\u201c{0}\u201d\u65e0\u6cd5\u8f6c\u8bd1\u4e3a\u6570\u636e\u6e90\u6761\u4ef6\uff0c\u5b57\u6bb5\u201c{1}\u201d\u6ca1\u6709\u6620\u5c04\u3002", (String)"ReportDataHandle_3", (String)"mpscmm-mscommon-report", (Object[])new Object[]{f, valCol}));
                    }
                    splitValCols[0] = valCol;
                    f.__setValue((Object)String.join((CharSequence)".", splitValCols));
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6761\u4ef6\u201c{0}\u201d\u65e0\u6cd5\u8f6c\u8bd1\u4e3a\u6570\u636e\u6e90\u6761\u4ef6\uff0c\u8bf7\u5c1d\u8bd5\u8f93\u5165\u5176\u4ed6\u6761\u4ef6\u3002", (String)"ReportDataHandle_4", (String)"mpscmm-mscommon-report", (Object[])new Object[]{f}));
                }
            }
            f.__setProperty(String.join((CharSequence)".", splitCols));
            Object value = f.getValue();
            if (value instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue oldValue = (MultiBaseDataFilterValue)value;
                MultiBaseDataFilterValue v = new MultiBaseDataFilterValue(oldValue.getBaseDataName(), (String)splitCols[0], oldValue.getValue());
                f.__setValue((Object)v);
            }
            return f;
        }
    }

    private static class ColMapInfo {
        String repoCol;
        String col;
        String fullCol;
        Object defVal;

        public ColMapInfo(String repoCol, String col, String fullCol, String defVal) {
            this.repoCol = repoCol;
            this.col = col;
            this.fullCol = fullCol;
            this.defVal = defVal;
        }
    }
}

